//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.85;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.85] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * ---
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Status
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 * 
 * - Status
 *   - Adds a status command to view the current inputting actor's status.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * <Help Description>
 *  text
 *  text
 * </Help Description>
 *
 * - Used for: State Notetags
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - This is used as a common notetag between Battle Core's state descriptions
 *   and State Tooltips' state descriptions.
 * 
 * ---
 * 
 * <In-Battle Status Description>
 *  text
 *  text
 * </In-Battle Status Description>
 * - Assigns a help description for the state that's displayed under the
 *   "Status" actor command.
 * - Replace 'text' with text you want displayed for the help window.
 * - This best works with one line for compatibility with other plugins.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 * - The description used here will not be used for State Tooltips.
 * - If both <Help Description> and <In-Battle Status Description> notetags
 *   exist in the same state, priority will be given to this one for the
 *   In-Battle Status Window.
 *
 * ---
 * 
 * <Exclude From Status Listing>
 * 
 * - Used for: State Notetags
 * - Excludes the state from being displayed in the status listing.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 * 
 * <Target: Ally or Enemy>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Target: Enemy or Ally>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Single or Multiple Select>
 * 
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 * 
 * ---
 * 
 * <Disperse Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 * 
 * ---
 * 
 * <Cannot Target User>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 * 
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Accuracy>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy>
 * 
 * - Used for: Skill, Item Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the accuracy hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - Works best with VisuMZ Core Engine's "Improved Accuracy" QoL formula in
 *   order to consolidate both HIT and EVA.
 * 
 * ---
 * 
 * <JS Accuracy as User>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as User>
 * 
 * <JS Accuracy as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Accuracy as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   accuracy hit success rate.
 *   - Base value comes from Game_Action.itemHit
 *   - Skill/Item <JS Accuracy> runs
 *   - Then <JS Accuracy as User/Target> notetags run
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * 
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 * 
 * <Popup Position: Head>
 * <Popup Position: Center>
 * <Popup Position: Base>
 * 
 * - Used for: Enemy Notetags
 * - Determines the popup starting position for this enemy.
 *   - Head makes the popups start at the top of the ennemy.
 *   - Center makes the popups start at the center of the ennemy.
 *   - Base makes the popups start at the bottom of the ennemy.
 * - If this notetag is not used, refer to the default Plugin Parameter setting
 *   found in Damage Settings.
 * 
 * ---
 * 
 * <Popup Offset X: +x>
 * <Popup Offset X: -x>
 * <Popup Offset Y: +y>
 * <Popup Offset Y: -y>
 * 
 * - Used for: Enemy Notetags
 * - Alters the popup x/y position offset for this enemy.
 * - Replace 'x' with a number representing the horizontal position x offset.
 *   - Negative: left. Positive: right.
 * - Replace 'y' with a number representing the vertical position y offset.
 *   - Negative: up. Positive: down.
 * - If these notetags are not used, refer to the default Plugin Parameter
 *   settings found in Damage Settings.
 * 
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Rate as User>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as User>
 *
 * <JS Critical Rate as Target>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate as Target>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Only applies during battle.
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 *   - Base value comes from Game_Action.itemCri
 *   - Skill/Item <JS Critical Rate> runs
 *   - Then <JS Critical Rate as User/Target> notetags run
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 * 
 * === Life Steal-Related Notetags ===
 * 
 * ---
 * 
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 * 
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take MP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 * 
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 * 
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 * 
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Cancel Life Steal>
 * 
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 * 
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Guard Life Steal>
 * 
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Disarm Life Steal>
 * 
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Negative Life Steal>
 * 
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Bypass Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 * 
 * <Aspect Name: name>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'name' with text for how enemy aspect should be renamed.
 * 
 * ---
 * 
 * <Aspect Color: color>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect name color shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'color' with either a number from 0 to 31 representing the text
 *   color or in the format of '#rrggbb' to custom pick a hex color.
 * 
 * ---
 * 
 * <Aspect Icon: x>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect icon shown in the In-Battle Status and other
 *   supported plugin menus.
 *   - Requires <Aspect Description> in order to show.
 * - Replace 'x' with a number representing the icon index used to represent
 *   the enemy aspect.
 * 
 * ---
 * 
 * <Aspect Description>
 *  text
 *  text
 * </Aspect Description>
 * 
 * - Used for: Enemy Notetags
 * - Changes enemy's aspect description shown in the In-Battle Status and other
 *   supported plugin menus.
 * - Replace 'text' with the text you would like to appear as a description for
 *   the enemy's aspect.
 * 
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * === Troop Size Tags ===
 * 
 * ---
 * 
 * <Extend: x>
 * <Extend: x, x, x>
 * 
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 * 
 * ---
 * 
 * === Troop Comment Tags ===
 * 
 * Place these tags inside of a comment found in a troop page's event list.
 * 
 * ---
 * 
 * <Once Parallel When Start Battle>
 * 
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 * 
 * ANIM: Balloon Animation
 * - Plays a balloon animation on target(s).
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Balloon Type:
 *   - What kind of balloon should be played on target(s)?
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Single)
 * - Plays a balloon animation using an icon on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Range)
 * - Plays a balloon animation an icon range on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Starting Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Ending Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Specific)
 * - Plays a balloon animation with specific icons on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icons:
 *   - Insert the ID(s) of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Change Battle Portrait (JS)
 * - Changes the battle portrait of the actor through JavaScript.
 * - Can be used outside of battle/action sequences.
 * 
 *   JS: Actor ID:
 *   - Enter which Actor ID to affect.
 *   - Uses JavaScript code.
 * 
 *   JS: Filename:
 *   - Enter the filename you wish to use.
 *   - Uses JavaScript code.
 * 
 * ---
 *
 * ANIM: Guard Animation
 * - Plays the animation associated with the user's guard action (if any).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Item Animation
 * - Plays the animation associated with a specific item.
 * 
 *   Item ID:
 *   - Which item ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Show Animation JS
 * - Plays the a specific animation on unit(s).
 * - Uses JavaScript to determine animation ID.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   JS: Animation ID:
 *   - Select which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Skill Animation
 * - Plays the animation associated with a specific skill.
 * 
 *   Skill ID:
 *   - Which skill ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 * 
 * === Action Sequences - Cutins ===
 * 
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Basic Settings:
 * 
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 * 
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 * 
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 * 
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 * 
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 * 
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 * 
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Grid ===
 * 
 * These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * ---
 * 
 * GRID: Action Animation at Node
 * - Plays action animation at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * GRID: Add Passive State(s) to Node
 * - Adds Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to add as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Passive State(s) to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Passive State(s) to.
 *
 * ---
 * 
 * GRID: Add Trigger to Node
 * - Adds Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Skill ID:
 *   - Select which Skill ID(s) to add as the trigger.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Add Trigger to Node JS
 * - Adds JS Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   JS: Skill ID:
 *   - Use JavaScript to determine what skill ID to add to this node.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Animation ID at Node
 * - Plays specific animation ID at target node.
 * 
 *   Animation ID:
 *   - Play this animation at target node.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation JS at Node
 * - Uses JS to calculate which animation to play at target node.
 * 
 *   JS: Animation ID:
 *   - Calculate which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation Type at Node
 * - Plays certain animation type at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Type:
 *   - What is the animation type you would like to play?
 *     - Attack
 *     - Guard
 *     - Item
 *     - Skill
 * 
 *     Slot (Attack Type):
 *     - Which weapon slot to get this data from?
 *     - Main-hand weapon is weapon slot 1.
 * 
 *     Item ID (Item Type):
 *     - Which item ID will the animation come from?
 * 
 *     Skill ID (Skill Type):
 *     - Which skill ID will the animation come from?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Move Target(s) In Direction
 * - Moves target(s) in a specific direction to other Nodes.
 * - Requires VisuMZ_2_BattleGridSystem!
 * - This will bypass the "once per action" condition used for both the
 *   <rule Move User Node direction: x> & <rule Move Target Node direction: x>
 *   notetags as this is not a notetag effect.
 * 
 *   Targets:
 *   - Select unit(s) to move.
 * 
 *   Movement Type:
 *   - Select the Movement type rulings.
 *   - See VisuMZ_2_BattleGridSystem help file for details.
 * 
 *     Direction:
 *     - Select the movement direction.
 * 
 *     Distance:
 *     - The number of nodes to be moved.
 *     - You may use JavaScript code.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 *   Silent Change?:
 *   - Silent: Discreet changes shown. More apparent later.
 *   - Visual: Instant changes shown.
 * 
 * ---
 * 
 * GRID: Pull To Target Node
 * - Pulls battlers towards target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to pull on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       pull to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       pull to.
 * 
 *   Strength:
 *   - Input the strength level of the pull.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 * 
 * GRID: Push From Target Node
 * - Pushes battlers away from target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to push from?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       push from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       push from.
 * 
 *   Strength:
 *   - Input the strength level of the push.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 *
 * GRID: Remove All Passive States from Node
 * - Removes all Passive State effects at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear the Node for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Passive States from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Passive States from.
 *
 * ---
 *
 * GRID: Remove Passive State(s) from Node
 * - Remove Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to remove as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to remove the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to remove
 *       a Passive State(s) from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to remove
 *       a Passive State(s) from.
 *
 * ---
 * 
 * GRID: Remove Trigger from Node
 * - Removes Trigger at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to clear Triggers for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Triggers from.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Triggers from.
 * 
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 * 
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 * 
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 * 
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 * 
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 * 
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 * 
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 * 
 *   Offset:
 * 
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 * 
 * ---
 * 
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 * 
 * ---
 * 
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 * 
 *   Pause?:
 *   - Pause the injected animation?
 * 
 * ---
 * 
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 * 
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 * 
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 * 
 * MECH: Emulate Attack Effect
 * - Emulate an "Action Effect" but using a the user's attack skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Guard Effect
 * - Emulate an "Action Effect" but using a the user's guard skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Item Effect
 * - Emulate an "Action Effect" but using a specific item instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Item ID:
 *   - Which item ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Cost
 * - Pick a skill for target(s) to emulate paying the cost of.
 * - Lets you cause characters to perform paying the costs of a specific skill
 *   without needing to actually use them.
 * - This will include Skill Cooldowns and Limited Skill Uses.
 * 
 *   Skill ID:
 *   - Which skill ID will have its cost paid for?
 *   - Use 0 for current action's skill.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Effect
 * - Emulate an "Action Effect" but using a specific skill instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Skill ID:
 *   - Which skill ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: State Turns Change By
 * - Changes target(s) state turns by an amount.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: State Turns Change To
 * - Changes target(s) state turns to a specific value.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if target(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To JS Coordinates
 * - Change home position(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s)'s new home
 *     position.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face JS Coordinates
 * - Causes the unit(s) to face specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to face
 *     towards.
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To JS Coordinates
 * - Moves unit(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to move to.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 * 
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 * 
 * === Action Sequences - Voice ==
 * 
 * ---
 *
 * VOICE: Common Line
 * - Plays a common voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line:
 *   - What voice line do you wish to play?
 *
 * ---
 *
 * VOICE: Play Special Line
 * - Plays a special voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line Type:
 *   - What voice line type do you wish to play?
 *     - Action Name
 *     - Chant Line
 *     - Item Name
 *     - Skill Name
 *     - Spell Name
 *     - Unique Lines
 *
 *   Name / Letter:
 *   - What voice letter/name do you want to play?
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   End Battle Show?:
 *   - Show or hide popups upon victory or escape?
 *   - Used to hide battle-state removal popups.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   Turn End Buffs Expire?:
 *   - Normally, buffs expire after all actions end.
 *   - But here, you can have buffs expire on turn end.
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 * 
 * UI Elements
 * 
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 * 
 *     Wait Frames:
 *     - How many frames should the battle log wait after text?
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Status?:
 *   - Add the "Status" command to the Command Window?
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Status
 *       - Adds the status command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: In-Battle Status Window
 * ============================================================================
 *
 * Added with Battle Core version 1.84, this new window allows the player to
 * view the status of the current active party. If the actors have states and
 * buffs, the player can scroll through them and read about their effects
 * through the help window.
 * 
 * If you would like to manage which parameters can appear here, this can be
 * done through the VisuMZ_0_CoreEngine's "Parameter Settings" and adjust which
 * parameters are shown through "Extended Parameters". These settings will
 * reflect in the In-Battle Status window, too. Otherwise, the parameters that
 * will be shown will only be MaxHP, MaxMP, ATK, DEF, MAT, MDF, AGI, and LUK.
 * 
 * The In-Battle Status can also be used to view enemies (if the parameter is
 * enabled). To view enemies, players must scroll through all the actors before
 * viewing enemies. Enemies will have their battler graphic displayed. If the
 * enemy has a SV Battler graphic, that will be displayed instead. However, if
 * the enemy has a Dragonbones, then the database battler graphic is displayed
 * to match any of the turn order displays as those also use the same graphic.
 * 
 * Enemies will not display the current HP on their In-Battle Status gauges.
 * Instead, they will display what percentage their HP, MP, and/or TP is at.
 * This is primarily due to how gauges do not support large numbers well and
 * showing the percentage values are better for this scene.
 *
 * ---
 * 
 * General Settings
 * 
 *   Status Icon:
 *   - The icon used for the Status command.
 * 
 *   Status Graphic:
 *   - Choose how the actor graphic appears for In-Battle Status.
 * 
 *   Help Description:
 *   - Text displayed when selecting the Status command.
 * 
 * ---
 * 
 * Enemy Settings
 * 
 *   Allow View Enemies?:
 *   - Allows players to view enemy stats (even if limited)?
 * 
 *   Show Level?:
 *   - Shows the enemy's level in the In-Battle Status?
 * 
 *   Hidden Parameter:
 *   - The text that appears if a parameter value is hidden.
 * 
 *     Show Params Always:
 *     - Always show exact enemy parameter values.
 * 
 *     Show Battle Test:
 *     - Show exact enemy parameter values in battle test.
 * 
 *     Show If Defeated:
 *     - Show exact enemy parameter values if enemy has been defeated before.
 * 
 * ---
 * 
 * Page Buttons:
 * 
 *   Show Page Buttons?:
 *   - Shows page buttons to switch between actors?
 *   - Still requires Touch UI option to be on.
 * 
 *   Large UI Position?:
 *   - If using a large resolution, position the page buttons on which side?
 * 
 *  Offset X
 *  - Offsets the page buttons x position.
 *  - Negative: left. Positive: right.
 * 
 *  Offset Y
 *  - Offsets the page buttons y position.
 *  - Negative: up. Positive: down.
 * 
 * ---
 * 
 * Parameter Display
 * 
 *   Increased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 *   Decreased Value
 *   - How are increased parameter values displayed?
 *   - %1 - Parameter Value
 * 
 * ---
 * 
 * States Display
 * 
 *   Max Width
 *   - Maximum width of the states list display.
 * 
 *   List States?
 *   - Lists states in the states list display?
 * 
 *   List Buffs?
 *   - Lists buffs in the states list display?
 * 
 *   List Debuffs?
 *   - Lists debuffs in the states list display?
 * 
 *   Buffs/Debuffs Display:
 * 
 *     Buff Name Format
 *     - Text format used to represent buffs.
 *     - %1 - Parameter Name
 * 
 *     Debuff Name Format
 *     - Text format used to represent debuffs.
 *     - %1 - Parameter Name
 * 
 *   Normal State:
 * 
 *     Normal Icon
 *     - Icon used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 *     Normal Text
 *     - Text used to represent normal state (unaffected by states, buffs, or
 *       debuffs).
 * 
 * ---
 * 
 * Help Descriptions
 * 
 *   State Help Format:
 *   - Text format used for state help descriptions
 *   - %1 - Description; %2 - Turns/Actions Remaining
 * 
 *   Buff Help Format:
 *   - Text format used for Buff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Debuff Help Format:
 *   - Text format used for Debuff help descriptions
 *   - %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * 
 *   Normal State:
 *   - Help description used to explain normal state (unaffected by states,
 *     buffs, or debuffs).
 * 
 *   Turns/Actions Left:
 * 
 *     Actions Format:
 *     - Text format used to represent actions remaining.
 *     - %1 - Actions; %2 - Color
 * 
 *     Turns Format:
 *     - Text format used to represent turns remaining.
 *     - %1 - Turns; %2 - Color
 * 
 *     Passive Text:
 *     - Text used to represent a passive.
 * 
 * ---
 * 
 * Window Settings
 * 
 *   Background Type:
 *   - Select background type for this window.
 * 
 *   JS: Draw Data:
 *   - Code used to draw battler data.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 * 
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 * 
 * Properties
 * 
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 * 
 *   Background Type:
 *   - Select background type for these windows.
 * 
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 * ---
 * 
 * Vocab
 * 
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 * 
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 * 
 * ---
 * 
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 * 
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Combo Window Settings
 * ============================================================================
 * 
 * If enabled, this window will display updated information about the total
 * amount of hits performed and total damage/healing value executed for HP.
 * 
 * This only applies when HP damage is directly dealt through action effects.
 * It does NOT apply for MP damage, TP damage, states, regeneration, or event
 * commands.
 * 
 * If you would like to adjust the Damage Combo Window mid-action, you can use
 * the following script calls to do so:
 * 
 *     $comboWindowReset()
 *     - Resets the all values found in the damage combo window.
 * 
 *     $comboWindowIncreaseHits(x)
 *     - Increases the current hit counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - Example: $comboWindowIncreaseHits(2)
 * 
 *     $comboWindowIncreaseDamage(x)
 *     - Increases the current total damage counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any healing added in the damage counter window.
 *     - Example: $comboWindowIncreaseDamage(100)
 * 
 *     $comboWindowIncreaseHealing(x)
 *     - Increases the current total heal counter in the combo window by 'x'.
 *     - Insert a number for 'x'.
 *     - This will offset any damage added in the damage counter window.
 *     - Example: $comboWindowIncreaseHealing(200)
 * 
 * ---
 * 
 * General Settings:
 * 
 *   Enable?:
 *   - Add the Combo Window to show in battle?
 * 
 * ---
 * 
 * Appearance Settings:
 * 
 *   Custom Font:
 *   - Insert the custom font face name here.
 *   - Use VisuMZ_1_MessageCore to register new fonts.
 * 
 *   Text Align:
 *   - Text alignment for this window?
 * 
 *   JS: Draw Data:
 *   - Code used to draw the data in this window.
 * 
 * ---
 * 
 * Vocabulary:
 * 
 *   Damage Combo Format:
 *   - Text format used to display total hits for damage.
 *   - %1 - Total Hits
 * 
 *   Healing Combo Format:
 *   - Text format used to display total hits for healing.
 *   - %1 - Total Hits
 * 
 *   Damage Total Format:
 *   - Text format used to display total value for damage.
 *   - %1 - Total Damage
 * 
 *   Healing Total Format:
 *   - Text format used to display total value for healing.
 *   - %1 - Total Healing
 * 
 * ---
 * 
 * Position Settings:
 * 
 *   Fade Shift X:
 *   - Shifts the windows x position when fading.
 *   - Negative: left. Positive: right.
 * 
 *   Fade Shift Y:
 *   - Shifts the windows y position when fading.
 *   - Negative: up. Positive: down.
 * 
 *   Offset X:
 *   - Offsets the windows x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the windows y position.
 *   - Negative: up. Positive: down.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 * 
 * ---
 * 
 * Updating Settings:
 * 
 *   Number Roll Duration:
 *   - Frame duration to roll damage numbers.
 *   - 60 frames = 1 second.
 * 
 *   Minimum Stay Duration:
 *   - Frame duration to stay visible minimum. 
 *   - 60 frames = 1 second.
 * 
 *   Minimum Hit Visible:
 *   - Minimum hits before combo window becomes visible?
 * 
 *   Opacity Speed:
 *   - Opacity speed when fading in/out.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 * 
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 * 
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 * 
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 * 
 * Frontview Battlers
 * 
 *   Portrait Animations:
 * 
 *     Each Target:
 *     - Place animations on top for "Each Target" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of All:
 *     - Place animations on top for "Center of All" display types?
 *     - Does not apply to MV animations.
 * 
 *     Center of Screen:
 *     - Place animations on top for "Center of Screen" display types?
 *     - Does not apply to MV animations.
 * 
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor:
 * 
 *     Anchor: X:
 *     - Default X anchor for Sideview Battlers.
 * 
 *     Anchor: Y:
 *     - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Position:
 * 
 *     Offset X:
 *     - Offsets X position where actor is positioned.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position where actor is positioned.
 *     - Negative values go up. Positive values go down.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   State Overlay:
 * 
 *     Offset X:
 *     - Offsets X position for state overlay on actor.
 *     - Negative values go left. Positive values go right.
 * 
 *     Offset Y:
 *     - Offsets Y position for state overlay on actor.
 *     - Negative values go up. Positive values go down.
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     As Target:
 *     - Shows enemy name when enemy is a target.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 * 
 *     Temporary Visibility:
 *     - Number of frames enemy's name temporarily visible after taking an
 *       action effect in battle.
 *     - 60 frames = 1 second.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 * 
 * Aspect Defaults
 * 
 *   Name Format:
 *   - Default name aspect format.
 *   - %1 - Original Enemy Name
 * 
 *   Name Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Icon:
 *   - Default icon used for aspect.
 *   - Use <Aspect Icon: x> to change icon.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.85: October 17, 2024
 * * Bug Fixes!
 * ** Fixed a bug where the enemy name's visibility would remain after an
 *    action has taken place and before inputting is done. Fix made by Olivia.
 * ** Fixed a bug where the "Name Visibility As Target" plugin parameter did
 *    not work properly. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Updated <Help Description> notetag documentation:
 * *** This is used as a common notetag between Battle Core's state
 *     descriptions and State Tooltips' state descriptions.
 * * New Features!
 * ** New Notetag added by Olivia:
 * *** <In-Battle Status Description>
 * **** A prioritized help description used to separate from the common help
 *      description notetag shared with State Tooltips.
 * ** New Plugin Parameters added by Olivia:
 * *** Actor Battlers > Frontview > Portrait Animations > Each Target
 * *** Actor Battlers > Frontview > Portrait Animations > Center of All
 * *** Actor Battlers > Frontview > Portrait Animations > Center of Screen
 * **** Place animations on top or behind for these display types?
 * *** Battle Log > Action Changes > Show Counter? > Wait Frames
 * *** Battle Log > Action Changes > Show Reflect? > Wait Frames
 * *** Battle Log > Action Changes > Show Substitute? > Wait Frames
 * **** If devs allow the results of counters, reflects, and substitutes, there
 *      wasn't enough time before to allow the text to be visible on screen.
 *      You can now adjust how many frames are now visible if text is shown.
 * **** Default values are left at 0 as to not interrupt currently existing
 *      action sequences.
 * 
 * Version 1.84: September 19, 2024
 * * Bug Fixes!
 * ** Fixed a bug where Action Sequence "MOVE: Change Home By Distance" would
 *    also be affected by the actor and enemy position offsets. Fixed by Irina.
 * ** Fixed a bug where Action Sequence "MECH: STB Exploit Effect" caused a
 *    crash. Fix made by Arisu.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Command added by Arisu:
 * *** ANIM: Change Battle Portrait (JS)
 * **** Changes the battle portrait of the actor through JavaScript.
 * **** Can be used outside of battle/action sequences.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > In-Battle Status Window
 * **** This new window allows the player to view the status of the current
 *      active party. If the actors have states and buffs, the player can
 *      scroll through them and read about their effects through the help
 *      window.
 * ** New Notetags added by Olivia:
 * *** <Help Description>
 * **** Assigns a help description for the state that's displayed under the
 *      new "Status" actor command.
 * *** <Exclude From Status Listing>
 * **** Excludes the state from being displayed in the status listing.
 * *** <Aspect Name: x>
 * *** <Aspect Icon: x>
 * *** <Aspect Color: x>
 * *** <Aspect Description>
 * **** Used to define enemy aspect that will show up in the In-Battle Status
 *      as well as other supported plugins.
 * *** <Popup Position: Head>
 * *** <Popup Position: Center>
 * *** <Popup Position: Base>
 * **** Changes the popup starting position for this enemy.
 * *** <Popup Offset X: +x>
 * *** <Popup Offset X: -x>
 * *** <Popup Offset Y: +y>
 * *** <Popup Offset Y: -y>
 * **** Changes the popup X/Y position offset for this enemy.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Party Command Window > Add Status?
 * **** Add the "Status" command to the Command Window? 
 * *** Plugin Parameters > Actor Command Window > Command List
 * **** Updated to have the "Status" command.
 * *** Plugin Parameters > In-Battle Status Window
 * **** Completely new! View the help file for more information.
 * *** Plugin Parameters > Enemy > Aspects
 * **** Used for the In-Battle Status as well as other supported plugins.
 * 
 * Version 1.83: May 16, 2024
 * * Bug Fixes!
 * ** Fixed a bug where sometimes, a battler in Active TPB would not refresh
 *    their motion after a state has been removed. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Fixed a typo with MP Life Steal notetag entry.
 * * Feature Updates!
 * ** Added fail safes for some plugin parameters in case users outright delete
 *    plugin parameter values without introducing something to replace them.
 *    Update made by Olivia.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** GRID: Add Trigger to Node JS
 * **** Adds JS Trigger to target node. Target node cannot have battler.
 * **** Requires VisuMZ_2_BattleGridSystem!
 * ** New notetags added by Olivia:
 * *** <JS Accuracy>
 * *** <JS Accuracy as User>
 * *** <JS Accuracy as Target>
 * **** Allows usage of JavaScript code to modify accuracy rates of actions in
 *      battle through skills, items, and trait objects.
 * *** <JS Critical Rate as User>
 * *** <JS Critical Rate as Target>
 * **** Allows usage of JavaScript code to modify critical rate of actions in
 *      battle through skills, items, and trait objects.
 * **** <JS Critical Rate> version already exists.
 * ** New Plugin Parameters added by Olivia
 * *** Plugin Parameters > Damage Combo Window
 * **** If enabled, this window will display updated information about the
 *      total amount of hits performed and total damage/healing value executed
 *      for HP.
 * *** Plugin Parameters > Actor Battler Settings > Sideview Battlers >
 *     State Overlay > Offset X/Y
 * **** Offsets X/Y position for state overlay on actor.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     As Target
 * **** Shows enemy name when enemy is a target.
 * *** Plugin Parameters > Enemy Battler Settings > Name Visibility >
 *     Temporary Visibility
 * **** Number of frames enemy's name temporarily visible after taking an
 *      action effect in battle.
 * 
 * Version 1.82: March 14, 2024
 * * Bug Fixes!
 * ** Home movement changes did not acknowledge actor and enemy offset X/Y
 *    positions. This should now be reflected properly. Fix made by Irina.
 * ** Fixed a bug where in active TPB/ATB, revived actors may not resume normal
 *    motions after collapsing. Fix made by Olivia.
 * 
 * Version 1.81: February 15, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause active TPB inputting actors to not show
 *    their damage or evasion motions. Fix made by Olivia.
 * ** Fixed a bug that would cause a crash upon motion changes. Fix by Olivia.
 * ** Fixed an incorrect spelling of "Anger" for "ANIM: Balloon Animation" that
 *    prevented it from working properly.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Show Animation JS
 * **** Plays the a specific animation on unit(s). Uses JavaScript to determine
 *      animation ID.
 * ** New Action Sequences added for future plugin: VisuMZ_2_BattleGridSystem
 * *** GRID: Action Animation at Node
 * *** GRID: Add Passive State(s) to Node
 * *** GRID: Add Trigger to Node
 * *** GRID: Animation ID at Node
 * *** GRID: Animation JS at Node
 * *** GRID: Animation Type at Node
 * *** GRID: Move Target(s) In Direction
 * *** GRID: Pull To Target Node
 * *** GRID: Push From Target Node
 * *** GRID: Remove All Passive States from Node
 * *** GRID: Remove Passive State(s) from Node
 * *** GRID: Remove Trigger from Node
 * *** GRID: Teleport To Node
 * *** GRID: Traverse To Node
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 * 
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a crash that would occur with <Disperse Damage> when used outside
 *    of battle. Fix made by Irina.
 * ** Fixed a crash that would occur with certain enemy graphics when images
 *    used for them would disappear. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Guard Animation
 * *** ANIM: Item Animation
 * *** ANIM: Skill Animation
 * **** Plays the animation associated with the user's guard action (if any),
 *      or a specific item/skill.
 * *** MECH: Emulate Attack Effect
 * *** MECH: Emulate Guard Effect
 * *** MECH: Emulate Item Effect
 * *** MECH: Emulate Skill Effect
 * **** Emulate an "Action Effect" but using a the user's attack skill, guard
 *      skill, specific item, or specific skill instead of the current action.
 * **** Essentially lets you perform the mechanics of another action without
 *      having to use another action or needing to pay that action's costs.
 * *** MECH: Emulate Skill Cost
 * **** Pick a skill for target(s) to emulate paying the cost of.
 * **** Includes cooldowns and limited uses.
 * *** MECH: State Turns Change By
 * *** MECH: State Turns Change To
 * **** Changes target(s) state turns by an amount/to a certain value.
 * **** Requires VisuMZ_1_SkillsStatesCore!
 * *** Projectile action sequences have new Extra Features!
 * **** See v1.08 changes for VisuMZ_3_ActSeqProjectiles.
 * 
 * Version 1.79: December 14, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Arisu:
 * *** ANIM: Balloon Animation
 * **** Plays a balloon animation on target(s).
 * *** ANIM: Balloon Icon (Single)
 * *** ANIM: Balloon Icon (Range)
 * *** ANIM: Balloon Icon (Specific)
 * **** Plays a balloon animation using an icon on target(s).
 * **** Requires VisuMZ_4_IconBalloons!
 * 
 * Version 1.78: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a bug that is caused by using the actor escape command not escaping
 *    properly in battle and causing a freeze. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Parameters > Mechanics > Turn End Buffs Expire?
 * **** Normally, buffs expire after all actions end.
 * **** But here, you can have buffs expire on turn end.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug where for TPB, actions aimed at dead targets would not
 *    redirect to suitable targets. Fix made by Olivia.
 * ** Fixed a bug where dual wielding would not use a weapon if it was equipped
 *    in the second weapon slot if the first weapon slot was empty. Fix made
 *    by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Added compatibility for VisuStella MZ Battle Voices Action Sequences.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.76: July 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia and sponsored by NSG:
 * *** MOVE: Change Home To JS Coordinates
 * **** Change home position(s) to specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Face JS Coordinates
 * **** Causes the unit(s) to face specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Move To JS Coordinates
 * **** Moves unit(s) to specified JS Coordinates. Sideview-only! Uses JS!
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 * 
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 * 
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 * 
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 * 
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 * 
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 * 
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 * 
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 * 
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 * 
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 * 
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 * 
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 * 
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonAnimation
 * @text ANIM: Balloon Animation
 * @desc Plays a balloon animation on target(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Balloon:str
 * @text Balloon Type
 * @type select
 * @option Exclamation
 * @option Question
 * @option Music Note
 * @option Heart
 * @option Anger
 * @option Sweat
 * @option Frustration
 * @option Silence
 * @option Light Bulb
 * @option Zzz
 * @option User-defined 1
 * @option User-defined 2
 * @option User-defined 3
 * @option User-defined 4
 * @option User-defined 5
 * @desc What kind of balloon should be played on target(s)?
 * @default Exclamation
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIcon
 * @text ANIM: Balloon Icon (Single)
 * @desc Plays a balloon animation using an icon on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg IconIndex:num
 * @text Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconRange
 * @text ANIM: Balloon Icon (Range)
 * @desc Plays a balloon animation an icon range on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg startIcon:num
 * @text Starting Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg endIcon:num
 * @text Ending Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconSpecific
 * @text ANIM: Balloon Icon (Specific)
 * @desc Plays a balloon animation with specific icons on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg icons:arraynum
 * @text Icons
 * @type string[]
 * @desc Insert the ID(s) of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default []
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait_JS
 * @text ANIM: Change Battle Portrait (JS)
 * @desc Changes the battle portrait of the actor through JavaScript.
 * Can be used outside of battle/action sequences.
 *
 * @arg ActorJS:func
 * @text JS: Actor ID
 * @type note
 * @desc Enter which Actor ID to affect.
 * Uses JavaScript code.
 * @default "// Get Actor ID here.\nlet actorID = 0;\nactorID = $gameParty.members()[0].actorId();\n\n// Return Actor ID\nreturn actorID;"
 *
 * @arg FilenameJS:func
 * @text JS: Filename
 * @type note
 * @desc Enter the filename you wish to use.
 * Uses JavaScript code.
 * @default "// Get Filename here.\nlet filename = 'Actor1_';\nfilename += String(Math.randomInt(8) + 1);\n\n// Return Filename\nreturn filename;"
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_GuardAnimation
 * @text ANIM: Guard Animation
 * @desc Plays the animation associated with the user's guard action (if any).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ItemAnimation
 * @text ANIM: Item Animation
 * @desc Plays the animation associated with a specific item.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimationJS
 * @text ANIM: Show Animation JS
 * @desc Plays the a specific animation on unit(s).
 * Uses JavaScript to determine animation ID.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Select which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_SkillAnimation
 * @text ANIM: Skill Animation
 * @desc Plays the animation associated with a specific skill.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg Basic
 * @text Basic Settings
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 * 
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 * 
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceGrid
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakGrid
 * @text Action Sequences - Grid
 * @desc These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ActionAnimationAtNode
 * @text GRID: Action Animation at Node
 * @desc Plays action animation at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddPassiveStatesToNode
 * @text GRID: Add Passive State(s) to Node
 * @desc Adds Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to add as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNode
 * @text GRID: Add Trigger to Node
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc Select which Skill ID(s) to add as the trigger.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNodeJS
 * @text GRID: Add Trigger to Node JS
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:eval
 * @text JS: Skill ID
 * @desc Use JavaScript to determine what skill ID to add to this node.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationIDAtNode
 * @text GRID: Animation ID at Node
 * @desc Plays specific animation ID at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Play this animation at target node.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:num
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:num
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationJsAtNode
 * @text GRID: Animation JS at Node
 * @desc Uses JS to calculate which animation to play at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Calculate which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationTypeAtNode
 * @text GRID: Animation Type at Node
 * @desc Plays certain animation type at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Type:str
 * @text Animation Type
 * @type select
 * @option Attack
 * @option Guard
 * @option Item
 * @option Skill
 * @desc What is the animation type you would like to play?
 * @default Attack
 * 
 * @arg Slot:eval
 * @text Slot (Attack Type)
 * @parent Type:str
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 1
 * 
 * @arg ItemID:num
 * @text Item ID (Item Type)
 * @parent Type:str
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg SkillID:num
 * @text Skill ID (Skill Type)
 * @parent Type:str
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_MoveTargetsInDirection
 * @text GRID: Move Target(s) In Direction
 * @desc Moves target(s) in a specific direction to other Nodes.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to move.
 * @default ["all targets"]
 * 
 * @arg MoveType:str
 * @text Movement Type
 * @type select
 * @option -
 * @option Exact
 * @option -
 * @option Mid
 * @option -
 * @option Switch
 * @option Switch Mid
 * @option -
 * @option Crash
 * @option Crash Mid
 * @option -
 * @desc Select the Movement type rulings.
 * See VisuMZ_2_BattleGridSystem help file for details.
 * @default Mid
 * 
 * @arg Direction:str
 * @text Direction
 * @parent MoveType:str
 * @type select
 * @option -
 * @option Upward
 * @option Downward
 * @option -
 * @option Up-Forward
 * @option Forward
 * @option Down-Forward
 * @option -
 * @option Up-Backward
 * @option Backward
 * @option Down-Backward
 * @option -
 * @option Up-Leftward
 * @option Leftward
 * @option Down-Leftward
 * @option -
 * @option Up-Rightward
 * @option Rightward
 * @option Down-Rightward
 * @option -
 * @desc Select the movement direction.
 * @default Backward
 *
 * @arg Distance:eval
 * @text Distance
 * @parent MoveType:str
 * @desc The number of nodes to be moved.
 * You may use JavaScript code.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @arg SilentMove:eval
 * @text Silent Change?
 * @type boolean
 * @on Silent
 * @off Visual
 * @desc Silent: Discreet changes shown. More apparent later.
 * Visual: Instant changes shown.
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PullToTargetNode
 * @text GRID: Pull To Target Node
 * @desc Pulls battlers towards target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to pull on?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the pull.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PushFromTargetNode
 * @text GRID: Push From Target Node
 * @desc Pushes battlers away from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to push from?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the push.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ClearPassiveStatesFromNode
 * @text GRID: Remove All Passive States from Node
 * @desc Removes all all Passive State effects at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear the Node for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Passive States from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemovePassiveStatesFromNode
 * @text GRID: Remove Passive State(s) from Node
 * @desc Remove Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to remove as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to remove the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemoveTriggerFromNode
 * @text GRID: Remove Trigger from Node
 * @desc Removes Trigger from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear Triggers for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Triggers from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TeleportToNode
 * @text GRID: Teleport To Node
 * @desc Teleports user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to teleport to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to teleport to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to teleport.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TraverseToNode
 * @text GRID: Traverse To Node
 * @desc Traverses user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to traverse to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to traverse to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to traverse.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 * 
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateAttackEffect
 * @text MECH: Emulate Attack Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * attack skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateGuardEffect
 * @text MECH: Emulate Guard Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * guard skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateItemEffect
 * @text MECH: Emulate Item Effect
 * @desc Emulate an "Action Effect" but using a specific item
 * instead of the current action.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will be emulated?
 * @default 7
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillCost
 * @text MECH: Emulate Skill Cost
 * @desc Pick a skill for target(s) to emulate paying the cost of.
 * Includes cooldowns and limited uses.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will have its cost paid for?
 * Use 0 for current action's skill.
 * @default 0
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillEffect
 * @text MECH: Emulate Skill Effect
 * @desc Emulate an "Action Effect" but using a specific skill
 * instead of the current action.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will be emulated?
 * @default 99
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeBy
 * @text MECH: State Turns Change By
 * @desc Changes target(s) state turns by an amount.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeTo
 * @text MECH: State Turns Change To
 * @desc Changes target(s) state turns to a specific value.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if target(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToJsPoint
 * @text MOVE: Change Home To JS Coordinates
 * @desc Change home position(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s)'s new home position.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceJsPoint
 * @text MOVE: Face JS Coordinates
 * @desc Causes the unit(s) to face specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg PointJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to face towards.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToJsPoint
 * @text MOVE: Move To JS Coordinates
 * @desc Moves unit(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to move to.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceVoice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakVoice
 * @text Action Sequences - Voice
 * @desc Allows you to play battle voices.
 * Requires VisuMZ_3_BattleVoices!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlayCommonLine
 * @text VOICE: Play Common Line
 * @desc Plays a common voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLine:str
 * @text Voice Line
 * @type select
 * @option -
 * @value -
 * @option ---Battle Phase---
 * @value -
 * @option On Battle Start
 * @value BattleStart
 * @option On Battle Input
 * @value BattleInput
 * @option On Battle Victory
 * @value BattleVictory
 * @option Victory => Level Up
 * @value BattleVictoryLevelUp
 * @option Escape => Success
 * @value BattleEscapeSuccess
 * @option Escape => Failure
 * @value BattleEscapeFailure
 * @option -
 * @value -
 * @option ---On Action Start---
 * @value -
 * @option Basic Action => Regular Attack
 * @value ActionStartBasicAttack
 * @option Basic Action => Regular Guard
 * @value ActionStartBasicGuard
 * @option Skill Usage For Allies => Certain Hit
 * @value ActionStartSkillAllyCertainHit
 * @option Skill Usage For Allies => Physical
 * @value ActionStartSkillAllyPhysical
 * @option Skill Usage For Allies => Magical
 * @value ActionStartSkillAllyMagical
 * @option Skill Usage For Enemies => Certain Hit
 * @value ActionStartSkillEnemyCertainHit
 * @option Skill Usage For Enemies => Physical
 * @value ActionStartSkillEnemyPhysical
 * @option Skill Usage For Enemies => Magical
 * @value ActionStartSkillEnemyMagical
 * @option Item Usage For Allies
 * @value ActionStartItemAlly
 * @option Item Usage For Enemies
 * @value ActionStartItemEnemy
 * @option -
 * @value -
 * @option ---Perform Action---
 * @value -
 * @option Basic Action => Attack Motion
 * @value PerformActionBasicAttack
 * @option Basic Action => Critical Action
 * @value PerformActionCritical
 * @option Basic Action => Defeat Opponent
 * @value PerformActionDefeatFoe
 * @option Basic Action => Missed Action
 * @value PerformActionMiss
 * @option Skill Usage => Certain Hit
 * @value PerformActionSkillCertainHit
 * @option Skill Usage => Physical
 * @value PerformActionSkillPhysical
 * @option Skill Usage => Magical
 * @value PerformActionSkillMagical
 * @option -
 * @value -
 * @option ---On HP Change---
 * @value -
 * @option Life State => On Death
 * @value HpChangeDeath
 * @option Life State => On Revive
 * @value HpChangeRevive
 * @option On Damage => Damage <= 0%
 * @value HpChangeDamageNone
 * @option On Damage => Damage < 25%
 * @value HpChangeDamageLight
 * @option On Damage => Damage < 50%
 * @value HpChangeDamageMedium
 * @option On Damage => Damage >= 50%
 * @value HpChangeDamageHeavy
 * @option On Damage => Guarding Damage
 * @value HpChangeDamageGuard
 * @option On Recovery => Recovery < 25%
 * @value HpChangeRecoverLight
 * @option On Recovery => Recovery < 50%
 * @value HpChangeRecoverMedium
 * @option On Recovery => Recovery >= 50%
 * @value HpChangeRecoverHeavy
 * @option -
 * @value -
 * @option ---On Action Result---
 * @value -
 * @option On Miss/Evasion
 * @value ActionResultEvasion
 * @option On Magic Evasion
 * @value ActionResultMagicEvasion
 * @option On Counter
 * @value ActionResultCounter
 * @option On Reflection
 * @value ActionResultReflection
 * @option On Substitute
 * @value ActionResultSubstitute
 * @option -
 * @value -
 * @option ---Buff/Debuff Related---
 * @value -
 * @option On Buff Apply
 * @value BuffAdd
 * @option On Buff Remove
 * @value BuffRemove
 * @option On Debuff Apply
 * @value DebuffAdd
 * @option On Debuff Remove
 * @value DebuffRemove
 * @option -
 * @value -
 * @option ---State Related---
 * @value -
 * @option Positive States => On State Apply
 * @value StatePositiveAdd
 * @option Positive States => text On State Remove
 * @value StatePositiveRemove
 * @option Negative States => On State Apply
 * @value StateNegativeAdd
 * @option Negative States => On State Remove
 * @value StateNegativeRemove
 * @option Neutral States => On State Apply
 * @value StateNeutralAdd
 * @option Neutral States => On State Remove
 * @value StateNeutralRemove
 * @option -
 * @value -
 * @option ---Miscellaneous---
 * @value -
 * @option Voice Preview
 * @value CharaCreatePreview
 * @option -
 * @value -
 * @desc What voice line do you wish to play?
 * @default ActionStartBasicAttack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlaySpecialLine
 * @text VOICE: Play Special Line
 * @desc Plays a special voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLineType:str
 * @text Voice Line Type
 * @type select
 * @option Action Name
 * @value ActionName
 * @option Chant Line
 * @value ChantLine
 * @option Item Name
 * @value ItemName
 * @option Skill Name
 * @value SkillName
 * @option Spell Name
 * @value SpellName
 * @option Unique Lines
 * @value UniqueLine
 * @desc What voice line type do you wish to play?
 * @default ActionName
 *
 * @arg Letter:str
 * @text Name / Letter
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @option E
 * @option F
 * @option G
 * @option H
 * @option I
 * @option J
 * @option K
 * @option L
 * @option M
 * @option N
 * @option O
 * @option P
 * @option Q
 * @option R
 * @option S
 * @option T
 * @option U
 * @option V
 * @option W
 * @option X
 * @option Y
 * @option Z
 * @desc What voice letter/name do you want to play?
 * @default A
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","ShowCosts:eval":"true","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat.","HelpParty:str":"Automatically choose an action suitable for combat."}
 *
 * @param InBattleStatus:struct
 * @text In-Battle Status Window
 * @type struct<InBattleStatus>
 * @desc Settings that alter the In-Battle Status window accessed
 * through the "Status" command.
 * @default {"General":"","CmdIconStatus:num":"87","StatusGraphic:str":"face","HelpStatus:str":"View battle member status.","Enemy":"","enemyStatus:eval":"true","enemyShowLevel:eval":"true","enemyHiddenParameter:str":"???","enemyShowParametersAlways:eval":"false","enemyShowParametersIfBattleTest:eval":"true","enemyShowParametersIfDefeated:eval":"true","PageButtons":"","pageOffsetX:num":"+0","pageOffsetY:num":"+0","pageButtons:eval":"true","Parameters":"","buffValueFmt:str":"▲%1","debuffValueFmt:str":"▼%1","States":"","statesMaxWidth:num":"384","drawStates:eval":"true","drawBuffs:eval":"true","drawDebuffs:eval":"true","BuffsDebuffs":"","buffNameFmt:str":"%1▲","debuffNameFmt:str":"%1▼","NormalState":"","normalIcon:num":"84","normalText:str":"Normal","HelpDesc":"","stateHelpFmt:json":"\"%1 %2\"","buffHelpFmt:json":"\"Increases %1 to %3%2\\\\C[0]. %4\"","debuffHelpFmt:json":"\"Decreases %1 to %3%2\\\\C[0]. %4\"","normalHelp:json":"\"Status is currently normal.\"","TurnHelpDesc":"","actionsFmt:str":"\\C[6](Actions %2%1\\C[6])\\C[0]","TurnsFmt:str":"\\C[5](Turns %2%1\\C[5])\\C[0]","passiveText:str":"\\C[4](Passive)\\C[0]","Window":"","StatusWindow_BgType:num":"0","StatusWindow_DrawJS:func":"\"{ // Draw Face and Simple Status\\n    const x = this.colSpacing() / 2;\\n    const h = ImageManager.faceHeight;\\n    const y = h / 2 - this.lineHeight() * 1.5;\\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\\n}\\n{ // Draw Actor Parameters\\n    let maxWidth = this.drawingAreaWidth();\\n    let x1 = 0;\\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\\n\\n    let counter = 0;\\n    const params = this.displayedParams();\\n\\n    let px = x1;\\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\\n    let pw = Math.floor(maxWidth / 2);\\n\\n    if (this._statesWindow.y !== 0) {\\n        this._statesWindow.y = py;\\n    }\\n\\n    for (const param of params) {\\n        this.drawDarkRect(px, py, pw, this.lineHeight());\\n        this.drawParamData(param, px, py, pw);\\n        counter++;\\n        if (counter % 2 === 0) {\\n            px = x1;\\n            py += this.lineHeight();\\n        } else {\\n            px = x2;\\n        }\\n    }\\n}\"","StatusWindow_RectJS:func":"\"const wx = Graphics.boxWidth > 1000 ? 120 : 0;\\nconst wy = this._helpWindow.y + this._helpWindow.height;\\nconst ww = Graphics.boxWidth - (wx * 2);\\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\\nreturn new Rectangle(wx, wy, ww, wh);\""}
 * 
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 * 
 * @param ComboWindow:struct
 * @text Damage Combo Window
 * @type struct<ComboWindow>
 * @desc Settings that alter the damage/healing combo window displayed in battle.
 * @default {"General":"","Enable:eval":"true","Appearance":"","CustomFontFace:str":"Arial","TextAlign:str":"left","ComboWindow_DrawJS:func":"\"// Declare Coordinates\\nlet x = 0;\\nlet y = 0;\\n\\n// Hit Text\\nconst hitText = this.hitText();\\nconst hitTextSize = this.textSizeEx(hitText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - hitTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - hitTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(hitText, x, y);\\n\\n// New Line\\ny += Math.ceil(this.lineHeight() * 2/3);\\n\\n// Damage Text\\nconst dmgText = this.damageText();\\nconst dmgTextSize = this.textSizeEx(dmgText);\\nif (this.textAlignment() === 'right') {\\n    x = this.innerWidth - this.itemPadding() - dmgTextSize.width;\\n} else if (this.textAlignment() === 'center') {\\n    x = Math.floor((this.innerWidth - dmgTextSize.width) / 2);\\n} else {\\n    x = this.itemPadding();\\n}\\nthis.drawTextEx(dmgText, x, y);\"","Vocab":"","hitsDmgFmt:str":"\\C[6]%1\\} \\C[4]Hit Combo\\C[0]\\{","hitsHealFmt:str":"\\C[6]%1\\} \\C[4]Heal Combo\\C[0]\\{","totalDmgFmt:str":"\\}\\C[21]Total Damage: \\{\\C[0]%1","totalHealFmt:str":"\\}\\C[21]Total Healing: \\{\\C[24]+%1\\C[0]","Position":"","fadeShiftX:num":"-2","fadeShiftY:num":"+0","PosOffsetX:num":"+0","PosOffsetY:num":"+0","ComboWindow_RectJS:func":"\"const ww = Math.ceil(Graphics.width / 4);\\nconst wh = this.calcWindowHeight(2, true);\\nconst wx = 0 + this.comboWindowOffsetX();\\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\\nreturn new Rectangle(wx, wy, ww, wh);\"","Update":"","updateDuration:num":"20","minimumStayDuration:num":"40","minimumHits:num":"1","opacitySpeed:num":"16"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowCounterWait:eval
 * @text Wait Frames
 * @parent ShowCounter:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowReflectWait:eval
 * @text Wait Frames
 * @parent ShowReflect:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ShowSubstituteWait:eval
 * @text Wait Frames
 * @parent ShowSubstitute:eval
 * @type number
 * @desc How many frames should the battle log wait after text?
 * 60 frames = 1 second.
 * @default 0
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddStatus:eval
 * @text Add Status?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Status" command to the Command Window?
 * @default true
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent CommandAddStatus:eval
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option status
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * In_Battle Status Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~InBattleStatus:
 *
 * @param General
 * @text General Settings
 *
 * @param CmdIconStatus:num
 * @text Status Icon
 * @parent General
 * @desc The icon used for the Status command.
 * @default 87
 *
 * @param StatusGraphic:str
 * @text Status Graphic
 * @parent General
 * @type select
 * @option None
 * @value none
 * @option Face
 * @value face
 * @option Map Sprite
 * @value sprite
 * @option Sideview Battler
 * @value svbattler
 * @desc Choose how the actor graphic appears for In-Battle Status.
 * @default face
 *
 * @param HelpStatus:str
 * @text Help Description
 * @parent General
 * @desc Text displayed when selecting the Status command.
 * @default View battle member status.
 *
 * @param Enemy
 * @text Enemy Settings
 *
 * @param enemyStatus:eval
 * @text Allow View Enemies?
 * @parent Enemy
 * @type boolean
 * @on Allow
 * @off Forbid
 * @desc Allows players to view enemy stats (even if limited)?
 * @default true
 *
 * @param enemyShowLevel:eval
 * @text Show Level?
 * @parent Enemy
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the enemy's level in the In-Battle Status?
 * @default true
 *
 * @param enemyHiddenParameter:str
 * @text Hidden Parameter
 * @parent Enemy
 * @desc The text that appears if a parameter value is hidden.
 * @default ???
 *
 * @param enemyShowParametersAlways:eval
 * @text Show Params Always
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Always show exact enemy parameter values.
 * @default false
 *
 * @param enemyShowParametersIfBattleTest:eval
 * @text Show Battle Test
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values in battle test.
 * @default true
 *
 * @param enemyShowParametersIfDefeated:eval
 * @text Show If Defeated
 * @parent enemyHiddenParameter:str
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show exact enemy parameter values if enemy has been defeated before.
 * @default true
 *
 * @param PageButtons
 * @text Page Buttons
 *
 * @param pageButtons:eval
 * @text Show Page Buttons?
 * @parent PageButtons
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows page buttons to switch between actors?
 * Still requires Touch UI option to be on.
 * @default true
 *
 * @param pageButtonPosition:str
 * @text Large UI Position?
 * @parent pageButtons:eval
 * @type select
 * @option left
 * @option right
 * @desc If using a large resolution, position the page buttons on which side?
 * @default left
 *
 * @param pageOffsetX:num
 * @text Offset X
 * @parent PageButtons
 * @desc Offsets the page buttons x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param pageOffsetY:num
 * @text Offset Y
 * @parent PageButtons
 * @desc Offsets the page buttons y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param Parameters
 * @text Parameter Display
 *
 * @param buffValueFmt:str
 * @text Increased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▲%1
 *
 * @param debuffValueFmt:str
 * @text Decreased Value
 * @parent Parameters
 * @desc How are increased parameter values displayed?
 * %1 - Parameter Value
 * @default ▼%1
 *
 * @param States
 * @text States Display
 *
 * @param statesMaxWidth:num
 * @text Max Width
 * @parent States
 * @desc Maximum width of the states list display.
 * @default 384
 *
 * @param drawStates:eval
 * @text List States?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists states in the states list display?
 * @default true
 *
 * @param drawBuffs:eval
 * @text List Buffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists buffs in the states list display?
 * @default true
 *
 * @param drawDebuffs:eval
 * @text List Debuffs?
 * @parent States
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Lists debuffs in the states list display?
 * @default true
 *
 * @param BuffsDebuffs
 * @text Buffs/Debuffs Display
 * @parent States
 *
 * @param buffNameFmt:str
 * @text Buff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent buffs.
 * %1 - Parameter Name
 * @default %1▲
 *
 * @param debuffNameFmt:str
 * @text Debuff Name Format
 * @parent BuffsDebuffs
 * @desc Text format used to represent debuffs.
 * %1 - Parameter Name
 * @default %1▼
 *
 * @param NormalState
 * @text Normal State
 * @parent States
 *
 * @param normalIcon:num
 * @text Normal Icon
 * @parent NormalState
 * @desc Icon used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default 84
 *
 * @param normalText:str
 * @text Normal Text
 * @parent NormalState
 * @desc Text used to represent normal state (unaffected by states, buffs, or debuffs).
 * @default Normal
 *
 * @param HelpDesc
 * @text Help Descriptions
 *
 * @param stateHelpFmt:json
 * @text State Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for state help descriptions
 * %1 - Description; %2 - Turns/Actions Remaining
 * @default "%1 %2"
 *
 * @param buffHelpFmt:json
 * @text Buff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Buff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Increases %1 to %3%2\\C[0]. %4"
 *
 * @param debuffHelpFmt:json
 * @text Debuff Help Format
 * @parent HelpDesc
 * @type note
 * @desc Text format used for Debuff help descriptions
 * %1 - Param; %2 - Percent; %3 - Color; %4 - Turns
 * @default "Decreases %1 to %3%2\\C[0]. %4"
 *
 * @param normalHelp:json
 * @text Normal State
 * @parent HelpDesc
 * @type note
 * @desc Help description used to explain normal state (unaffected by states, buffs, or debuffs).
 * @default "Status is currently normal."
 *
 * @param TurnHelpDesc
 * @text Turns/Actions Left
 * @parent HelpDesc
 *
 * @param actionsFmt:str
 * @text Actions Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent actions remaining.
 * %1 - Actions; %2 - Color
 * @default \C[6](Actions %2%1\C[6])\C[0]
 *
 * @param TurnsFmt:str
 * @text Turns Format
 * @parent TurnHelpDesc
 * @desc Text format used to represent turns remaining.
 * %1 - Turns; %2 - Color
 * @default \C[5](Turns %2%1\C[5])\C[0]
 *
 * @param passiveText:str
 * @text Passive Text
 * @parent TurnHelpDesc
 * @desc Text used to represent a passive.
 * @default \C[4](Passive)\C[0]
 *
 * @param Window
 * @text Window Settings
 *
 * @param StatusWindow_BgType:num
 * @text Background Type
 * @parent Window
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for this window.
 * @default 0
 *
 * @param StatusWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Window
 * @type note
 * @desc Code used to draw battler data.
 * @default "{ // Draw Face and Simple Status\n    const x = this.colSpacing() / 2;\n    const h = ImageManager.faceHeight;\n    const y = h / 2 - this.lineHeight() * 1.5;\n    this.drawActorGraphic(this._battler, x + 1, 0, ImageManager.faceWidth, h);\n    this.drawActorSimpleStatus(this._battler, x + 180, y);\n}\n{ // Draw Actor Parameters\n    let maxWidth = this.drawingAreaWidth();\n    let x1 = 0;\n    let x2 = Math.ceil(this.drawingAreaWidth() / 2);\n\n    let counter = 0;\n    const params = this.displayedParams();\n\n    let px = x1;\n    const availableHeight = this.innerHeight - ImageManager.faceHeight;\n    const paramHeight = Math.ceil(params.length / 2) * this.lineHeight();\n    let py = Math.ceil((availableHeight - paramHeight) / 2) + ImageManager.faceHeight;\n    let pw = Math.floor(maxWidth / 2);\n\n    if (this._statesWindow.y !== 0) {\n        this._statesWindow.y = py;\n    }\n\n    for (const param of params) {\n        this.drawDarkRect(px, py, pw, this.lineHeight());\n        this.drawParamData(param, px, py, pw);\n        counter++;\n        if (counter % 2 === 0) {\n            px = x1;\n            py += this.lineHeight();\n        } else {\n            px = x2;\n        }\n    }\n}"
 *
 * @param StatusWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Window
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const wx = Graphics.boxWidth > 1000 ? 120 : 0;\nconst wy = this._helpWindow.y + this._helpWindow.height;\nconst ww = Graphics.boxWidth - (wx * 2);\nconst wh = Graphics.boxHeight - wy - this.windowAreaHeight();\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Combo Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ComboWindow:
 *
 * @param General
 * @text General Settings
 *
 * @param Enable:eval
 * @text Enable?
 * @parent General
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Add the Combo Window to show in battle?
 * @default true
 *
 * @param Appearance
 * @text Appearance Settings
 *
 * @param CustomFontFace:str
 * @text Custom Font
 * @parent Appearance
 * @desc Insert the custom font face name here.
 * Use VisuMZ_1_MessageCore to register new fonts.
 * @default Arial
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent Appearance
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for this window?
 * @default left
 *
 * @param ComboWindow_DrawJS:func
 * @text JS: Draw Data
 * @parent Appearance
 * @type note
 * @desc Code used to draw the data in this window.
 * @default ""
 * 
 * @param Vocab
 * @text Vocabulary
 *
 * @param hitsDmgFmt:str
 * @text Damage Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for damage.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Hit Combo\C[0]\{
 *
 * @param hitsHealFmt:str
 * @text Healing Combo Format
 * @parent Vocab
 * @desc Text format used to display total hits for healing.
 * %1 - Total Hits
 * @default \C[6]%1\} \C[4]Heal Combo\C[0]\{
 *
 * @param totalDmgFmt:str
 * @text Damage Total Format
 * @parent Vocab
 * @desc Text format used to display total value for damage.
 * %1 - Total Damage
 * @default \}\C[21]Total Damage: \{\C[0]%1
 *
 * @param totalHealFmt:str
 * @text Healing Total Format
 * @parent Vocab
 * @desc Text format used to display total value for healing.
 * %1 - Total Healing
 * @default \}\C[21]Total Healing: \{\C[24]+%1\C[0]
 *
 * @param Position
 * @text Position Settings
 *
 * @param fadeShiftX:num
 * @text Fade Shift X
 * @parent Position
 * @desc Shifts the windows x position when fading.
 * Negative: left. Positive: right.
 * @default -2
 *
 * @param fadeShiftY:num
 * @text Fade Shift Y
 * @parent Position
 * @desc Shifts the windows y position when fading.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PosOffsetX:num
 * @text Offset X
 * @parent Position
 * @desc Offsets the windows x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param PosOffsetY:num
 * @text Offset Y
 * @parent Position
 * @desc Offsets the windows y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param ComboWindow_RectJS:func
 * @text JS: X, Y, W, H
 * @parent Position
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const ww = Math.ceil(Graphics.width / 4);\nconst wh = this.calcWindowHeight(2, true);\nconst wx = 0 + this.comboWindowOffsetX();\nconst wy = Math.round(Graphics.boxHeight * 1 / 3) + this.comboWindowOffsetY();\nreturn new Rectangle(wx, wy, ww, wh);"
 * 
 * @param Update
 * @text Updating Settings
 *
 * @param updateDuration:num
 * @text Number Roll Duration
 * @parent Update
 * @type number
 * @min 1
 * @desc Frame duration to roll damage numbers.
 * 60 frames = 1 second.
 * @default 20
 *
 * @param minimumStayDuration:num
 * @text Minimum Stay Duration
 * @parent Update
 * @type number
 * @desc Frame duration to stay visible minimum.
 * 60 frames = 1 second.
 * @default 40
 *
 * @param minimumHits:num
 * @text Minimum Hit Visible
 * @parent Update
 * @type number
 * @min 1
 * @desc Minimum hits before combo window becomes visible?
 * @default 1
 *
 * @param opacitySpeed:num
 * @text Opacity Speed
 * @parent Update
 * @type number
 * @min 1
 * @desc Opacity speed when fading in/out.
 * @default 16
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param FvBattlers
 * @text Frontview Battlers
 * 
 * @param FvPortraitAni
 * @text Portrait Animations
 * @parent FvBattlers
 *
 * @param FvAniEachTarget:eval
 * @text Each Target
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Each Target" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterAll:eval
 * @text Center of All
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of All" display types?
 * Does not apply to MV animations.
 * @default true
 *
 * @param FvAniCenterScreen:eval
 * @text Center of Screen
 * @parent FvPortraitAni
 * @type boolean
 * @on On Top
 * @off Behind
 * @desc Place animations on top for "Center of Screen" display types?
 * Does not apply to MV animations.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 * 
 * @param SvAnchor
 * @text Anchor
 * @parent SvBattlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvAnchor
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvAnchor
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 * 
 * @param SvPosition
 * @text Position
 * @parent SvBattlers
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvPosition
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvPosition
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 * 
 * @param SvStateOverlay
 * @text State Overlay
 * @parent SvBattlers
 *
 * @param StateOverlayOffsetX:num
 * @text Offset: X
 * @parent SvStateOverlay
 * @desc Offsets X position for state overlay on actor.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param StateOverlayOffsetY:num
 * @text Offset: Y
 * @parent SvStateOverlay
 * @desc Offsets Y position for state overlay on actor.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAsTarget:eval
 * @text As Target
 * @parent NameVisibility
 * @type boolean
 * @on Visible As Target
 * @off No Priority
 * @desc Shows enemy name when enemy is a target.
 * Medium priority.
 * @default true
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param NameDamageVisibility:num
 * @text Temporary Visibility
 * @parent NameVisibility
 * @type number
 * @desc Number of frames enemy's name temporarily visible after
 * taking an action effect in battle. 60 frames = 1 second.
 * @default 0
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 * @param Aspect
 * @text Aspect Defaults
 *
 * @param AspectNameFmt:str
 * @text Name Format
 * @parent Aspect
 * @desc Default name aspect format.
 * %1 - Original Enemy Name
 * @default %1 Aspect
 *
 * @param AspectColor:str
 * @text Name Color
 * @parent Aspect
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 2
 *
 * @param AspectIcon:num
 * @text Icon
 * @parent Aspect
 * @desc Default icon used for aspect.
 * Use <Aspect Icon: x> to change icon.
 * @default 26
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0x45d586=_0x442c;(function(_0x433a74,_0xa16084){const _0x482167=_0x442c,_0x1575fc=_0x433a74();while(!![]){try{const _0x4f9893=parseInt(_0x482167(0x878))/0x1*(-parseInt(_0x482167(0x236))/0x2)+parseInt(_0x482167(0x198))/0x3+parseInt(_0x482167(0x949))/0x4*(parseInt(_0x482167(0xad6))/0x5)+-parseInt(_0x482167(0x4d9))/0x6*(parseInt(_0x482167(0x36d))/0x7)+parseInt(_0x482167(0x26c))/0x8*(parseInt(_0x482167(0x927))/0x9)+parseInt(_0x482167(0x5d2))/0xa+parseInt(_0x482167(0xaaa))/0xb;if(_0x4f9893===_0xa16084)break;else _0x1575fc['push'](_0x1575fc['shift']());}catch(_0x5d3fae){_0x1575fc['push'](_0x1575fc['shift']());}}}(_0x455f,0xf1c17));var label=_0x45d586(0x6fe),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x45d586(0x229)](function(_0xcb2060){const _0x2869a0=_0x45d586;return _0xcb2060[_0x2869a0(0xa91)]&&_0xcb2060['description'][_0x2869a0(0x840)]('['+label+']');})[0x0];VisuMZ[label][_0x45d586(0xa41)]=VisuMZ[label][_0x45d586(0xa41)]||{},VisuMZ['ConvertParams']=function(_0x315c93,_0x3d5d1d){const _0x1bad4e=_0x45d586;for(const _0xf8b31c in _0x3d5d1d){if(_0xf8b31c[_0x1bad4e(0x95f)](/(.*):(.*)/i)){const _0x478891=String(RegExp['$1']),_0x38258b=String(RegExp['$2'])['toUpperCase']()['trim']();let _0x13a81b,_0x28e363,_0x21c02b;switch(_0x38258b){case'NUM':_0x13a81b=_0x3d5d1d[_0xf8b31c]!==''?Number(_0x3d5d1d[_0xf8b31c]):0x0;break;case _0x1bad4e(0x9c2):_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363[_0x1bad4e(0x7a1)](_0x32e973=>Number(_0x32e973));break;case'EVAL':_0x13a81b=_0x3d5d1d[_0xf8b31c]!==''?eval(_0x3d5d1d[_0xf8b31c]):null;break;case _0x1bad4e(0x23b):_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363[_0x1bad4e(0x7a1)](_0x34b7a9=>eval(_0x34b7a9));break;case _0x1bad4e(0x4b3):_0x13a81b=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):'';break;case'ARRAYJSON':_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON['parse'](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363['map'](_0x3ae9bb=>JSON['parse'](_0x3ae9bb));break;case _0x1bad4e(0x1ea):_0x13a81b=_0x3d5d1d[_0xf8b31c]!==''?new Function(JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c])):new Function(_0x1bad4e(0x978));break;case _0x1bad4e(0x395):_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON['parse'](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363['map'](_0x10d1b2=>new Function(JSON['parse'](_0x10d1b2)));break;case _0x1bad4e(0x64d):_0x13a81b=_0x3d5d1d[_0xf8b31c]!==''?String(_0x3d5d1d[_0xf8b31c]):'';break;case'ARRAYSTR':_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363[_0x1bad4e(0x7a1)](_0x356512=>String(_0x356512));break;case'STRUCT':_0x21c02b=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):{},_0x315c93[_0x478891]={},VisuMZ[_0x1bad4e(0x536)](_0x315c93[_0x478891],_0x21c02b);continue;case _0x1bad4e(0x455):_0x28e363=_0x3d5d1d[_0xf8b31c]!==''?JSON[_0x1bad4e(0x7d4)](_0x3d5d1d[_0xf8b31c]):[],_0x13a81b=_0x28e363[_0x1bad4e(0x7a1)](_0x25b36a=>VisuMZ[_0x1bad4e(0x536)]({},JSON[_0x1bad4e(0x7d4)](_0x25b36a)));break;default:continue;}_0x315c93[_0x478891]=_0x13a81b;}}return _0x315c93;},(_0x5f3d97=>{const _0x898afd=_0x45d586,_0x33461d=_0x5f3d97['name'];for(const _0x1bad33 of dependencies){if(!Imported[_0x1bad33]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'[_0x898afd(0x534)](_0x33461d,_0x1bad33)),SceneManager[_0x898afd(0x16f)]();break;}}const _0x254fae=_0x5f3d97[_0x898afd(0x30c)];if(_0x254fae[_0x898afd(0x95f)](/\[Version[ ](.*?)\]/i)){const _0x74f8ce=Number(RegExp['$1']);_0x74f8ce!==VisuMZ[label][_0x898afd(0x23e)]&&(alert(_0x898afd(0x7eb)['format'](_0x33461d,_0x74f8ce)),SceneManager[_0x898afd(0x16f)]());}if(_0x254fae[_0x898afd(0x95f)](/\[Tier[ ](\d+)\]/i)){const _0x553ee8=Number(RegExp['$1']);_0x553ee8<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x898afd(0x534)](_0x33461d,_0x553ee8,tier)),SceneManager[_0x898afd(0x16f)]()):tier=Math[_0x898afd(0x61a)](_0x553ee8,tier);}VisuMZ['ConvertParams'](VisuMZ[label]['Settings'],_0x5f3d97[_0x898afd(0x8e0)]);})(pluginData),VisuMZ[_0x45d586(0x552)]=function(_0x3b0350){const _0x59e75a=_0x45d586;let _0x234138=[];for(const _0x26f8ba of _0x3b0350){_0x234138=_0x234138[_0x59e75a(0xb10)](VisuMZ[_0x59e75a(0x44f)](_0x26f8ba));}return _0x234138[_0x59e75a(0x229)](_0x14d8c9=>_0x14d8c9);},VisuMZ['ConvertActionSequenceTarget']=function(_0x125808){const _0x1a629b=_0x45d586,_0x32b5b0=BattleManager['allBattleMembers']()[_0x1a629b(0x229)](_0x259c90=>_0x259c90&&_0x259c90[_0x1a629b(0x2bd)]()),_0x3f318c=BattleManager[_0x1a629b(0x1ce)],_0x360382=BattleManager[_0x1a629b(0x798)],_0x299b49=BattleManager[_0x1a629b(0x424)]?BattleManager[_0x1a629b(0x424)][_0x1a629b(0x25a)](0x0):_0x32b5b0;_0x125808=_0x125808[_0x1a629b(0x2ab)]()['trim']();if(_0x125808===_0x1a629b(0xa02))return[_0x3f318c];else{if(_0x125808===_0x1a629b(0xbad))return[_0x360382];else{if(_0x125808===_0x1a629b(0x748)){if(_0x360382){const _0x2b4f96=_0x299b49[_0x1a629b(0xa63)](_0x360382);return _0x2b4f96>=0x0?[_0x299b49[_0x2b4f96-0x1]||_0x360382]:[_0x360382];}}else{if(_0x125808===_0x1a629b(0x6ce)){if(_0x360382){const _0x8ef4bc=_0x299b49[_0x1a629b(0xa63)](_0x360382);return _0x8ef4bc>=0x0?[_0x299b49[_0x8ef4bc+0x1]||_0x360382]:[_0x360382];}}else{if(_0x125808===_0x1a629b(0x388))return _0x299b49;else{if(_0x125808===_0x1a629b(0x422))return[_0x3f318c][_0x1a629b(0xb10)](_0x299b49);else{if(_0x125808===_0x1a629b(0x37a))return _0x32b5b0[_0x1a629b(0x229)](_0x323748=>_0x323748!==_0x3f318c&&!_0x299b49['includes'](_0x323748)&&_0x323748[_0x1a629b(0x654)]());else{if(_0x125808===_0x1a629b(0x98f))return[VisuMZ['GetActionSequenceSpecialTarget']()];else{if(_0x125808[_0x1a629b(0x95f)](/SPECIAL (.*)>/i)){const _0x2a5312=String(RegExp['$1'])['split'](',')[_0x1a629b(0x7a1)](_0x58a225=>_0x58a225[_0x1a629b(0x379)]());return[VisuMZ['GetActionSequenceSpecialTargetWithFlags'](_0x2a5312)];}}}}}}}}}if(_0x3f318c){if(_0x125808===_0x1a629b(0x9c5))return _0x3f318c['friendsUnit']()['aliveMembers']();else{if(_0x125808==='alive\x20friends\x20not\x20user')return _0x3f318c[_0x1a629b(0x904)]()[_0x1a629b(0x60c)]()[_0x1a629b(0x229)](_0xab938f=>_0xab938f!==_0x3f318c);else{if(_0x125808===_0x1a629b(0x242))return _0x3f318c[_0x1a629b(0x904)]()[_0x1a629b(0x60c)]()[_0x1a629b(0x229)](_0x5668db=>_0x5668db!==_0x360382);else{if(_0x125808==='dead\x20friends')return _0x3f318c[_0x1a629b(0x904)]()['deadMembers']();else{if(_0x125808[_0x1a629b(0x95f)](/FRIEND INDEX (\d+)/i)){const _0x47a77e=Number(RegExp['$1']);return[_0x3f318c['friendsUnit']()[_0x1a629b(0xad5)]()[_0x47a77e]];}}}}}if(_0x125808==='alive\x20opponents')return _0x3f318c[_0x1a629b(0x276)]()[_0x1a629b(0x60c)]();else{if(_0x125808===_0x1a629b(0x3e9))return _0x3f318c[_0x1a629b(0x276)]()['aliveMembers']()['filter'](_0x28c681=>_0x28c681!==_0x360382);else{if(_0x125808===_0x1a629b(0x181))return _0x3f318c['opponentsUnit']()[_0x1a629b(0x99f)]();else{if(_0x125808[_0x1a629b(0x95f)](/OPPONENT INDEX (\d+)/i)){const _0x3d5379=Number(RegExp['$1']);return[_0x3f318c['opponentsUnit']()[_0x1a629b(0xad5)]()[_0x3d5379]];}}}}}if(_0x125808==='alive\x20actors')return $gameParty[_0x1a629b(0x60c)]();else{if(_0x125808===_0x1a629b(0xa09))return $gameParty[_0x1a629b(0x60c)]()[_0x1a629b(0x229)](_0x5a61e4=>_0x5a61e4!==_0x3f318c);else{if(_0x125808==='alive\x20actors\x20not\x20target')return $gameParty['aliveMembers']()[_0x1a629b(0x229)](_0x12e5de=>_0x12e5de!==_0x360382);else{if(_0x125808===_0x1a629b(0xbd9))return $gameParty[_0x1a629b(0x99f)]();else{if(_0x125808['match'](/ACTOR INDEX (\d+)/i)){const _0x623acc=Number(RegExp['$1']);return[$gameParty[_0x1a629b(0xad5)]()[_0x623acc]];}else{if(_0x125808[_0x1a629b(0x95f)](/ACTOR ID (\d+)/i)){const _0x3b1e7f=Number(RegExp['$1']);return[$gameActors[_0x1a629b(0xb77)](_0x3b1e7f)];}}}}}}if(_0x125808===_0x1a629b(0x195))return $gameTroop['aliveMembers']();else{if(_0x125808===_0x1a629b(0x864))return $gameTroop[_0x1a629b(0x60c)]()['filter'](_0x1ffc42=>_0x1ffc42!==_0x3f318c);else{if(_0x125808==='alive\x20enemies\x20not\x20target')return $gameTroop['aliveMembers']()[_0x1a629b(0x229)](_0x182cd8=>_0x182cd8!==_0x360382);else{if(_0x125808===_0x1a629b(0x78f))return $gameTroop[_0x1a629b(0x99f)]();else{if(_0x125808[_0x1a629b(0x95f)](/ENEMY INDEX (\d+)/i)){const _0x186249=Number(RegExp['$1']);return[$gameTroop[_0x1a629b(0xad5)]()[_0x186249]];}else{if(_0x125808[_0x1a629b(0x95f)](/ENEMY ID (\d+)/i)){const _0x59e4ef=Number(RegExp['$1']);return $gameTroop[_0x1a629b(0x60c)]()['filter'](_0x223d15=>_0x223d15[_0x1a629b(0x4a5)]()===_0x59e4ef);}}}}}}if(_0x125808==='alive\x20battlers')return _0x32b5b0[_0x1a629b(0x229)](_0x22abea=>_0x22abea[_0x1a629b(0x45d)]());else{if(_0x125808===_0x1a629b(0xa07))return _0x32b5b0[_0x1a629b(0x229)](_0x2b1443=>_0x2b1443[_0x1a629b(0x45d)]()&&_0x2b1443!==_0x3f318c);else{if(_0x125808===_0x1a629b(0x265))return _0x32b5b0[_0x1a629b(0x229)](_0x57b2ab=>_0x57b2ab[_0x1a629b(0x45d)]()&&_0x57b2ab!==_0x360382);else{if(_0x125808==='dead\x20battlers')return _0x32b5b0['filter'](_0x198fa1=>_0x198fa1[_0x1a629b(0x1e3)]());}}}return[];},VisuMZ['GetActionSequenceSpecialTarget']=function(){const _0x9bee6e=_0x45d586;return BattleManager[_0x9bee6e(0x798)];},VisuMZ[_0x45d586(0x500)]=function(_0x1e5be9){const _0x48a260=_0x45d586;return BattleManager[_0x48a260(0x798)];},PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x6e4),_0x46e37e=>{const _0x3a0d32=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3a0d32(0x536)](_0x46e37e,_0x46e37e);const _0x17ed81=$gameTemp['getLastPluginCommandInterpreter'](),_0x217339=BattleManager[_0x3a0d32(0x9e9)],_0x5c461a=BattleManager['_subject'],_0x91d17b=BattleManager[_0x3a0d32(0x424)]?BattleManager[_0x3a0d32(0x424)][_0x3a0d32(0x25a)](0x0):[],_0x48ab6c=BattleManager[_0x3a0d32(0x936)];if(!_0x17ed81||!_0x217339||!_0x5c461a)return;if(!_0x217339[_0x3a0d32(0xba9)]())return;if(_0x46e37e['DisplayAction'])_0x48ab6c[_0x3a0d32(0x950)](_0x5c461a,_0x217339[_0x3a0d32(0xba9)]());_0x46e37e['ApplyImmortal']&&_0x48ab6c[_0x3a0d32(0x119)](_0x3a0d32(0x52b),_0x5c461a,_0x91d17b,!![]);if(_0x46e37e['ActionStart'])_0x48ab6c[_0x3a0d32(0x119)](_0x3a0d32(0x4dd),_0x5c461a,_0x217339);if(_0x46e37e[_0x3a0d32(0x9c0)])_0x48ab6c[_0x3a0d32(0x119)](_0x3a0d32(0x2c7));if(_0x46e37e[_0x3a0d32(0x50b)])_0x48ab6c['push'](_0x3a0d32(0x3a3),_0x5c461a,_0x217339);if(_0x46e37e['WaitForAnimation'])_0x48ab6c['push'](_0x3a0d32(0x16a));_0x17ed81[_0x3a0d32(0x9c6)]('battlelog');}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Set_WholeActionSet',_0x5a39ed=>{const _0x5c916b=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5c916b(0x536)](_0x5a39ed,_0x5a39ed);const _0xa185d3=$gameTemp[_0x5c916b(0x421)](),_0x2be6aa=BattleManager['_action'],_0xe2f15=BattleManager[_0x5c916b(0x1ce)],_0x210410=BattleManager[_0x5c916b(0x424)]?BattleManager[_0x5c916b(0x424)][_0x5c916b(0x25a)](0x0):[],_0x463c31=BattleManager[_0x5c916b(0x936)],_0x5b467b=_0x5a39ed['DualWield']??![];if(!_0xa185d3||!_0x2be6aa||!_0xe2f15)return;if(!_0x2be6aa['item']())return;let _0x309847=_0x5b467b?_0x463c31[_0x5c916b(0x7fa)](_0xe2f15):0x1;for(let _0x14e5ba=0x0;_0x14e5ba<_0x309847;_0x14e5ba++){_0x5b467b&&_0xe2f15[_0x5c916b(0x7f0)]()&&_0x463c31[_0x5c916b(0x119)](_0x5c916b(0xb66),_0xe2f15,_0x14e5ba);if(_0x5a39ed[_0x5c916b(0x3ba)])_0x463c31[_0x5c916b(0x119)]('performAction',_0xe2f15,_0x2be6aa);if(_0x5a39ed[_0x5c916b(0xb13)]>0x0)_0x463c31[_0x5c916b(0x119)](_0x5c916b(0xae4),_0x5a39ed[_0x5c916b(0xb13)]);if(_0x5a39ed[_0x5c916b(0xaa6)])_0x463c31[_0x5c916b(0x119)](_0x5c916b(0x7d3),_0xe2f15,_0x210410,_0x2be6aa['item']()[_0x5c916b(0x71b)]);if(_0x5a39ed[_0x5c916b(0x6eb)])_0x463c31['push'](_0x5c916b(0x16a));for(const _0x8064a3 of _0x210410){if(!_0x8064a3)continue;if(_0x5a39ed['ActionEffect'])_0x463c31['push'](_0x5c916b(0x2b7),_0xe2f15,_0x8064a3);}}_0x5b467b&&_0xe2f15[_0x5c916b(0x7f0)]()&&_0x463c31['push'](_0x5c916b(0x6db),_0xe2f15);if(_0x5a39ed[_0x5c916b(0x2c2)])_0x463c31[_0x5c916b(0x119)]('applyImmortal',_0xe2f15,_0x210410,![]);_0xa185d3[_0x5c916b(0x9c6)](_0x5c916b(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x255),_0xd088ae=>{const _0x4c77a3=_0x45d586;if(!SceneManager[_0x4c77a3(0x81a)]())return;VisuMZ[_0x4c77a3(0x536)](_0xd088ae,_0xd088ae);const _0x58f2e0=$gameTemp[_0x4c77a3(0x421)](),_0x2f4683=BattleManager['_action'],_0x24fc1c=BattleManager[_0x4c77a3(0x1ce)],_0x5627d3=BattleManager['_allTargets']?BattleManager['_allTargets']['slice'](0x0):[],_0x4ecbef=BattleManager[_0x4c77a3(0x936)],_0x31567a=_0xd088ae['DualWield']??![];if(!_0x58f2e0||!_0x2f4683||!_0x24fc1c)return;if(!_0x2f4683['item']())return;let _0x4c605b=_0x31567a?_0x4ecbef[_0x4c77a3(0x7fa)](_0x24fc1c):0x1;for(let _0x3bcdbe=0x0;_0x3bcdbe<_0x4c605b;_0x3bcdbe++){for(const _0x3e8563 of _0x5627d3){if(!_0x3e8563)continue;_0x31567a&&_0x24fc1c[_0x4c77a3(0x7f0)]()&&_0x4ecbef['push'](_0x4c77a3(0xb66),_0x24fc1c,_0x3bcdbe);if(_0xd088ae['PerformAction'])_0x4ecbef['push'](_0x4c77a3(0xa5e),_0x24fc1c,_0x2f4683);if(_0xd088ae['WaitCount1']>0x0)_0x4ecbef[_0x4c77a3(0x119)](_0x4c77a3(0xae4),_0xd088ae['WaitCount1']);if(_0xd088ae['ActionAnimation'])_0x4ecbef[_0x4c77a3(0x119)](_0x4c77a3(0x7d3),_0x24fc1c,[_0x3e8563],_0x2f4683[_0x4c77a3(0xba9)]()[_0x4c77a3(0x71b)]);if(_0xd088ae[_0x4c77a3(0x2ad)]>0x0)_0x4ecbef[_0x4c77a3(0x119)]('waitCount',_0xd088ae[_0x4c77a3(0x2ad)]);if(_0xd088ae[_0x4c77a3(0x75f)])_0x4ecbef[_0x4c77a3(0x119)](_0x4c77a3(0x2b7),_0x24fc1c,_0x3e8563);}}_0x31567a&&_0x24fc1c[_0x4c77a3(0x7f0)]()&&_0x4ecbef[_0x4c77a3(0x119)](_0x4c77a3(0x6db),_0x24fc1c);if(_0xd088ae['ApplyImmortal'])_0x4ecbef[_0x4c77a3(0x119)](_0x4c77a3(0x52b),_0x24fc1c,_0x5627d3,![]);_0x58f2e0[_0x4c77a3(0x9c6)](_0x4c77a3(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x432),_0x2d1d40=>{const _0x28f827=_0x45d586;if(!SceneManager[_0x28f827(0x81a)]())return;VisuMZ['ConvertParams'](_0x2d1d40,_0x2d1d40);const _0x53099a=$gameTemp['getLastPluginCommandInterpreter'](),_0x288cc3=BattleManager[_0x28f827(0x9e9)],_0x7c6a08=BattleManager['_subject'],_0x3f1105=BattleManager[_0x28f827(0x424)]?BattleManager[_0x28f827(0x424)][_0x28f827(0x25a)](0x0):[],_0x3d0ca2=BattleManager[_0x28f827(0x936)];if(!_0x53099a||!_0x288cc3||!_0x7c6a08)return;if(!_0x288cc3[_0x28f827(0xba9)]())return;if(_0x2d1d40[_0x28f827(0x2c2)])_0x3d0ca2[_0x28f827(0x119)](_0x28f827(0x52b),_0x7c6a08,_0x3f1105,![]);if(_0x2d1d40['WaitForNewLine'])_0x3d0ca2[_0x28f827(0x119)](_0x28f827(0x572));if(_0x2d1d40['WaitForEffect'])_0x3d0ca2[_0x28f827(0x119)](_0x28f827(0x399));if(_0x2d1d40['ClearBattleLog'])_0x3d0ca2[_0x28f827(0x119)]('clear');if(_0x2d1d40[_0x28f827(0x1ac)])_0x3d0ca2[_0x28f827(0x119)](_0x28f827(0x822),_0x7c6a08);if(_0x2d1d40[_0x28f827(0x9c0)])_0x3d0ca2['push']('waitForMovement');_0x53099a[_0x28f827(0x9c6)]('battlelog');}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_ChangeAngle',_0x4b1902=>{const _0x1e203e=_0x45d586;if(!SceneManager[_0x1e203e(0x81a)]())return;if(!Imported[_0x1e203e(0x2ff)])return;VisuMZ[_0x1e203e(0x536)](_0x4b1902,_0x4b1902);const _0x77f72b=$gameTemp['getLastPluginCommandInterpreter'](),_0x20a851=_0x4b1902[_0x1e203e(0x85b)];if(!_0x77f72b)return;$gameScreen[_0x1e203e(0x336)](_0x4b1902[_0x1e203e(0xbde)],_0x4b1902[_0x1e203e(0x7de)],_0x4b1902[_0x1e203e(0xb1d)]);if(_0x20a851)_0x77f72b['setWaitMode'](_0x1e203e(0xbf1));}),PluginManager['registerCommand'](pluginData['name'],_0x45d586(0x47f),_0x38d450=>{const _0x1ed81a=_0x45d586;if(!SceneManager[_0x1ed81a(0x81a)]())return;if(!Imported[_0x1ed81a(0x2ff)])return;VisuMZ[_0x1ed81a(0x536)](_0x38d450,_0x38d450);const _0x31e372=$gameTemp[_0x1ed81a(0x421)](),_0x127895=_0x38d450[_0x1ed81a(0x85b)];if(!_0x31e372)return;$gameScreen[_0x1ed81a(0x336)](0x0,_0x38d450[_0x1ed81a(0x7de)],_0x38d450[_0x1ed81a(0xb1d)]);if(_0x127895)_0x31e372[_0x1ed81a(0x9c6)](_0x1ed81a(0xbf1));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x6f9),_0x7ee33e=>{const _0x3c45c1=_0x45d586;if(!SceneManager[_0x3c45c1(0x81a)]())return;if(!Imported[_0x3c45c1(0x2ff)])return;const _0x26532f=$gameTemp[_0x3c45c1(0x421)]();if(!_0x26532f)return;_0x26532f[_0x3c45c1(0x9c6)](_0x3c45c1(0xbf1));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x696),_0x157b49=>{const _0x365746=_0x45d586;if(!SceneManager[_0x365746(0x81a)]())return;VisuMZ[_0x365746(0x536)](_0x157b49,_0x157b49);const _0x53f0de=$gameTemp[_0x365746(0x421)](),_0x5ca45f=BattleManager[_0x365746(0x9e9)],_0x55858a=BattleManager[_0x365746(0x1ce)],_0x3a829d=VisuMZ['CreateActionSequenceTargets'](_0x157b49['Targets']),_0x4949a9=_0x157b49['Mirror'],_0x186567=BattleManager[_0x365746(0x936)];if(!_0x53f0de||!_0x5ca45f||!_0x55858a)return;if(!_0x5ca45f[_0x365746(0xba9)]())return;let _0x341c19=_0x5ca45f[_0x365746(0xba9)]()[_0x365746(0x71b)];if(_0x341c19<0x0)_0x341c19=_0x55858a[_0x365746(0x746)]();$gameTemp[_0x365746(0x131)](_0x3a829d,_0x341c19,_0x4949a9),_0x157b49[_0x365746(0x6eb)]&&_0x53f0de[_0x365746(0x9c6)](_0x365746(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x967),_0x3e6e97=>{const _0x4ac3d3=_0x45d586;if(!SceneManager[_0x4ac3d3(0x81a)]())return;VisuMZ[_0x4ac3d3(0x536)](_0x3e6e97,_0x3e6e97);const _0x231123=$gameTemp[_0x4ac3d3(0x421)](),_0x566e77=BattleManager[_0x4ac3d3(0x1ce)],_0xc2515f=VisuMZ[_0x4ac3d3(0x552)](_0x3e6e97[_0x4ac3d3(0xba0)]),_0xc96449=_0x3e6e97[_0x4ac3d3(0xb58)],_0x476992=BattleManager['_logWindow'];if(!_0x231123||!_0x566e77)return;const _0x422639=_0x566e77[_0x4ac3d3(0x746)]();$gameTemp[_0x4ac3d3(0x131)](_0xc2515f,_0x422639,_0xc96449),_0x3e6e97[_0x4ac3d3(0x6eb)]&&_0x231123[_0x4ac3d3(0x9c6)](_0x4ac3d3(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x57d),_0x423ceb=>{const _0x996619=_0x45d586;if(!SceneManager[_0x996619(0x81a)]())return;VisuMZ['ConvertParams'](_0x423ceb,_0x423ceb);const _0x351602=_0x1ec888['attackAnimationIdSlot'](_0x423ceb[_0x996619(0xa66)]);if(_0x351602<=0x0)return;const _0x1daa2c=$gameTemp['getLastPluginCommandInterpreter'](),_0x1ec888=BattleManager['_subject'],_0x1d31a5=VisuMZ[_0x996619(0x552)](_0x423ceb['Targets']),_0x165630=_0x423ceb[_0x996619(0xb58)],_0x23aef9=BattleManager[_0x996619(0x936)];if(!_0x1daa2c||!_0x1ec888)return;$gameTemp[_0x996619(0x131)](_0x1d31a5,_0x351602,_0x165630),_0x423ceb[_0x996619(0x6eb)]&&_0x1daa2c[_0x996619(0x9c6)](_0x996619(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x8c3),_0x1d35d1=>{const _0x39422d=_0x45d586;if(!SceneManager[_0x39422d(0x81a)]())return;VisuMZ[_0x39422d(0x536)](_0x1d35d1,_0x1d35d1);const _0xb05a3f=$gameTemp[_0x39422d(0x421)](),_0x4c5b4b=VisuMZ[_0x39422d(0x552)](_0x1d35d1['Targets']),_0x2bb7e7=_0x1d35d1[_0x39422d(0x435)];let _0x2159b1=0x0;switch(_0x2bb7e7[_0x39422d(0x689)]()[_0x39422d(0x379)]()){case'!':case _0x39422d(0x3e2):_0x2159b1=0x1;break;case'?':case _0x39422d(0xb05):_0x2159b1=0x2;break;case _0x39422d(0x777):case _0x39422d(0x7b9):case _0x39422d(0x9e8):case _0x39422d(0x8a7):case _0x39422d(0x7d1):_0x2159b1=0x3;break;case _0x39422d(0xa52):case _0x39422d(0x546):_0x2159b1=0x4;break;case _0x39422d(0xf3):case _0x39422d(0x9bd):_0x2159b1=0x5;break;case _0x39422d(0x1d5):_0x2159b1=0x6;break;case _0x39422d(0xa44):case _0x39422d(0x3f3):case _0x39422d(0x659):_0x2159b1=0x7;break;case'SILENCE':case'...':_0x2159b1=0x8;break;case _0x39422d(0x186):case'BULB':case _0x39422d(0xe8):case _0x39422d(0x6b2):case _0x39422d(0x83c):_0x2159b1=0x9;break;case'Z':case'ZZ':case _0x39422d(0x50f):case _0x39422d(0x934):_0x2159b1=0xa;break;case _0x39422d(0x26f):_0x2159b1=0xb;break;case _0x39422d(0x783):_0x2159b1=0xc;break;case _0x39422d(0x24d):_0x2159b1=0xd;break;case _0x39422d(0x3b4):_0x2159b1=0xe;break;case'USER-DEFINED\x205':_0x2159b1=0xf;break;}for(const _0x1b4ca6 of _0x4c5b4b){if(!_0x1b4ca6)continue;$gameTemp[_0x39422d(0x226)](_0x1b4ca6,_0x2159b1);}_0x1d35d1[_0x39422d(0x826)]&&_0xb05a3f&&(_0xb05a3f[_0x39422d(0x643)](0x1),_0xb05a3f[_0x39422d(0x9c6)]('battleBalloon'));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Animation_BalloonIcon',_0x4b8160=>{const _0x3256bf=_0x45d586;if(!SceneManager[_0x3256bf(0x81a)]())return;if(!Imported[_0x3256bf(0x57e)])return;VisuMZ[_0x3256bf(0x536)](_0x4b8160,_0x4b8160);const _0x21abcf=$gameTemp['getLastPluginCommandInterpreter'](),_0x1622a=VisuMZ[_0x3256bf(0x552)](_0x4b8160[_0x3256bf(0xba0)]),_0x3cbc38=_0x4b8160[_0x3256bf(0x479)];for(const _0x3307b2 of _0x1622a){if(!_0x3307b2)continue;$gameTemp['requestBattleBalloon'](_0x3307b2,[_0x3cbc38]);}_0x4b8160[_0x3256bf(0x826)]&&_0x21abcf&&(_0x21abcf[_0x3256bf(0x643)](0x1),_0x21abcf[_0x3256bf(0x9c6)](_0x3256bf(0x26d)));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x8b8),_0x3b46fd=>{const _0x443523=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x443523(0x57e)])return;VisuMZ['ConvertParams'](_0x3b46fd,_0x3b46fd);const _0x106f84=$gameTemp[_0x443523(0x421)](),_0x5cb6b6=VisuMZ['CreateActionSequenceTargets'](_0x3b46fd[_0x443523(0xba0)]),_0x460238=Math[_0x443523(0xb4b)](Number(_0x3b46fd[_0x443523(0x4d8)]||0x0),Number(_0x3b46fd[_0x443523(0x6e5)]||0x0)),_0x453435=Math['max'](Number(_0x3b46fd[_0x443523(0x4d8)]||0x0),Number(_0x3b46fd['endIcon']||0x0)),_0x2d24da=[];for(let _0x5d10d3=_0x460238;_0x5d10d3<=_0x453435;_0x5d10d3++){_0x2d24da[_0x443523(0x119)](_0x5d10d3);}for(const _0x575a38 of _0x5cb6b6){if(!_0x575a38)continue;$gameTemp[_0x443523(0x226)](_0x575a38,_0x2d24da);}_0x3b46fd[_0x443523(0x826)]&&_0x106f84&&(_0x106f84[_0x443523(0x643)](0x1),_0x106f84[_0x443523(0x9c6)](_0x443523(0x26d)));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa93),_0x233694=>{const _0x235011=_0x45d586;if(!SceneManager[_0x235011(0x81a)]())return;if(!Imported[_0x235011(0x57e)])return;VisuMZ['ConvertParams'](_0x233694,_0x233694);const _0x2d6828=$gameTemp['getLastPluginCommandInterpreter'](),_0x49451c=VisuMZ[_0x235011(0x552)](_0x233694[_0x235011(0xba0)]),_0x39ae23=_0x233694[_0x235011(0xad3)];for(const _0x316412 of _0x49451c){if(!_0x316412)continue;$gameTemp[_0x235011(0x226)](_0x316412,_0x39ae23);}_0x233694['WaitComplete']&&_0x2d6828&&(_0x2d6828['wait'](0x1),_0x2d6828[_0x235011(0x9c6)](_0x235011(0x26d)));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Animation_CastAnimation',_0x43c551=>{const _0x18b1e2=_0x45d586;if(!SceneManager[_0x18b1e2(0x81a)]())return;VisuMZ[_0x18b1e2(0x536)](_0x43c551,_0x43c551);const _0x30f8b3=$gameTemp[_0x18b1e2(0x421)](),_0x5a49fb=BattleManager['_action'],_0x310269=_0x43c551[_0x18b1e2(0xb58)],_0x462ae4=VisuMZ[_0x18b1e2(0x552)](_0x43c551[_0x18b1e2(0xba0)]);if(!_0x30f8b3||!_0x5a49fb)return;if(!_0x5a49fb[_0x18b1e2(0xba9)]())return;for(const _0x5f086f of _0x462ae4){if(!_0x5f086f)continue;_0x5f086f['performCastAnimation'](_0x5a49fb,_0x310269);}if(_0x43c551[_0x18b1e2(0x6eb)])_0x30f8b3[_0x18b1e2(0x9c6)](_0x18b1e2(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xac1),_0x2519fe=>{const _0x3320f2=_0x45d586;VisuMZ[_0x3320f2(0x536)](_0x2519fe,_0x2519fe);const _0x4d824e=$gameTemp[_0x3320f2(0x421)](),_0xd665fb=VisuMZ[_0x3320f2(0x552)](_0x2519fe[_0x3320f2(0xba0)]),_0x168b6a=_0x2519fe[_0x3320f2(0x622)];if(!_0x168b6a)return;for(const _0x4ac972 of _0xd665fb){if(!_0x4ac972)continue;if(!_0x4ac972[_0x3320f2(0x7f0)]())continue;_0x4ac972['setBattlePortrait'](_0x168b6a);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x75d),_0x2609b9=>{const _0x2d1cd4=_0x45d586;VisuMZ[_0x2d1cd4(0x536)](_0x2609b9,_0x2609b9);const _0x244bc9=_0x2609b9[_0x2d1cd4(0x5e9)](),_0x5933ae=$gameActors[_0x2d1cd4(0xb77)](_0x244bc9)||null;if(!_0x5933ae){console[_0x2d1cd4(0x833)](_0x2d1cd4(0x549));return;}const _0xf857fd=_0x2609b9['FilenameJS']();_0x5933ae[_0x2d1cd4(0xacb)](_0xf857fd);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Animation_GuardAnimation',_0x515646=>{const _0x338cad=_0x45d586;if(!SceneManager[_0x338cad(0x81a)]())return;VisuMZ[_0x338cad(0x536)](_0x515646,_0x515646);const _0x447f97=$gameTemp[_0x338cad(0x421)](),_0x411e4a=BattleManager[_0x338cad(0x1ce)],_0x4d96d8=VisuMZ[_0x338cad(0x552)](_0x515646[_0x338cad(0xba0)]),_0x5a9dab=_0x515646['Mirror'];if(!_0x447f97||!_0x411e4a)return;const _0x3bce19=$dataSkilles[_0x411e4a[_0x338cad(0x1cc)]()],_0x4af036=_0x3bce19[_0x338cad(0x71b)];$gameTemp[_0x338cad(0x131)](_0x4d96d8,_0x4af036,_0x5a9dab),_0x515646['WaitForAnimation']&&_0x447f97['setWaitMode']('battleAnimation');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x93a),_0xb4f109=>{const _0x339d55=_0x45d586;if(!SceneManager[_0x339d55(0x81a)]())return;VisuMZ[_0x339d55(0x536)](_0xb4f109,_0xb4f109);const _0x4fefd6=$gameTemp[_0x339d55(0x421)](),_0x4ca2a5=VisuMZ[_0x339d55(0x552)](_0xb4f109[_0x339d55(0xba0)]),_0x5c2bfd=Number(_0xb4f109['ItemID']||0x1),_0x103f4d=$dataItems[_0x5c2bfd],_0x445b08=_0xb4f109['Mirror'];if(!_0x4fefd6)return;if(!_0x103f4d)return;let _0x23df01=_0x103f4d[_0x339d55(0x71b)];$gameTemp[_0x339d55(0x131)](_0x4ca2a5,_0x23df01,_0x445b08),_0xb4f109[_0x339d55(0x6eb)]&&_0x4fefd6[_0x339d55(0x9c6)](_0x339d55(0x1e0));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x620),_0x150c39=>{const _0x2d1204=_0x45d586;if(!SceneManager['_scene'])return;if(!SceneManager[_0x2d1204(0x4f4)]['_spriteset'])return;if(!Imported[_0x2d1204(0xbc5)])return;VisuMZ[_0x2d1204(0x536)](_0x150c39,_0x150c39);const _0x5f45e2=$gameTemp[_0x2d1204(0x421)](),_0x353254=Math['round'](_0x150c39[_0x2d1204(0x58a)]),_0x2ee5e2=Math['round'](_0x150c39['pointY']);$gameTemp['requestPointAnimation'](_0x353254,_0x2ee5e2,_0x150c39[_0x2d1204(0x163)],_0x150c39[_0x2d1204(0xb58)],_0x150c39[_0x2d1204(0x49f)]),_0x150c39[_0x2d1204(0x826)]&&_0x5f45e2&&(SceneManager[_0x2d1204(0x4f4)][_0x2d1204(0x992)]['updatePointAnimations'](),_0x5f45e2['setWaitMode'](_0x2d1204(0x1e0)));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x3c0),_0xd51548=>{const _0x3e9ef3=_0x45d586;if(!SceneManager[_0x3e9ef3(0x81a)]())return;VisuMZ[_0x3e9ef3(0x536)](_0xd51548,_0xd51548);const _0x20cefb=$gameTemp[_0x3e9ef3(0x421)](),_0x2e20c4=VisuMZ[_0x3e9ef3(0x552)](_0xd51548[_0x3e9ef3(0xba0)]),_0x10c29b=_0xd51548[_0x3e9ef3(0x163)],_0x44b6b4=_0xd51548[_0x3e9ef3(0xb58)];if(!_0x20cefb)return;$gameTemp[_0x3e9ef3(0x131)](_0x2e20c4,_0x10c29b,_0x44b6b4);if(_0xd51548[_0x3e9ef3(0x6eb)])_0x20cefb[_0x3e9ef3(0x9c6)]('battleAnimation');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xbeb),_0x339540=>{const _0x148f98=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x148f98(0x536)](_0x339540,_0x339540);const _0x1c8b65=$gameTemp[_0x148f98(0x421)](),_0x30bb9b=VisuMZ[_0x148f98(0x552)](_0x339540['Targets']),_0x54f91c=Number(_0x339540[_0x148f98(0x163)])||0x1,_0x12d47e=_0x339540[_0x148f98(0xb58)];if(!_0x1c8b65)return;$gameTemp[_0x148f98(0x131)](_0x30bb9b,_0x54f91c,_0x12d47e);if(_0x339540[_0x148f98(0x6eb)])_0x1c8b65[_0x148f98(0x9c6)](_0x148f98(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Animation_SkillAnimation',_0x50757a=>{const _0x24b623=_0x45d586;if(!SceneManager[_0x24b623(0x81a)]())return;VisuMZ[_0x24b623(0x536)](_0x50757a,_0x50757a);const _0xf41839=$gameTemp[_0x24b623(0x421)](),_0x3c45e8=VisuMZ[_0x24b623(0x552)](_0x50757a[_0x24b623(0xba0)]),_0x5db7d0=Number(_0x50757a[_0x24b623(0xfe)]||0x1),_0x5db81e=$dataSkills[_0x5db7d0],_0x120376=_0x50757a['Mirror'];if(!_0xf41839)return;if(!_0x5db81e)return;let _0x5d131d=_0x5db81e[_0x24b623(0x71b)];$gameTemp[_0x24b623(0x131)](_0x3c45e8,_0x5d131d,_0x120376),_0x50757a[_0x24b623(0x6eb)]&&_0xf41839[_0x24b623(0x9c6)](_0x24b623(0x1e0));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Animation_WaitForAnimation',_0x4a8496=>{const _0x833a8a=_0x45d586;if(!SceneManager[_0x833a8a(0x81a)]())return;const _0x26ca62=$gameTemp[_0x833a8a(0x421)]();if(!_0x26ca62)return;_0x26ca62[_0x833a8a(0x9c6)]('battleAnimation');}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x109),_0x5477b2=>{const _0x2296e8=_0x45d586;if(!SceneManager[_0x2296e8(0x81a)]())return;VisuMZ[_0x2296e8(0x536)](_0x5477b2,_0x5477b2);const _0xb0d7ca=BattleManager['_logWindow'],_0x3da41b=_0x5477b2['CopyCombatLog']&&Imported[_0x2296e8(0x281)];_0xb0d7ca[_0x2296e8(0x53b)](_0x5477b2[_0x2296e8(0x6a0)]),_0x3da41b&&Imported[_0x2296e8(0x281)]&&$gameSystem[_0x2296e8(0x88e)](_0x5477b2[_0x2296e8(0x6a0)]||'',_0x5477b2[_0x2296e8(0x57c)]||0x0);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x2d3),_0x599054=>{const _0x59f4c0=_0x45d586;if(!SceneManager[_0x59f4c0(0x81a)]())return;const _0x303393=BattleManager[_0x59f4c0(0x936)];_0x303393['clear']();}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x569),_0x18d25c=>{const _0x2775d=_0x45d586;if(!SceneManager[_0x2775d(0x81a)]())return;const _0x68ee21=$gameTemp[_0x2775d(0x421)](),_0x257f5a=BattleManager[_0x2775d(0x9e9)],_0xe6c9f=BattleManager[_0x2775d(0x1ce)],_0x781da9=BattleManager[_0x2775d(0x936)];if(!_0x68ee21||!_0x257f5a||!_0xe6c9f)return;if(!_0x257f5a[_0x2775d(0xba9)]())return;_0x781da9[_0x2775d(0x950)](_0xe6c9f,_0x257f5a[_0x2775d(0xba9)]()),_0x68ee21[_0x2775d(0x9c6)](_0x2775d(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x583),_0x22fe65=>{const _0x4159b8=_0x45d586;if(!SceneManager[_0x4159b8(0x81a)]())return;const _0x290519=BattleManager[_0x4159b8(0x936)];_0x290519['popBaseLine']();}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x88c),_0x4abaa7=>{const _0x274289=_0x45d586;if(!SceneManager[_0x274289(0x81a)]())return;const _0x3bdb85=BattleManager[_0x274289(0x936)];_0x3bdb85[_0x274289(0x787)]();}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x27d),_0x4f38f2=>{const _0x33b307=_0x45d586;if(!SceneManager[_0x33b307(0x81a)]())return;const _0xfadd9d=BattleManager[_0x33b307(0x936)];_0xfadd9d['refresh']();}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x96e),_0x23d910=>{const _0x43023e=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x43023e(0x536)](_0x23d910,_0x23d910),SceneManager[_0x43023e(0x4f4)][_0x43023e(0x60d)](_0x23d910[_0x43023e(0xabd)]);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x9d7),_0x140c92=>{const _0x41c98e=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x286cc3=$gameTemp[_0x41c98e(0x421)]();_0x286cc3[_0x41c98e(0x9c6)]('battlelog');}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0xbe2),_0x7fbf8f=>{const _0x36cf0e=_0x45d586;if(!SceneManager[_0x36cf0e(0x81a)]())return;const _0x1ddd8b=$gameTemp[_0x36cf0e(0x421)](),_0x5f37f0=BattleManager['_logWindow'];_0x5f37f0[_0x36cf0e(0x572)](),_0x1ddd8b[_0x36cf0e(0x9c6)]('battlelog');}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Camera_Clamp',_0x3d493b=>{const _0x19c7e9=_0x45d586;if(!SceneManager[_0x19c7e9(0x81a)]())return;if(!Imported[_0x19c7e9(0x2ff)])return;VisuMZ[_0x19c7e9(0x536)](_0x3d493b,_0x3d493b);const _0x58435b=$gameScreen[_0x19c7e9(0x378)]();_0x58435b[_0x19c7e9(0x25f)]=_0x3d493b[_0x19c7e9(0xb08)];}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0xbb0),_0x59aa09=>{const _0x4335be=_0x45d586;if(!SceneManager[_0x4335be(0x81a)]())return;if(!Imported[_0x4335be(0x2ff)])return;VisuMZ[_0x4335be(0x536)](_0x59aa09,_0x59aa09);const _0x23b336=$gameTemp[_0x4335be(0x421)](),_0x2e5073=_0x59aa09[_0x4335be(0x60b)];$gameScreen['setBattleCameraPoint'](_0x59aa09[_0x4335be(0xa39)],_0x59aa09['FocusY'],_0x59aa09['Duration'],_0x59aa09[_0x4335be(0xb1d)]);if(_0x2e5073)_0x23b336[_0x4335be(0x9c6)]('battleCamera');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Camera_FocusTarget',_0x3df10a=>{const _0x53ec31=_0x45d586;if(!SceneManager[_0x53ec31(0x81a)]())return;if(!Imported[_0x53ec31(0x2ff)])return;VisuMZ[_0x53ec31(0x536)](_0x3df10a,_0x3df10a);const _0xbb3652=$gameTemp[_0x53ec31(0x421)](),_0x4d464c=VisuMZ[_0x53ec31(0x552)](_0x3df10a[_0x53ec31(0xba0)]),_0x2a3588=_0x3df10a['WaitForCamera'];$gameScreen[_0x53ec31(0x599)](_0x4d464c,_0x3df10a[_0x53ec31(0x7de)],_0x3df10a[_0x53ec31(0xb1d)]);if(_0x2a3588)_0xbb3652['setWaitMode']('battleCamera');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x835),_0xfbacc1=>{const _0xf5170d=_0x45d586;if(!SceneManager[_0xf5170d(0x81a)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0xf5170d(0x536)](_0xfbacc1,_0xfbacc1);const _0x4f0be9=$gameTemp['getLastPluginCommandInterpreter'](),_0x4f9f92=_0xfbacc1['WaitForCamera'];$gameScreen['setBattleCameraOffset'](_0xfbacc1[_0xf5170d(0x34f)],_0xfbacc1[_0xf5170d(0x261)],_0xfbacc1[_0xf5170d(0x7de)],_0xfbacc1['EasingType']);if(_0x4f9f92)_0x4f0be9['setWaitMode'](_0xf5170d(0xad7));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x322),_0x48efd5=>{const _0x38fd12=_0x45d586;if(!SceneManager[_0x38fd12(0x81a)]())return;if(!Imported[_0x38fd12(0x2ff)])return;VisuMZ[_0x38fd12(0x536)](_0x48efd5,_0x48efd5);const _0x3aba7f=$gameTemp[_0x38fd12(0x421)](),_0x259b04=_0x48efd5[_0x38fd12(0x68c)],_0x3cd42e=_0x48efd5[_0x38fd12(0x8c4)],_0x40576e=_0x48efd5['WaitForCamera'];if(_0x259b04){const _0x16b796=Math[_0x38fd12(0x31d)](Graphics[_0x38fd12(0x7ea)]/0x2),_0x396776=Math['round'](Graphics[_0x38fd12(0x6ac)]/0x2);$gameScreen[_0x38fd12(0x1d0)](_0x16b796,_0x396776,_0x48efd5[_0x38fd12(0x7de)],_0x48efd5[_0x38fd12(0xb1d)]);}_0x3cd42e&&$gameScreen['setBattleCameraOffset'](0x0,0x0,_0x48efd5[_0x38fd12(0x7de)],_0x48efd5['EasingType']);if(_0x40576e)_0x3aba7f['setWaitMode']('battleCamera');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Camera_WaitForCamera',_0x16658a=>{const _0x36f8dd=_0x45d586;if(!SceneManager[_0x36f8dd(0x81a)]())return;if(!Imported[_0x36f8dd(0x2ff)])return;const _0x5246a3=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x5246a3)return;_0x5246a3['setWaitMode']('battleCamera');}),VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x6b8)]=function(_0x53c876){const _0x122f9a=_0x45d586;_0x53c876[_0x122f9a(0x183)]='';const _0x5267ff=VisuMZ[_0x122f9a(0x2e2)][_0x122f9a(0x6b8)](_0x53c876),_0x13a97a=VisuMZ[_0x122f9a(0x552)](_0x53c876['Targets'])[0x0]||null;return _0x13a97a&&(_0x5267ff[_0x122f9a(0x183)]=_0x13a97a[_0x122f9a(0xa4e)](),_0x5267ff[_0x122f9a(0x9b0)]=_0x13a97a[_0x122f9a(0x126)](),_0x5267ff[_0x122f9a(0x9f4)]=_0x13a97a[_0x122f9a(0x888)](),_0x5267ff['portraitType']=_0x13a97a[_0x122f9a(0xaf7)](),_0x13a97a[_0x122f9a(0x690)]()&&(_0x13a97a['flipVisualCutinHorz']()&&(_0x5267ff['portraitFlipHorz']=!_0x5267ff['portraitFlipHorz']),_0x13a97a[_0x122f9a(0xa21)]()&&(_0x5267ff[_0x122f9a(0x272)]=!_0x5267ff[_0x122f9a(0x272)]),_0x5267ff['portraitType']==='svActor'&&(_0x5267ff[_0x122f9a(0xb44)]=!_0x5267ff[_0x122f9a(0xb44)]),_0x53c876[_0x122f9a(0x10d)][_0x122f9a(0x189)]&&(_0x5267ff['parallaxScrollX']*=-0x1),_0x53c876[_0x122f9a(0x10d)][_0x122f9a(0x1ad)]&&(_0x5267ff['parallaxScrollY']*=-0x1),_0x5267ff['parallaxHue']+=_0x53c876['ExtraSettings'][_0x122f9a(0x830)]??0x0)),_0x5267ff;},PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Cutin_AddVisualCutinEffect',_0x1ae756=>{const _0xce086b=_0x45d586;if(!SceneManager[_0xce086b(0x81a)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;VisuMZ[_0xce086b(0x536)](_0x1ae756,_0x1ae756);const _0x59cd03=VisuMZ['BattleCore'][_0xce086b(0x6b8)](_0x1ae756);SceneManager['_scene']['startVisualCutin'](_0x59cd03);const _0x10810a=$gameTemp[_0xce086b(0x421)]();_0x10810a&&_0x1ae756[_0xce086b(0xb01)]&&_0x10810a[_0xce086b(0x9c6)](_0xce086b(0xe7));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x97f),_0x207630=>{const _0x436cd2=_0x45d586;if(!SceneManager[_0x436cd2(0x81a)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;VisuMZ[_0x436cd2(0x536)](_0x207630,_0x207630),SceneManager[_0x436cd2(0x4f4)]['clearAllVisualCutins']();const _0x179fcb=$gameTemp[_0x436cd2(0x421)]();_0x179fcb&&_0x207630[_0x436cd2(0x935)]&&_0x179fcb['setWaitMode'](_0x436cd2(0xb91));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x352),_0x3145d1=>{const _0x5b3e94=_0x45d586;if(!SceneManager[_0x5b3e94(0x81a)]())return;if(!Imported[_0x5b3e94(0x3ed)])return;VisuMZ['ConvertParams'](_0x3145d1,_0x3145d1);const _0x58fe60=_0x3145d1[_0x5b3e94(0x267)][_0x5b3e94(0x2ab)]()['trim']();SceneManager[_0x5b3e94(0x4f4)][_0x5b3e94(0xb07)](_0x58fe60);const _0x127489=$gameTemp['getLastPluginCommandInterpreter']();_0x127489&&_0x3145d1['WaitForExit']&&_0x127489[_0x5b3e94(0x9c6)](_0x5b3e94(0xb91));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x8c5),_0x37e1d5=>{const _0x360609=_0x45d586;if(!SceneManager[_0x360609(0x81a)]())return;if(!Imported[_0x360609(0x3ed)])return;const _0x2f4bf5=$gameTemp[_0x360609(0x421)]();_0x2f4bf5['setWaitMode'](_0x360609(0xe7));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x2de),_0x4b9b55=>{const _0x1cb6b0=_0x45d586;if(!SceneManager[_0x1cb6b0(0x81a)]())return;if(!Imported[_0x1cb6b0(0x3ed)])return;const _0x3a74cc=$gameTemp[_0x1cb6b0(0x421)]();_0x3a74cc[_0x1cb6b0(0x9c6)]('cutinExit');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_DB_DragonbonesMotionAni',_0x40c88d=>{const _0x1ef8d5=_0x45d586;if(!SceneManager[_0x1ef8d5(0x81a)]())return;if(!Imported[_0x1ef8d5(0xb21)])return;VisuMZ[_0x1ef8d5(0x536)](_0x40c88d,_0x40c88d);const _0x78991=VisuMZ[_0x1ef8d5(0x552)](_0x40c88d[_0x1ef8d5(0xba0)]),_0x3ccb91=_0x40c88d[_0x1ef8d5(0x221)][_0x1ef8d5(0x2ab)]()[_0x1ef8d5(0x379)]();for(const _0x65fc83 of _0x78991){if(!_0x65fc83)continue;_0x65fc83[_0x1ef8d5(0x4d1)](_0x3ccb91);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_DB_DragonbonesTimeScale',_0x34106b=>{const _0x1c8003=_0x45d586;if(!SceneManager[_0x1c8003(0x81a)]())return;if(!Imported[_0x1c8003(0xb21)])return;VisuMZ[_0x1c8003(0x536)](_0x34106b,_0x34106b);const _0x4947cd=VisuMZ[_0x1c8003(0x552)](_0x34106b['Targets']),_0x1c8b84=_0x34106b[_0x1c8003(0x5de)];for(const _0x103f7c of _0x4947cd){if(!_0x103f7c)continue;_0x103f7c[_0x1c8003(0x113)]()['timeScale']=_0x1c8b84;}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x1cb),_0x3c8764=>{const _0x192041=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x192041(0x9f9)])return;VisuMZ[_0x192041(0x536)](_0x3c8764,_0x3c8764);const _0x91dd96=BattleManager[_0x192041(0x9e9)],_0x312b33=_0x3c8764[_0x192041(0x59a)];if(!_0x91dd96)return;_0x91dd96[_0x192041(0x99c)]=_0x312b33;}),PluginManager['registerCommand'](pluginData['name'],_0x45d586(0x9b7),_0x4d429d=>{const _0x459b48=_0x45d586;if(!SceneManager[_0x459b48(0x81a)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;const _0x2a5325=BattleManager[_0x459b48(0x9e9)];if(!_0x2a5325)return;_0x2a5325[_0x459b48(0x448)]();}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Element_ForceElements',_0x3cac13=>{const _0x5a5594=_0x45d586;if(!SceneManager[_0x5a5594(0x81a)]())return;if(!Imported['VisuMZ_1_ElementStatusCore'])return;VisuMZ[_0x5a5594(0x536)](_0x3cac13,_0x3cac13);const _0x1faef0=BattleManager[_0x5a5594(0x9e9)],_0x5bbc0c=_0x3cac13[_0x5a5594(0x59a)];if(!_0x1faef0)return;_0x1faef0['_battleCoreForcedElements']=_0x5bbc0c;}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x2cd),_0x1ef3a2=>{const _0x30911e=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x30911e(0x9f9)])return;const _0xc1ce7c=BattleManager['_action'];if(!_0xc1ce7c)return;_0xc1ce7c['_battleCoreNoElement']=!![];}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x64f),_0x47e30c=>{const _0x1444d6=_0x45d586;VisuMZ[_0x1444d6(0x895)][_0x1444d6(0x64f)](_0x47e30c);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Grid_AddPassiveStatesToNode',_0x52f8f6=>{const _0x5d5b3d=_0x45d586;VisuMZ[_0x5d5b3d(0x895)][_0x5d5b3d(0xb34)](_0x52f8f6);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x76d),_0x316c04=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_AddTriggerToNode'](_0x316c04);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x24c),_0x4d7b2e=>{const _0xf921fc=_0x45d586;VisuMZ[_0xf921fc(0x895)][_0xf921fc(0x76d)](_0x4d7b2e);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x5af),_0x4dbc87=>{const _0x496991=_0x45d586;VisuMZ[_0x496991(0x895)][_0x496991(0x5af)](_0x4dbc87);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Grid_AnimationJsAtNode',_0x5121f5=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_AnimationJsAtNode'](_0x5121f5);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Grid_AnimationTypeAtNode',_0x4c42c6=>{const _0x2cc917=_0x45d586;VisuMZ[_0x2cc917(0x895)]['ActSeq_Grid_AnimationTypeAtNode'](_0x4c42c6);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x21a),_0x29a705=>{const _0x3af2f1=_0x45d586;VisuMZ['BattleGridSystem'][_0x3af2f1(0x21a)](_0x29a705);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Grid_MoveTargetsInDirection',_0x3ef858=>{const _0x379f29=_0x45d586;VisuMZ[_0x379f29(0x895)][_0x379f29(0x600)](_0x3ef858);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xbd5),_0x4449b2=>{const _0x2c6629=_0x45d586;VisuMZ[_0x2c6629(0x895)]['ActSeq_Grid_PullToTargetNode'](_0x4449b2);}),PluginManager['registerCommand'](pluginData['name'],_0x45d586(0x36f),_0x131f6d=>{const _0x150ede=_0x45d586;VisuMZ[_0x150ede(0x895)][_0x150ede(0x36f)](_0x131f6d);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x8ce),_0x50cd69=>{const _0x20f6bd=_0x45d586;VisuMZ[_0x20f6bd(0x895)]['ActSeq_Grid_RemovePassiveStatesFromNode'](_0x50cd69);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x88d),_0x21815a=>{const _0x47aedf=_0x45d586;VisuMZ[_0x47aedf(0x895)]['ActSeq_Grid_RemoveTriggerFromNode'](_0x21815a);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x72f),_0x1c7c5f=>{const _0x2b9e71=_0x45d586;VisuMZ['BattleGridSystem'][_0x2b9e71(0x72f)](_0x1c7c5f);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5c7),_0x4d7978=>{const _0x3e058c=_0x45d586;VisuMZ[_0x3e058c(0x895)][_0x3e058c(0x5c7)](_0x4d7978);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x974),_0x5391b2=>{const _0x1a533b=_0x45d586;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x1a533b(0x81a)]())return;VisuMZ[_0x1a533b(0x536)](_0x5391b2,_0x5391b2);const _0x28181d=VisuMZ[_0x1a533b(0x552)](_0x5391b2['Targets']);for(const _0x4eee8e of _0x28181d){if(!_0x4eee8e)continue;_0x4eee8e[_0x1a533b(0x382)](_0x1a533b(0x419)),_0x4eee8e[_0x1a533b(0x382)](_0x1a533b(0x2d8)),_0x4eee8e['removeHorrorEffect']('tv'),_0x4eee8e[_0x1a533b(0x3ec)]();}$gamePlayer['refresh']();}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x3c4),_0x103d46=>{const _0x4a664f=_0x45d586;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x4a664f(0x81a)]())return;VisuMZ['ConvertParams'](_0x103d46,_0x103d46);const _0x4d9c28=VisuMZ[_0x4a664f(0x552)](_0x103d46[_0x4a664f(0xba0)]),_0x2b1e0c=_0x4a664f(0x2d8);_0x103d46[_0x4a664f(0x5d6)]=Math[_0x4a664f(0xb32)](_0x103d46[_0x4a664f(0xaf2)]/0x2),_0x103d46[_0x4a664f(0xb18)]=_0x103d46[_0x4a664f(0xaf2)],_0x103d46[_0x4a664f(0x741)]=!![];for(const _0x385bef of _0x4d9c28){if(!_0x385bef)continue;_0x385bef['setHorrorEffectSettings'](_0x2b1e0c,_0x103d46);}$gamePlayer[_0x4a664f(0x291)]();}),PluginManager['registerCommand'](pluginData['name'],_0x45d586(0x66d),_0x4712a5=>{const _0x329d53=_0x45d586;if(!Imported[_0x329d53(0x7f4)])return;if(!SceneManager[_0x329d53(0x81a)]())return;VisuMZ[_0x329d53(0x536)](_0x4712a5,_0x4712a5);const _0x570fa0=VisuMZ['CreateActionSequenceTargets'](_0x4712a5[_0x329d53(0xba0)]);for(const _0x4eed58 of _0x570fa0){if(!_0x4eed58)continue;_0x4eed58[_0x329d53(0x382)](_0x329d53(0x2d8));}$gamePlayer[_0x329d53(0x291)]();}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa90),_0x509566=>{const _0x5bdc34=_0x45d586;if(!Imported[_0x5bdc34(0x7f4)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5bdc34(0x536)](_0x509566,_0x509566);const _0x48c5f8=VisuMZ[_0x5bdc34(0x552)](_0x509566[_0x5bdc34(0xba0)]),_0xc4c7dc=_0x5bdc34(0x419);for(const _0x314844 of _0x48c5f8){if(!_0x314844)continue;_0x314844[_0x5bdc34(0x65a)](_0xc4c7dc,_0x509566);}$gamePlayer[_0x5bdc34(0x291)]();}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0xab3),_0x445e04=>{const _0x3d8554=_0x45d586;if(!Imported[_0x3d8554(0x7f4)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3d8554(0x536)](_0x445e04,_0x445e04);const _0x111b59=VisuMZ['CreateActionSequenceTargets'](_0x445e04[_0x3d8554(0xba0)]);for(const _0x277c5c of _0x111b59){if(!_0x277c5c)continue;_0x277c5c['removeHorrorEffect']('noise');}$gamePlayer[_0x3d8554(0x291)]();}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0xbe8),_0x3c3676=>{const _0x76fc49=_0x45d586;if(!Imported[_0x76fc49(0x7f4)])return;if(!SceneManager[_0x76fc49(0x81a)]())return;VisuMZ['ConvertParams'](_0x3c3676,_0x3c3676);const _0x39bd23=VisuMZ['CreateActionSequenceTargets'](_0x3c3676['Targets']),_0xc06b52='tv';for(const _0x3f8846 of _0x39bd23){if(!_0x3f8846)continue;_0x3f8846[_0x76fc49(0x65a)](_0xc06b52,_0x3c3676);}$gamePlayer[_0x76fc49(0x291)]();}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Horror_TVRemove',_0x395dfb=>{const _0xb138f8=_0x45d586;if(!Imported[_0xb138f8(0x7f4)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xb138f8(0x536)](_0x395dfb,_0x395dfb);const _0x3e4251=VisuMZ['CreateActionSequenceTargets'](_0x395dfb[_0xb138f8(0xba0)]);for(const _0x5f37b6 of _0x3e4251){if(!_0x5f37b6)continue;_0x5f37b6[_0xb138f8(0x382)]('tv');}$gamePlayer[_0xb138f8(0x291)]();}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x792),_0x43cc2d=>{const _0x4fd095=_0x45d586;if(!Imported[_0x4fd095(0x79a)])return;const _0x34efa2=SceneManager[_0x4fd095(0x4f4)][_0x4fd095(0x992)];if(!_0x34efa2)return;if(VisuMZ['ActSeqImpact'][_0x4fd095(0x23e)]<=1.04){alert(_0x4fd095(0x4e4)),SceneManager[_0x4fd095(0x16f)]();return;}VisuMZ['ConvertParams'](_0x43cc2d,_0x43cc2d);const _0x5b1ccb=_0x43cc2d[_0x4fd095(0x8fa)];_0x34efa2[_0x4fd095(0x931)](_0x5b1ccb);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0xbc8),_0x4397b8=>{const _0x2d2f8f=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2d2f8f(0x79a)])return;const _0x346d30=SceneManager['_scene'][_0x2d2f8f(0x992)];if(!_0x346d30)return;VisuMZ['ConvertParams'](_0x4397b8,_0x4397b8);const _0x1596fe=_0x4397b8[_0x2d2f8f(0xb5f)]||0x1,_0x34bfc4=_0x4397b8[_0x2d2f8f(0x7de)]||0x1,_0x25e970=_0x4397b8['EasingType']||'Linear';_0x346d30[_0x2d2f8f(0x15e)](_0x1596fe,_0x34bfc4,_0x25e970);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xadd),_0x37afcb=>{const _0x56a21e=_0x45d586;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x4483c2=SceneManager[_0x56a21e(0x4f4)][_0x56a21e(0x992)];if(!_0x4483c2)return;if(VisuMZ['ActSeqImpact'][_0x56a21e(0x23e)]<=1.04){alert(_0x56a21e(0x4e4)),SceneManager['exit']();return;}VisuMZ[_0x56a21e(0x536)](_0x37afcb,_0x37afcb);const _0x509fd0=_0x37afcb[_0x56a21e(0x8fa)];_0x4483c2[_0x56a21e(0x730)](_0x509fd0);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x2a5),_0x5d2a70=>{const _0x4125f6=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4125f6(0x79a)])return;const _0x29008e=SceneManager['_scene'][_0x4125f6(0x992)];if(!_0x29008e)return;VisuMZ[_0x4125f6(0x536)](_0x5d2a70,_0x5d2a70);const _0x2df380=Number(_0x5d2a70[_0x4125f6(0xbde)])||0x0,_0x467ac3=Number(_0x5d2a70['Rate']),_0x30e64f=_0x5d2a70[_0x4125f6(0x7de)]||0x1,_0x358f1a=_0x5d2a70['EasingType']||'Linear';_0x29008e[_0x4125f6(0xa80)](_0x2df380,_0x467ac3,_0x30e64f,_0x358f1a);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa81),_0x21c57c=>{const _0x31cb69=_0x45d586;if(!SceneManager[_0x31cb69(0x81a)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x23b8f8=SceneManager['_scene']['_spriteset'];if(!_0x23b8f8)return;VisuMZ[_0x31cb69(0x536)](_0x21c57c,_0x21c57c);const _0x344ea8=Number(_0x21c57c[_0x31cb69(0xbde)])||0x0,_0x42c056=Number(_0x21c57c[_0x31cb69(0x19a)]),_0xe133e0=_0x21c57c['Duration']||0x1,_0xfbcfd=_0x21c57c[_0x31cb69(0xb1d)]||_0x31cb69(0xa8e),_0x47fcd8=VisuMZ['CreateActionSequenceTargets'](_0x21c57c['Targets']);for(const _0x4fc027 of _0x47fcd8){if(!_0x4fc027)continue;if(!_0x4fc027['battler']())continue;_0x4fc027['battler']()[_0x31cb69(0xa80)](_0x344ea8,_0x42c056,_0xe133e0,_0xfbcfd);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x243),_0x1621c1=>{const _0x14b82a=_0x45d586;if(!SceneManager[_0x14b82a(0x81a)]())return;if(!Imported[_0x14b82a(0x79a)])return;VisuMZ[_0x14b82a(0x536)](_0x1621c1,_0x1621c1);const _0x2bdafa={'delay':_0x1621c1[_0x14b82a(0x37d)],'duration':_0x1621c1[_0x14b82a(0x8fc)],'hue':_0x1621c1[_0x14b82a(0x9ec)],'opacityStart':_0x1621c1[_0x14b82a(0x4b9)],'tone':_0x1621c1[_0x14b82a(0x4ba)],'visible':!![]},_0xf589d0=VisuMZ['CreateActionSequenceTargets'](_0x1621c1['Targets']);for(const _0x1d48fb of _0xf589d0){if(!_0x1d48fb)continue;_0x1d48fb[_0x14b82a(0xb1f)](_0x2bdafa);}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x55a),_0x195c15=>{const _0x2a2f89=_0x45d586;if(!SceneManager[_0x2a2f89(0x81a)]())return;if(!Imported[_0x2a2f89(0x79a)])return;VisuMZ[_0x2a2f89(0x536)](_0x195c15,_0x195c15);const _0x3f9c0a=VisuMZ[_0x2a2f89(0x552)](_0x195c15[_0x2a2f89(0xba0)]);for(const _0x39fd44 of _0x3f9c0a){if(!_0x39fd44)continue;_0x39fd44[_0x2a2f89(0x30f)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x709),_0x20f4e5=>{const _0x1f8221=_0x45d586;if(!Imported[_0x1f8221(0x79a)])return;const _0x2c92db=SceneManager[_0x1f8221(0x4f4)]['_spriteset'];if(!_0x2c92db)return;if(VisuMZ[_0x1f8221(0x1af)][_0x1f8221(0x23e)]<=1.04){alert(_0x1f8221(0x4e4)),SceneManager['exit']();return;}VisuMZ[_0x1f8221(0x536)](_0x20f4e5,_0x20f4e5);const _0x1dd2ec=_0x20f4e5[_0x1f8221(0x8fa)];_0x2c92db[_0x1f8221(0x43f)](_0x1dd2ec);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x65f),_0x48ab38=>{const _0xac73a7=_0x45d586;if(!Imported[_0xac73a7(0x79a)])return;const _0x129c66=SceneManager[_0xac73a7(0x4f4)][_0xac73a7(0x992)];if(!_0x129c66)return;if(VisuMZ[_0xac73a7(0x1af)][_0xac73a7(0x23e)]<=1.04){alert(_0xac73a7(0x4e4)),SceneManager['exit']();return;}VisuMZ[_0xac73a7(0x536)](_0x48ab38,_0x48ab38);const _0x4c0b7b=_0x48ab38[_0xac73a7(0x8fa)];_0x129c66[_0xac73a7(0x98e)](_0x4c0b7b);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x634),_0x230b67=>{const _0x3e081d=_0x45d586;if(!Imported[_0x3e081d(0x79a)])return;const _0x18cbce=SceneManager[_0x3e081d(0x4f4)][_0x3e081d(0x992)];if(!_0x18cbce)return;VisuMZ['ConvertParams'](_0x230b67,_0x230b67);const _0x5970dc=_0x230b67['X']||0x0,_0x1ef771=_0x230b67['Y']||0x0,_0x2c0dae=_0x230b67[_0x3e081d(0x3f7)]||0x0,_0x26afe2=_0x230b67[_0x3e081d(0x7c0)]||0x0,_0x5bdb9b=_0x230b67[_0x3e081d(0x7de)]||0x1;_0x18cbce[_0x3e081d(0xb80)](_0x5970dc,_0x1ef771,_0x2c0dae,_0x26afe2,_0x5bdb9b);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5b2),_0x37cc4e=>{const _0x446d8d=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x446d8d(0x79a)])return;const _0x54c306=SceneManager['_scene']['_spriteset'];if(!_0x54c306)return;VisuMZ[_0x446d8d(0x536)](_0x37cc4e,_0x37cc4e);const _0x5661a2=VisuMZ['CreateActionSequenceTargets'](_0x37cc4e[_0x446d8d(0xba0)]),_0x488a53=_0x37cc4e[_0x446d8d(0x4c9)],_0x317126=_0x37cc4e[_0x446d8d(0x34f)]||0x0,_0x57f1a6=_0x37cc4e[_0x446d8d(0x261)]||0x0,_0x4fd3e5=_0x37cc4e[_0x446d8d(0x3f7)]||0x0,_0x1d0c22=_0x37cc4e[_0x446d8d(0x7c0)]||0x0,_0x347d2a=_0x37cc4e['Duration']||0x1;for(const _0x208b0a of _0x5661a2){if(!_0x208b0a)continue;if(!_0x208b0a[_0x446d8d(0xa7b)]())continue;const _0x3353be=_0x208b0a[_0x446d8d(0xa7b)]();let _0x1ddcfc=_0x3353be['_baseX'],_0x3544f9=_0x3353be[_0x446d8d(0x83d)];_0x1ddcfc+=(Graphics[_0x446d8d(0x7ea)]-Graphics['boxWidth'])/0x2,_0x3544f9+=(Graphics['height']-Graphics[_0x446d8d(0x56c)])/0x2;if(_0x488a53['match'](/front/i))_0x1ddcfc+=(_0x208b0a[_0x446d8d(0x690)]()?0x1:-0x1)*_0x3353be['mainSpriteWidth']()/0x2;else _0x488a53[_0x446d8d(0x95f)](/back/i)&&(_0x1ddcfc+=(_0x208b0a[_0x446d8d(0x690)]()?-0x1:0x1)*_0x3353be[_0x446d8d(0x102)]()/0x2);if(_0x488a53[_0x446d8d(0x95f)](/head/i))_0x3544f9-=_0x3353be['mainSpriteHeight']();else _0x488a53[_0x446d8d(0x95f)](/center/i)&&(_0x3544f9-=_0x3353be[_0x446d8d(0xa23)]()/0x2);_0x1ddcfc+=_0x317126,_0x3544f9+=_0x57f1a6,_0x54c306[_0x446d8d(0xb80)](_0x1ddcfc,_0x3544f9,_0x4fd3e5,_0x1d0c22,_0x347d2a);}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x219),_0x1996c3=>{const _0x4a18dc=_0x45d586;if(!SceneManager[_0x4a18dc(0x81a)]())return;if(!Imported[_0x4a18dc(0x79a)])return;const _0x2e8e06=SceneManager[_0x4a18dc(0x4f4)][_0x4a18dc(0x992)];if(!_0x2e8e06)return;VisuMZ[_0x4a18dc(0x536)](_0x1996c3,_0x1996c3);const _0x3924de=VisuMZ[_0x4a18dc(0x552)](_0x1996c3[_0x4a18dc(0xba0)]),_0x21c69c=_0x1996c3[_0x4a18dc(0x4c9)],_0x89ee10=_0x1996c3[_0x4a18dc(0x34f)]||0x0,_0x5de7f1=_0x1996c3[_0x4a18dc(0x261)]||0x0,_0x173220=_0x1996c3['Amp']||0x0,_0x3c3210=_0x1996c3[_0x4a18dc(0x7c0)]||0x0,_0x1f7a29=_0x1996c3[_0x4a18dc(0x7de)]||0x1,_0x1f4e6b=Math['min'](..._0x3924de[_0x4a18dc(0x7a1)](_0x49fdfd=>_0x49fdfd['battler']()[_0x4a18dc(0x5bb)]-_0x49fdfd[_0x4a18dc(0xa7b)]()[_0x4a18dc(0x102)]()/0x2)),_0x21154d=Math['max'](..._0x3924de[_0x4a18dc(0x7a1)](_0x48efd3=>_0x48efd3[_0x4a18dc(0xa7b)]()[_0x4a18dc(0x5bb)]+_0x48efd3[_0x4a18dc(0xa7b)]()[_0x4a18dc(0x102)]()/0x2)),_0x483cd0=Math[_0x4a18dc(0xb4b)](..._0x3924de[_0x4a18dc(0x7a1)](_0x494095=>_0x494095[_0x4a18dc(0xa7b)]()[_0x4a18dc(0x83d)]-_0x494095[_0x4a18dc(0xa7b)]()[_0x4a18dc(0xa23)]())),_0x20e813=Math[_0x4a18dc(0x61a)](..._0x3924de['map'](_0x2af494=>_0x2af494['battler']()[_0x4a18dc(0x83d)])),_0x253e38=_0x3924de[_0x4a18dc(0x229)](_0x492853=>_0x492853[_0x4a18dc(0x7f0)]())['length'],_0x396938=_0x3924de['filter'](_0x27111a=>_0x27111a['isEnemy']())[_0x4a18dc(0x1c9)];let _0x13f096=0x0,_0x3b24b5=0x0;if(_0x21c69c[_0x4a18dc(0x95f)](/front/i))_0x13f096=_0x253e38>=_0x396938?_0x1f4e6b:_0x21154d;else{if(_0x21c69c['match'](/middle/i))_0x13f096=(_0x1f4e6b+_0x21154d)/0x2,melee=-0x1;else _0x21c69c['match'](/back/i)&&(_0x13f096=_0x253e38>=_0x396938?_0x21154d:_0x1f4e6b);}if(_0x21c69c[_0x4a18dc(0x95f)](/head/i))_0x3b24b5=_0x483cd0;else{if(_0x21c69c['match'](/center/i))_0x3b24b5=(_0x483cd0+_0x20e813)/0x2;else _0x21c69c[_0x4a18dc(0x95f)](/base/i)&&(_0x3b24b5=_0x20e813);}_0x13f096+=(Graphics[_0x4a18dc(0x7ea)]-Graphics[_0x4a18dc(0x6ae)])/0x2,_0x3b24b5+=(Graphics['height']-Graphics[_0x4a18dc(0x56c)])/0x2,_0x13f096+=_0x89ee10,_0x3b24b5+=_0x5de7f1,_0x2e8e06[_0x4a18dc(0xb80)](_0x13f096,_0x3b24b5,_0x173220,_0x3c3210,_0x1f7a29);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x9a6),_0x2fed48=>{const _0x38b1ab=_0x45d586;if(!Imported[_0x38b1ab(0x79a)])return;const _0x370444=SceneManager['_scene']['_spriteset'];if(!_0x370444)return;if(VisuMZ[_0x38b1ab(0x1af)][_0x38b1ab(0x23e)]<=1.04){alert(_0x38b1ab(0x4e4)),SceneManager[_0x38b1ab(0x16f)]();return;}VisuMZ[_0x38b1ab(0x536)](_0x2fed48,_0x2fed48);const _0x3d38f3=$gameTemp[_0x38b1ab(0x421)](),_0x31a9e9=Math['max'](0.01,_0x2fed48[_0x38b1ab(0x150)]);$gameTemp[_0x38b1ab(0x6c0)](_0x31a9e9,_0x3d38f3);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0xb89),_0x257cae=>{const _0x3739f8=_0x45d586;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x50f699=SceneManager[_0x3739f8(0x4f4)]['_spriteset'];if(!_0x50f699)return;if(VisuMZ['ActSeqImpact'][_0x3739f8(0x23e)]<=1.04){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x3739f8(0x16f)]();return;}VisuMZ[_0x3739f8(0x536)](_0x257cae,_0x257cae);const _0x2dca6c=$gameTemp['getLastPluginCommandInterpreter'](),_0x5cc8c1=_0x257cae['ms']||0x1;VisuMZ[_0x3739f8(0x1af)][_0x3739f8(0x8b6)](_0x5cc8c1,_0x2dca6c);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x2b6),_0x1692a1=>{const _0x6a7c44=_0x45d586;if(!Imported[_0x6a7c44(0x79a)])return;const _0xe2112e=SceneManager[_0x6a7c44(0x4f4)][_0x6a7c44(0x992)];if(!_0xe2112e)return;VisuMZ[_0x6a7c44(0x536)](_0x1692a1,_0x1692a1);const _0x1d150f=_0x1692a1['X']||0x0,_0x2f8f9a=_0x1692a1['Y']||0x0,_0x55fbc0=_0x1692a1['Strength']||0x0,_0x2f4d8d=_0x1692a1[_0x6a7c44(0xb41)]||0x0,_0x1343a9=_0x1692a1[_0x6a7c44(0x7de)]||0x1,_0x16859c=_0x1692a1[_0x6a7c44(0xb1d)]||_0x6a7c44(0xa8e);_0xe2112e[_0x6a7c44(0x56f)](_0x55fbc0,_0x1d150f,_0x2f8f9a,_0x2f4d8d,_0x1343a9,_0x16859c);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Impact_ZoomBlurTargetCenter',_0x22a68e=>{const _0x1ef14b=_0x45d586;if(!Imported[_0x1ef14b(0x79a)])return;const _0xf4b436=SceneManager[_0x1ef14b(0x4f4)][_0x1ef14b(0x992)];if(!_0xf4b436)return;VisuMZ[_0x1ef14b(0x536)](_0x22a68e,_0x22a68e);const _0x2173a9=VisuMZ[_0x1ef14b(0x552)](_0x22a68e[_0x1ef14b(0xba0)]),_0x41d62a=_0x22a68e[_0x1ef14b(0x4c9)],_0x4076ec=_0x22a68e[_0x1ef14b(0x34f)]||0x0,_0x51ae43=_0x22a68e[_0x1ef14b(0x261)]||0x0,_0x44b2fe=_0x22a68e[_0x1ef14b(0x806)]||0x0,_0xeef951=_0x22a68e[_0x1ef14b(0xb41)]||0x0,_0x46ea8f=_0x22a68e[_0x1ef14b(0x7de)]||0x1,_0x5ecbe2=_0x22a68e['EasingType']||'Linear',_0x51e1c8=Math[_0x1ef14b(0xb4b)](..._0x2173a9[_0x1ef14b(0x7a1)](_0x452d8a=>_0x452d8a[_0x1ef14b(0xa7b)]()[_0x1ef14b(0x5bb)]-_0x452d8a['battler']()['mainSpriteWidth']()/0x2)),_0x536004=Math[_0x1ef14b(0x61a)](..._0x2173a9[_0x1ef14b(0x7a1)](_0xbb4404=>_0xbb4404[_0x1ef14b(0xa7b)]()['_baseX']+_0xbb4404[_0x1ef14b(0xa7b)]()[_0x1ef14b(0x102)]()/0x2)),_0x305901=Math[_0x1ef14b(0xb4b)](..._0x2173a9[_0x1ef14b(0x7a1)](_0x918e63=>_0x918e63['battler']()[_0x1ef14b(0x83d)]-_0x918e63['battler']()[_0x1ef14b(0xa23)]())),_0x48f5c5=Math[_0x1ef14b(0x61a)](..._0x2173a9[_0x1ef14b(0x7a1)](_0x3bc0ed=>_0x3bc0ed[_0x1ef14b(0xa7b)]()[_0x1ef14b(0x83d)])),_0x2ce4ac=_0x2173a9[_0x1ef14b(0x229)](_0x272c01=>_0x272c01[_0x1ef14b(0x7f0)]())[_0x1ef14b(0x1c9)],_0x59991b=_0x2173a9['filter'](_0x4c6e90=>_0x4c6e90['isEnemy']())[_0x1ef14b(0x1c9)];let _0x3f0de4=0x0,_0xf58e82=0x0;if(_0x41d62a[_0x1ef14b(0x95f)](/front/i))_0x3f0de4=_0x2ce4ac>=_0x59991b?_0x51e1c8:_0x536004;else{if(_0x41d62a[_0x1ef14b(0x95f)](/middle/i))_0x3f0de4=(_0x51e1c8+_0x536004)/0x2,melee=-0x1;else _0x41d62a[_0x1ef14b(0x95f)](/back/i)&&(_0x3f0de4=_0x2ce4ac>=_0x59991b?_0x536004:_0x51e1c8);}if(_0x41d62a[_0x1ef14b(0x95f)](/head/i))_0xf58e82=_0x305901;else{if(_0x41d62a['match'](/center/i))_0xf58e82=(_0x305901+_0x48f5c5)/0x2;else _0x41d62a[_0x1ef14b(0x95f)](/base/i)&&(_0xf58e82=_0x48f5c5);}_0x3f0de4+=(Graphics[_0x1ef14b(0x7ea)]-Graphics['boxWidth'])/0x2,_0xf58e82+=(Graphics['height']-Graphics[_0x1ef14b(0x56c)])/0x2,_0x3f0de4+=_0x4076ec,_0xf58e82+=_0x51ae43,_0xf4b436['setupZoomBlurImpactFilter'](_0x44b2fe,_0x3f0de4,_0xf58e82,_0xeef951,_0x46ea8f,_0x5ecbe2);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x346),_0x473aee=>{const _0x17882a=_0x45d586;if(!Imported[_0x17882a(0x79a)])return;const _0x5a911f=SceneManager[_0x17882a(0x4f4)][_0x17882a(0x992)];if(!_0x5a911f)return;if(VisuMZ[_0x17882a(0x1af)][_0x17882a(0x23e)]<=1.05){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x17882a(0x16f)]();return;}VisuMZ[_0x17882a(0x536)](_0x473aee,_0x473aee);const _0x152af1=VisuMZ['CreateActionSequenceTargets'](_0x473aee[_0x17882a(0xba0)]),_0x367380={'filename':_0x473aee['Filename'],'horzCells':_0x473aee[_0x17882a(0xa9f)]||0x1,'vertCells':_0x473aee[_0x17882a(0x6e7)]||0x1,'frameDelay':_0x473aee['frameDelay']||0x1,'smooth':_0x473aee[_0x17882a(0xbf0)]||![],'anchorX':_0x473aee[_0x17882a(0xa82)]||0x0,'anchorY':_0x473aee[_0x17882a(0x603)]||0x0,'offsetX':_0x473aee[_0x17882a(0x62b)]||0x0,'offsetY':_0x473aee[_0x17882a(0x110)]||0x0};for(const _0x42aefd of _0x152af1){if(!_0x42aefd)continue;if(!_0x42aefd['battler']())continue;_0x42aefd['battler']()[_0x17882a(0x3fc)](_0x367380);}const _0x35cf6b=$gameTemp[_0x17882a(0x421)]();_0x35cf6b&&_0x35cf6b[_0x17882a(0x9c6)](_0x17882a(0x7d6));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0xb87),_0x3fe514=>{const _0x34b423=_0x45d586;if(!Imported[_0x34b423(0x79a)])return;const _0x1467f7=SceneManager['_scene'][_0x34b423(0x992)];if(!_0x1467f7)return;if(VisuMZ['ActSeqImpact'][_0x34b423(0x23e)]<=1.05){alert(_0x34b423(0x4e4)),SceneManager['exit']();return;}VisuMZ[_0x34b423(0x536)](_0x3fe514,_0x3fe514);const _0x3e0f7a=VisuMZ[_0x34b423(0x552)](_0x3fe514[_0x34b423(0xba0)]);for(const _0x59640f of _0x3e0f7a){if(!_0x59640f)continue;if(!_0x59640f[_0x34b423(0xa7b)]())continue;_0x59640f['battler']()[_0x34b423(0x616)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xff),_0x10102a=>{const _0x3a0fca=_0x45d586;if(!Imported[_0x3a0fca(0x79a)])return;const _0x3fdf92=SceneManager[_0x3a0fca(0x4f4)][_0x3a0fca(0x992)];if(!_0x3fdf92)return;if(VisuMZ[_0x3a0fca(0x1af)]['version']<=1.05){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x3a0fca(0x16f)]();return;}VisuMZ[_0x3a0fca(0x536)](_0x10102a,_0x10102a);const _0x1d121e=VisuMZ[_0x3a0fca(0x552)](_0x10102a[_0x3a0fca(0xba0)]),_0x45bd41=_0x10102a[_0x3a0fca(0x232)];for(const _0x33aedd of _0x1d121e){if(!_0x33aedd)continue;if(!_0x33aedd[_0x3a0fca(0xa7b)]())continue;_0x33aedd[_0x3a0fca(0xa7b)]()[_0x3a0fca(0xb27)](_0x45bd41);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xac5),_0x20b3c1=>{const _0xb27a84=_0x45d586;if(!SceneManager[_0xb27a84(0x81a)]())return;const _0x406d45=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x406d45)return;_0x406d45['setWaitMode'](_0xb27a84(0x585));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x1f4),_0x3cd72d=>{const _0x5361fd=_0x45d586;if(!SceneManager[_0x5361fd(0x81a)]())return;VisuMZ[_0x5361fd(0x536)](_0x3cd72d,_0x3cd72d);const _0x3808ff=$gameTemp['getLastPluginCommandInterpreter'](),_0x103cae=BattleManager[_0x5361fd(0x9e9)],_0x2b6892=BattleManager[_0x5361fd(0x1ce)],_0x567808=BattleManager['_logWindow'];if(!_0x3808ff||!_0x103cae||!_0x2b6892)return;if(!_0x103cae['item']())return;const _0x310818=VisuMZ[_0x5361fd(0x552)](_0x3cd72d[_0x5361fd(0xba0)]);for(const _0x987f03 of _0x310818){if(!_0x987f03)continue;_0x567808['push'](_0x5361fd(0x2b7),_0x2b6892,_0x987f03);}_0x3808ff[_0x5361fd(0x9c6)](_0x5361fd(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_ActiveChainInputDisable',_0x5b7542=>{const _0x53db6a=_0x45d586;if(!SceneManager[_0x53db6a(0x81a)]())return;if(!Imported[_0x53db6a(0x933)])return;$gameTemp[_0x53db6a(0xaa2)]=!![];}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x311),_0x210b3f=>{const _0x2c6675=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2c6675(0x536)](_0x210b3f,_0x210b3f);const _0x120a0b=[_0x2c6675(0x791),'MAXMP',_0x2c6675(0x7cc),_0x2c6675(0x96f),'MAT',_0x2c6675(0x5e5),_0x2c6675(0x152),'LUK'],_0x392830=_0x210b3f[_0x2c6675(0x33b)],_0x39219d=_0x210b3f['Debuffs'],_0x29b103=_0x210b3f[_0x2c6675(0x91f)],_0x1a1c27=VisuMZ[_0x2c6675(0x552)](_0x210b3f['Targets']);for(const _0x5cc812 of _0x1a1c27){if(!_0x5cc812)continue;for(const _0x20abae of _0x392830){const _0x2b417c=_0x120a0b['indexOf'](_0x20abae['toUpperCase']()[_0x2c6675(0x379)]());_0x2b417c>=0x0&&_0x2b417c<=0x7&&_0x5cc812[_0x2c6675(0x938)](_0x2b417c,_0x29b103);}for(const _0x177ef8 of _0x39219d){const _0x35f76b=_0x120a0b[_0x2c6675(0xa63)](_0x177ef8[_0x2c6675(0x689)]()[_0x2c6675(0x379)]());_0x35f76b>=0x0&&_0x35f76b<=0x7&&_0x5cc812[_0x2c6675(0x423)](_0x35f76b,_0x29b103);}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x9db),_0x570d20=>{const _0x3a8df2=_0x45d586;if(!SceneManager[_0x3a8df2(0x81a)]())return;VisuMZ[_0x3a8df2(0x536)](_0x570d20,_0x570d20);const _0x2bc9f8=_0x570d20[_0x3a8df2(0x489)],_0x2f50e9=VisuMZ[_0x3a8df2(0x552)](_0x570d20['Targets']);for(const _0x45fee2 of _0x2f50e9){if(!_0x45fee2)continue;for(const _0x23828d of _0x2bc9f8){_0x45fee2[_0x3a8df2(0x66b)](_0x23828d);}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x2d2),_0xe0a2d6=>{const _0x28f96f=_0x45d586;if(!SceneManager[_0x28f96f(0x81a)]())return;VisuMZ['ConvertParams'](_0xe0a2d6,_0xe0a2d6);const _0x3789c0=BattleManager[_0x28f96f(0x9e9)],_0x38e71b={'arPenRate':_0xe0a2d6[_0x28f96f(0xa3e)],'arPenFlat':_0xe0a2d6['ArPenFlat'],'arRedRate':_0xe0a2d6[_0x28f96f(0xbf3)],'arRedFlat':_0xe0a2d6[_0x28f96f(0x3ee)]};_0x3789c0['_armorPenetration']=_0x38e71b;}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa33),_0x47ccb=>{const _0x410ddf=_0x45d586;if(!SceneManager[_0x410ddf(0x81a)]())return;if(!Imported[_0x410ddf(0x35c)])return;VisuMZ[_0x410ddf(0x536)](_0x47ccb,_0x47ccb);const _0x2cb0cf=VisuMZ['CreateActionSequenceTargets'](_0x47ccb[_0x410ddf(0xba0)]),_0x5138cb=_0x47ccb[_0x410ddf(0x4a3)]||0x1;for(const _0x4bbe85 of _0x2cb0cf){if(!_0x4bbe85)continue;if(!_0x4bbe85[_0x410ddf(0x690)]())continue;_0x4bbe85['revealNewWeaknesses'](_0x5138cb);}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_AtbGauge',_0x27550d=>{const _0x2bd0d0=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemATB'])return;if(!BattleManager[_0x2bd0d0(0x946)]())return;VisuMZ[_0x2bd0d0(0x536)](_0x27550d,_0x27550d);const _0x206262=VisuMZ[_0x2bd0d0(0x552)](_0x27550d[_0x2bd0d0(0xba0)]),_0x149315=_0x27550d[_0x2bd0d0(0x49a)],_0x17964e=_0x27550d[_0x2bd0d0(0x49a)],_0x8f3aab=_0x27550d[_0x2bd0d0(0x8e8)];for(const _0x40fcee of _0x206262){if(!_0x40fcee)continue;if(_0x40fcee[_0x2bd0d0(0x7cf)]())_0x40fcee[_0x2bd0d0(0x1b4)](_0x149315);else{if(_0x40fcee['isAtbCastingState']()){_0x40fcee[_0x2bd0d0(0x45b)](_0x17964e);if(_0x8f3aab)_0x40fcee[_0x2bd0d0(0xba5)]();}}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa0e),_0x2e6597=>{const _0x3d41e9=_0x45d586;if(!SceneManager[_0x3d41e9(0x81a)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;VisuMZ[_0x3d41e9(0x536)](_0x2e6597,_0x2e6597);const _0x3c12fa=VisuMZ[_0x3d41e9(0x552)](_0x2e6597[_0x3d41e9(0xba0)]),_0x221281=_0x2e6597['BoostPoints'];for(const _0x19ed71 of _0x3c12fa){if(!_0x19ed71)continue;_0x19ed71[_0x3d41e9(0x924)](_0x221281);}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Mechanics_BoostPointsStoreData',_0x50e36a=>{const _0x2fdaac=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2fdaac(0x469)])return;if(!BattleManager['_subject'])return;VisuMZ[_0x2fdaac(0x536)](_0x50e36a,_0x50e36a);const _0x53987e=_0x50e36a[_0x2fdaac(0x891)];$gameVariables[_0x2fdaac(0x177)](_0x53987e,BattleManager['_subject'][_0x2fdaac(0xbaa)]());}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_BreakShieldChange',_0x5b41a4=>{const _0x3fd9c0=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_4_BreakShields'])return;VisuMZ[_0x3fd9c0(0x536)](_0x5b41a4,_0x5b41a4);const _0x1513db=VisuMZ['CreateActionSequenceTargets'](_0x5b41a4[_0x3fd9c0(0xba0)]),_0x3a912d=_0x5b41a4[_0x3fd9c0(0x9f5)];for(const _0xcaa526 of _0x1513db){if(!_0xcaa526)continue;if(_0xcaa526['isBreakStunned']())continue;if(!_0xcaa526[_0x3fd9c0(0xa4c)]())continue;_0xcaa526['alterBreakShield'](_0x3a912d);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_BreakShieldReset',_0x38380f=>{const _0x5068da=_0x45d586;if(!SceneManager[_0x5068da(0x81a)]())return;if(!Imported[_0x5068da(0x315)])return;VisuMZ[_0x5068da(0x536)](_0x38380f,_0x38380f);const _0x22b2ec=VisuMZ[_0x5068da(0x552)](_0x38380f[_0x5068da(0xba0)]);for(const _0x28411e of _0x22b2ec){if(!_0x28411e)continue;if(_0x28411e[_0x5068da(0xabe)]())continue;if(!_0x28411e[_0x5068da(0xa4c)]())continue;_0x28411e['resetBreakShield']();}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x26e),_0x4662bb=>{const _0x4dc5bd=_0x45d586;if(!SceneManager[_0x4dc5bd(0x81a)]())return;if(!Imported[_0x4dc5bd(0x7c2)])return;if(!BattleManager[_0x4dc5bd(0x8b0)]())return;VisuMZ[_0x4dc5bd(0x536)](_0x4662bb,_0x4662bb);const _0x3d3634=VisuMZ[_0x4dc5bd(0x552)](_0x4662bb['Targets']),_0x33c32b=_0x4662bb[_0x4dc5bd(0x446)];for(const _0x25bc3a of _0x3d3634){if(!_0x25bc3a)continue;_0x25bc3a['gainBravePoints'](_0x33c32b);}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x39a),_0x24e594=>{const _0x4da5f9=_0x45d586;if(!SceneManager[_0x4da5f9(0x81a)]())return;VisuMZ['ConvertParams'](_0x24e594,_0x24e594);const _0x44d1cf=$gameTemp[_0x4da5f9(0x421)](),_0x16307c=BattleManager[_0x4da5f9(0x9e9)],_0x40fd8c=BattleManager['_subject'];if(!_0x44d1cf||!_0x16307c||!_0x40fd8c)return;if(!_0x16307c['item']())return;const _0x24ec57=VisuMZ[_0x4da5f9(0x552)](_0x24e594[_0x4da5f9(0xba0)]);for(const _0x719dcf of _0x24ec57){if(!_0x719dcf)continue;_0x24e594[_0x4da5f9(0x1f8)]&&(_0x719dcf['removeImmortal'](),_0x719dcf[_0x4da5f9(0x66b)](_0x719dcf[_0x4da5f9(0x19d)]())),_0x719dcf[_0x4da5f9(0x31e)]()&&_0x719dcf['performCollapse']();}_0x44d1cf[_0x4da5f9(0x9c6)]('battleEffect');}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x5aa),_0x174c76=>{const _0x4365ce=_0x45d586;if(!SceneManager[_0x4365ce(0x81a)]())return;if(!Imported['VisuMZ_2_BattleSystemCTB'])return;if(!BattleManager[_0x4365ce(0x969)]())return;VisuMZ[_0x4365ce(0x536)](_0x174c76,_0x174c76);const _0x37ce85=VisuMZ[_0x4365ce(0x552)](_0x174c76[_0x4365ce(0xba0)]),_0x484b54=_0x174c76['ChangeOrderBy'];for(const _0x495f7f of _0x37ce85){if(!_0x495f7f)continue;_0x495f7f[_0x4365ce(0x8cb)](_0x484b54);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x1ee),_0x57c217=>{const _0x4e6a39=_0x45d586;if(!SceneManager[_0x4e6a39(0x81a)]())return;if(!Imported[_0x4e6a39(0x92b)])return;if(!BattleManager[_0x4e6a39(0x969)]())return;VisuMZ[_0x4e6a39(0x536)](_0x57c217,_0x57c217);const _0x35fa5a=VisuMZ['CreateActionSequenceTargets'](_0x57c217[_0x4e6a39(0xba0)]),_0x5b9511=_0x57c217[_0x4e6a39(0x49a)],_0x5eda90=_0x57c217['ChargeRate'];for(const _0x480ec7 of _0x35fa5a){if(!_0x480ec7)continue;if(_0x480ec7[_0x4e6a39(0x452)]===_0x4e6a39(0xa42))_0x480ec7[_0x4e6a39(0x685)](_0x5b9511);else _0x480ec7['_tpbState']===_0x4e6a39(0xfc)&&_0x480ec7[_0x4e6a39(0x8f8)](_0x5eda90);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xb9d),_0xa08f39=>{const _0x1e50ae=_0x45d586;if(!SceneManager[_0x1e50ae(0x81a)]())return;VisuMZ['ConvertParams'](_0xa08f39,_0xa08f39);const _0x2e9bf8=BattleManager[_0x1e50ae(0x9e9)];if(!_0x2e9bf8)return;let _0x587ebe=_0xa08f39[_0x1e50ae(0x6e9)];_0x2e9bf8[_0x1e50ae(0x94f)](_0x587ebe);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_DamagePopup',_0x187fbc=>{const _0x5a16ae=_0x45d586;if(!SceneManager[_0x5a16ae(0x81a)]())return;VisuMZ['ConvertParams'](_0x187fbc,_0x187fbc);const _0x8d849f=VisuMZ[_0x5a16ae(0x552)](_0x187fbc[_0x5a16ae(0xba0)]);for(const _0xda79db of _0x8d849f){if(!_0xda79db)continue;if(_0xda79db['shouldPopupDamage']())_0xda79db[_0x5a16ae(0x466)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x9a4),_0x469244=>{const _0x2dda5d=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2dda5d(0x536)](_0x469244,_0x469244);const _0x3d1d06=$gameTemp[_0x2dda5d(0x421)](),_0x577551=BattleManager[_0x2dda5d(0x1ce)],_0x51654f=_0x469244[_0x2dda5d(0x890)];if(!_0x3d1d06)return;if(!_0x577551)return;_0x577551&&_0x577551[_0x2dda5d(0x1e3)]()&&_0x51654f[_0x2dda5d(0x689)]()[_0x2dda5d(0x379)]()!=='UNTITLED'&&_0x3d1d06[_0x2dda5d(0x493)]([_0x51654f]);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x329),_0x2fb561=>{const _0x5acf94=_0x45d586;if(!SceneManager[_0x5acf94(0x81a)]())return;VisuMZ[_0x5acf94(0x536)](_0x2fb561,_0x2fb561);const _0x1aa055=$gameTemp[_0x5acf94(0x421)](),_0x21a165=BattleManager['_logWindow'];if(!_0x1aa055)return;const _0x4a7e34=VisuMZ[_0x5acf94(0x552)](_0x2fb561[_0x5acf94(0x94a)]),_0xf684f0=VisuMZ[_0x5acf94(0x552)](_0x2fb561[_0x5acf94(0xba0)]);for(const _0x1b72b3 of _0x4a7e34){for(const _0x2f3afc of _0xf684f0){if(!_0x2f3afc)continue;const _0x31394c=$dataSkills[_0x1b72b3[_0x5acf94(0x771)]()];_0x21a165[_0x5acf94(0x119)](_0x5acf94(0xa1d),_0x1b72b3,_0x2f3afc,_0x31394c);}}_0x1aa055[_0x5acf94(0x9c6)](_0x5acf94(0x9d8));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_EmulateGuardEffect',_0x548aab=>{const _0x199cad=_0x45d586;if(!SceneManager[_0x199cad(0x81a)]())return;VisuMZ[_0x199cad(0x536)](_0x548aab,_0x548aab);const _0x3882e1=$gameTemp['getLastPluginCommandInterpreter'](),_0x42e7bd=BattleManager['_logWindow'];if(!_0x3882e1)return;const _0x4e9d36=VisuMZ[_0x199cad(0x552)](_0x548aab['Users']),_0x504214=VisuMZ[_0x199cad(0x552)](_0x548aab[_0x199cad(0xba0)]);for(const _0x1e880e of _0x4e9d36){for(const _0x41e2b8 of _0x504214){if(!_0x41e2b8)continue;const _0x218bae=$dataSkills[_0x1e880e[_0x199cad(0x1cc)]()];_0x42e7bd[_0x199cad(0x119)]('emulateActionEffect',_0x1e880e,_0x41e2b8,_0x218bae);}}_0x3882e1['setWaitMode'](_0x199cad(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x185),_0xedc418=>{const _0x552a69=_0x45d586;if(!SceneManager[_0x552a69(0x81a)]())return;VisuMZ[_0x552a69(0x536)](_0xedc418,_0xedc418);const _0x5c566b=$gameTemp[_0x552a69(0x421)](),_0x3ed109=BattleManager[_0x552a69(0x936)],_0x2801b3=Number(_0xedc418[_0x552a69(0x743)]||0x1),_0x4c26d4=$dataItems[_0x2801b3];if(!_0x5c566b)return;if(!_0x4c26d4)return;const _0x4e1927=VisuMZ[_0x552a69(0x552)](_0xedc418['Users']),_0x4a65bc=VisuMZ['CreateActionSequenceTargets'](_0xedc418['Targets']);for(const _0x5a6cd5 of _0x4e1927){for(const _0x488667 of _0x4a65bc){if(!_0x488667)continue;_0x3ed109[_0x552a69(0x119)](_0x552a69(0xa1d),_0x5a6cd5,_0x488667,_0x4c26d4);}}_0x5c566b[_0x552a69(0x9c6)](_0x552a69(0x9d8));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5d7),_0x594fed=>{const _0x51167e=_0x45d586;if(!SceneManager[_0x51167e(0x81a)]())return;VisuMZ[_0x51167e(0x536)](_0x594fed,_0x594fed);let _0x465b29=Number(_0x594fed[_0x51167e(0xfe)]||0x0);if(_0x465b29<=0x0){const _0x57deaf=BattleManager[_0x51167e(0x9e9)];if(_0x57deaf&&_0x57deaf['isSkill']())_0x465b29=_0x57deaf['item']()['id'];else return;}const _0x430aba=$dataSkills[_0x465b29];if(!_0x430aba)return;const _0x176dc0=VisuMZ[_0x51167e(0x552)](_0x594fed[_0x51167e(0x94a)]);for(const _0x32cd73 of _0x176dc0){_0x32cd73[_0x51167e(0x785)](_0x430aba);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xab1),_0x408664=>{const _0x35f7fc=_0x45d586;if(!SceneManager[_0x35f7fc(0x81a)]())return;VisuMZ[_0x35f7fc(0x536)](_0x408664,_0x408664);const _0x5c8aec=$gameTemp[_0x35f7fc(0x421)](),_0xc46524=BattleManager[_0x35f7fc(0x936)],_0x593324=Number(_0x408664[_0x35f7fc(0xfe)]||0x1),_0x5f521c=$dataSkills[_0x593324];if(!_0x5c8aec)return;if(!_0x5f521c)return;const _0x19286f=VisuMZ[_0x35f7fc(0x552)](_0x408664[_0x35f7fc(0x94a)]),_0xafdfd0=VisuMZ[_0x35f7fc(0x552)](_0x408664['Targets']);for(const _0x22ad7a of _0x19286f){for(const _0x2e8c0c of _0xafdfd0){if(!_0x2e8c0c)continue;_0xc46524[_0x35f7fc(0x119)](_0x35f7fc(0xa1d),_0x22ad7a,_0x2e8c0c,_0x5f521c);}}_0x5c8aec[_0x35f7fc(0x9c6)](_0x35f7fc(0x9d8));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x154),_0x5a6502=>{const _0x39c003=_0x45d586;if(!SceneManager[_0x39c003(0x81a)]())return;VisuMZ[_0x39c003(0x536)](_0x5a6502,_0x5a6502);const _0x1d3206=VisuMZ[_0x39c003(0x552)](_0x5a6502[_0x39c003(0xba0)]);for(const _0x3cf5bf of _0x1d3206){if(!_0x3cf5bf)continue;if(!_0x3cf5bf[_0x39c003(0x690)]())continue;_0x3cf5bf[_0x39c003(0x942)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5f2),_0x1626a3=>{const _0x5a476c=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x5a476c(0x6f7)])return;if(!BattleManager[_0x5a476c(0xbd8)]())return;VisuMZ['ConvertParams'](_0x1626a3,_0x1626a3);const _0x434366=_0x1626a3[_0x5a476c(0x4f6)];BattleManager[_0x5a476c(0x1ce)]&&BattleManager[_0x5a476c(0x1ce)][_0x5a476c(0x904)]()['gainCurrentActionsETB'](_0x434366);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x4f2),_0x134cff=>{const _0x24c199=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x24c199(0x4bf)])return;if(!BattleManager['isFTB']())return;VisuMZ[_0x24c199(0x536)](_0x134cff,_0x134cff);const _0x1344f5=_0x134cff['ActionCount'];BattleManager['_subject']&&BattleManager['_subject']['friendsUnit']()['gainCurrentActionsFTB'](_0x1344f5);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x7a0),_0x4c48d3=>{const _0x26ae7b=_0x45d586;if(!SceneManager[_0x26ae7b(0x81a)]())return;VisuMZ[_0x26ae7b(0x536)](_0x4c48d3,_0x4c48d3);const _0xc1c4c7=VisuMZ[_0x26ae7b(0x552)](_0x4c48d3['Targets']),_0x8d2ae0=_0x4c48d3[_0x26ae7b(0x411)],_0x33f146=_0x4c48d3[_0x26ae7b(0x325)],_0x597308=_0x4c48d3[_0x26ae7b(0x59e)],_0x1a4f1b=_0x4c48d3[_0x26ae7b(0x827)],_0x4fba74=_0x4c48d3['TP_Rate'],_0x5d49e5=_0x4c48d3[_0x26ae7b(0x542)],_0x307852=_0x4c48d3[_0x26ae7b(0xb6f)];for(const _0x20cfe3 of _0xc1c4c7){if(!_0x20cfe3)continue;const _0x4594e3=_0x20cfe3[_0x26ae7b(0x45d)](),_0x32aa13=Math[_0x26ae7b(0x31d)](_0x8d2ae0*_0x20cfe3[_0x26ae7b(0x447)]+_0x33f146),_0x407255=Math[_0x26ae7b(0x31d)](_0x597308*_0x20cfe3[_0x26ae7b(0x13c)]+_0x1a4f1b),_0x282a93=Math[_0x26ae7b(0x31d)](_0x4fba74*_0x20cfe3[_0x26ae7b(0xf8)]()+_0x5d49e5);if(_0x32aa13!==0x0)_0x20cfe3[_0x26ae7b(0x76e)](_0x32aa13);if(_0x407255!==0x0)_0x20cfe3[_0x26ae7b(0x8ef)](_0x407255);if(_0x282a93!==0x0)_0x20cfe3[_0x26ae7b(0x732)](_0x282a93);if(_0x307852)_0x20cfe3[_0x26ae7b(0x466)]();_0x4594e3&&_0x20cfe3[_0x26ae7b(0x1e3)]()&&_0x20cfe3[_0x26ae7b(0xa50)]();}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Mechanics_Immortal',_0x3208da=>{const _0xb0fce1=_0x45d586;if(!SceneManager[_0xb0fce1(0x81a)]())return;VisuMZ[_0xb0fce1(0x536)](_0x3208da,_0x3208da);const _0x33dcc7=VisuMZ[_0xb0fce1(0x552)](_0x3208da['Targets']);for(const _0x27a979 of _0x33dcc7){if(!_0x27a979)continue;_0x27a979[_0xb0fce1(0x2d7)](_0x3208da[_0xb0fce1(0x418)]);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_Multipliers',_0x4d0c14=>{const _0x34c665=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x34c665(0x536)](_0x4d0c14,_0x4d0c14);const _0x28f493=BattleManager[_0x34c665(0x9e9)],_0x384c0e={'criticalHitRate':_0x4d0c14[_0x34c665(0xb47)],'criticalHitFlat':_0x4d0c14[_0x34c665(0x34d)],'criticalDmgRate':_0x4d0c14['CriticalDmgRate'],'criticalDmgFlat':_0x4d0c14[_0x34c665(0x8bd)],'damageRate':_0x4d0c14[_0x34c665(0x914)],'damageFlat':_0x4d0c14[_0x34c665(0x321)],'hitRate':_0x4d0c14[_0x34c665(0x3ab)],'hitFlat':_0x4d0c14['HitFlat']};_0x28f493[_0x34c665(0x97c)]=_0x384c0e;}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_Mechanics_OnceParallel',_0x1338e1=>{const _0x4862ae=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x4862ae(0x536)](_0x1338e1,_0x1338e1);const _0x1d5e42=_0x1338e1[_0x4862ae(0x39e)];SceneManager[_0x4862ae(0x4f4)]['playOnceParallelInterpreter'](_0x1d5e42);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x870),_0x200b89=>{const _0x3a12cd=_0x45d586;if(!SceneManager[_0x3a12cd(0x81a)]())return;if(!Imported[_0x3a12cd(0x65c)])return;if(!BattleManager['isOTB']())return;VisuMZ['ConvertParams'](_0x200b89,_0x200b89);const _0x3d94df=VisuMZ['CreateActionSequenceTargets'](_0x200b89[_0x3a12cd(0xba0)]);for(const _0x2bf05a of _0x3d94df){if(!_0x2bf05a)continue;let _0x13d08b=_0x200b89[_0x3a12cd(0xbe4)],_0x50fb6e=_0x200b89[_0x3a12cd(0x1a9)],_0x1a6be8=_0x200b89[_0x3a12cd(0x5e7)];BattleManager[_0x3a12cd(0xbc0)]['includes'](_0x2bf05a)?_0x13d08b+=_0x1a6be8:_0x50fb6e+=_0x1a6be8,BattleManager[_0x3a12cd(0x6b9)](_0x2bf05a,-_0x13d08b,![]),BattleManager[_0x3a12cd(0x6b9)](_0x2bf05a,-_0x50fb6e,!![]);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa69),_0x595db6=>{const _0x56988=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x56988(0x7ef)])return;if(!BattleManager[_0x56988(0x9a7)]())return;VisuMZ[_0x56988(0x536)](_0x595db6,_0x595db6);const _0x20e3cd=BattleManager[_0x56988(0x1ce)]['friendsUnit'](),_0x4d1f36=_0x595db6['Override'],_0x3b06a6=_0x595db6[_0x56988(0x269)]||_0x56988(0x13b),_0x5a40fd=_0x595db6[_0x56988(0x30a)]||_0x56988(0x13b),_0x3fc0e2=_0x595db6[_0x56988(0x8a1)]||0x0,_0x20d1df=_0x595db6[_0x56988(0x801)]||0x0;(_0x20e3cd['canAlterActionCostPTB']()||_0x4d1f36)&&(_0x4d1f36&&(_0x20e3cd[_0x56988(0x145)]=_0x20e3cd[_0x56988(0x145)]||{},_0x20e3cd[_0x56988(0x145)][_0x56988(0x73b)]=0x0),_0x20e3cd[_0x56988(0x2c0)](_0x3b06a6,_0x5a40fd,_0x3fc0e2,_0x20d1df));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x338),_0x1fb342=>{const _0x2947b5=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x2947b5(0x7ef)])return;if(!BattleManager[_0x2947b5(0x9a7)]())return;VisuMZ[_0x2947b5(0x536)](_0x1fb342,_0x1fb342);const _0x43a2c5=BattleManager[_0x2947b5(0x1ce)][_0x2947b5(0x904)]();let _0x56e6eb=Math[_0x2947b5(0x61a)](_0x1fb342['ConvertCount'],0x0),_0x90ae21=_0x43a2c5[_0x2947b5(0x3d0)](),_0x220fe9=_0x43a2c5[_0x2947b5(0x922)]();while(_0x56e6eb--){if(_0x90ae21<=0x0&&_0x220fe9<=0x0)break;else _0x90ae21>0x0?(_0x90ae21--,_0x220fe9++):_0x220fe9--;}_0x43a2c5[_0x2947b5(0x86e)](_0x90ae21),_0x43a2c5['setHalfActionsPTB'](_0x220fe9);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x480),_0x1ccbbb=>{const _0x5d84ed=_0x45d586;if(!SceneManager[_0x5d84ed(0x81a)]())return;if(!Imported['VisuMZ_2_BattleSystemPTB'])return;if(!BattleManager[_0x5d84ed(0x9a7)]())return;VisuMZ[_0x5d84ed(0x536)](_0x1ccbbb,_0x1ccbbb);const _0x78fa5f=BattleManager[_0x5d84ed(0x1ce)]['friendsUnit']();let _0x532b27=_0x1ccbbb[_0x5d84ed(0x551)],_0x4fb9b1=_0x1ccbbb[_0x5d84ed(0x5d9)];_0x78fa5f['gainFullActionsPTB'](_0x532b27),_0x78fa5f[_0x5d84ed(0x5ab)](_0x4fb9b1);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xaa8),_0x4aa2d0=>{const _0x828b54=_0x45d586;if(!SceneManager[_0x828b54(0x81a)]())return;VisuMZ[_0x828b54(0x536)](_0x4aa2d0,_0x4aa2d0);const _0x1a3ef3=[_0x828b54(0x791),_0x828b54(0x483),_0x828b54(0x7cc),_0x828b54(0x96f),_0x828b54(0x7b0),_0x828b54(0x5e5),_0x828b54(0x152),_0x828b54(0x3d2)],_0x10269a=_0x4aa2d0['Buffs'],_0x5c7378=_0x4aa2d0[_0x828b54(0x688)],_0x2946b5=VisuMZ[_0x828b54(0x552)](_0x4aa2d0[_0x828b54(0xba0)]);for(const _0x2d89ff of _0x2946b5){if(!_0x2d89ff)continue;for(const _0xbc07fb of _0x10269a){const _0x3ed999=_0x1a3ef3[_0x828b54(0xa63)](_0xbc07fb[_0x828b54(0x689)]()[_0x828b54(0x379)]());_0x3ed999>=0x0&&_0x3ed999<=0x7&&_0x2d89ff[_0x828b54(0xa83)](_0x3ed999)&&_0x2d89ff[_0x828b54(0x45a)](_0x3ed999);}for(const _0x140c78 of _0x5c7378){const _0x20e4af=_0x1a3ef3[_0x828b54(0xa63)](_0x140c78[_0x828b54(0x689)]()['trim']());_0x20e4af>=0x0&&_0x20e4af<=0x7&&_0x2d89ff['isDebuffAffected'](_0x20e4af)&&_0x2d89ff[_0x828b54(0x45a)](_0x20e4af);}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x32b),_0x5f08b8=>{const _0x57d54d=_0x45d586;if(!SceneManager[_0x57d54d(0x81a)]())return;VisuMZ[_0x57d54d(0x536)](_0x5f08b8,_0x5f08b8);const _0x1f1fdc=_0x5f08b8[_0x57d54d(0x489)],_0x45ed60=VisuMZ['CreateActionSequenceTargets'](_0x5f08b8['Targets']);for(const _0x49f804 of _0x45ed60){if(!_0x49f804)continue;for(const _0x45ae60 of _0x1f1fdc){_0x49f804[_0x57d54d(0x238)](_0x45ae60);}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x6cb),_0x543994=>{const _0x23bf01=_0x45d586;if(!SceneManager[_0x23bf01(0x81a)]())return;if(!Imported[_0x23bf01(0x903)])return;VisuMZ[_0x23bf01(0x536)](_0x543994,_0x543994);const _0x3038a4=VisuMZ[_0x23bf01(0x552)](_0x543994[_0x23bf01(0xba0)]),_0x431468=Number(_0x543994[_0x23bf01(0x1d4)]),_0x9100a=Number(_0x543994[_0x23bf01(0x91f)]),_0x2b0da0=_0x543994[_0x23bf01(0x87a)];for(const _0x1a4efe of _0x3038a4){if(!_0x1a4efe)continue;_0x2b0da0&&!_0x1a4efe['isStateAffected'](_0x431468)?(_0x1a4efe['addState'](_0x431468),_0x1a4efe[_0x23bf01(0x253)](_0x431468,_0x9100a)):_0x1a4efe['addStateTurns'](_0x431468,_0x9100a);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x1eb),_0x32ea52=>{const _0x15f900=_0x45d586;if(!SceneManager[_0x15f900(0x81a)]())return;if(!Imported[_0x15f900(0x903)])return;VisuMZ[_0x15f900(0x536)](_0x32ea52,_0x32ea52);const _0x470348=VisuMZ['CreateActionSequenceTargets'](_0x32ea52[_0x15f900(0xba0)]),_0x3fa759=Number(_0x32ea52[_0x15f900(0x1d4)]),_0x31a420=Math[_0x15f900(0x61a)](Number(_0x32ea52['Turns']),0x0),_0x3c3f2c=_0x32ea52[_0x15f900(0x87a)];for(const _0x6d03cf of _0x470348){if(!_0x6d03cf)continue;_0x3c3f2c&&!_0x6d03cf[_0x15f900(0x610)](_0x3fa759)&&_0x6d03cf[_0x15f900(0x66b)](_0x3fa759),_0x6d03cf[_0x15f900(0x253)](_0x3fa759,_0x31a420);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Mechanics_StbExploit',_0xf185af=>{const _0xf86b51=_0x45d586;if(!SceneManager[_0xf86b51(0x81a)]())return;if(!Imported[_0xf86b51(0x988)])return;if(!BattleManager[_0xf86b51(0x524)]())return;VisuMZ[_0xf86b51(0x536)](_0xf185af,_0xf185af);const _0x3f3c92=_0xf185af[_0xf86b51(0x197)],_0x13f064=VisuMZ[_0xf86b51(0x552)](_0xf185af[_0xf86b51(0xba0)]),_0x19a25a=_0xf185af[_0xf86b51(0x51d)],_0x69b77f=_0xf185af[_0xf86b51(0x8f1)],_0x48b2ef=_0xf185af[_0xf86b51(0x865)],_0x496dc2=BattleManager[_0xf86b51(0x9e9)];if(_0x3f3c92)for(const _0x25ea00 of _0x13f064){if(!_0x25ea00)continue;if(_0x25ea00===BattleManager['_subject'])continue;if(_0x19a25a)_0x25ea00[_0xf86b51(0x63b)](![]);_0x25ea00[_0xf86b51(0xdd)](BattleManager['_subject'],_0x496dc2);}if(_0x69b77f&&BattleManager[_0xf86b51(0x1ce)]){if(_0x48b2ef)BattleManager[_0xf86b51(0x1ce)][_0xf86b51(0x63b)](![]);const _0x176eb2=_0x13f064[0x0];BattleManager[_0xf86b51(0x1ce)][_0xf86b51(0xa1a)](_0x176eb2,_0x496dc2);}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x332),_0x51e28b=>{const _0x2b7a73=_0x45d586;if(!SceneManager[_0x2b7a73(0x81a)]())return;if(!Imported[_0x2b7a73(0x988)])return;if(!BattleManager[_0x2b7a73(0x524)]())return;VisuMZ[_0x2b7a73(0x536)](_0x51e28b,_0x51e28b);const _0x2a692a=_0x51e28b[_0x2b7a73(0x9ce)];BattleManager[_0x2b7a73(0x1ce)]&&BattleManager['_subject'][_0x2b7a73(0x9d3)](_0x2a692a);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0xab2),_0x4bd8cf=>{const _0x3ad7c0=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3ad7c0(0x988)])return;if(!BattleManager['isSTB']())return;VisuMZ[_0x3ad7c0(0x536)](_0x4bd8cf,_0x4bd8cf);let _0x5802e0=_0x4bd8cf[_0x3ad7c0(0x9ce)];if(BattleManager[_0x3ad7c0(0x1ce)]){BattleManager['_subject'][_0x3ad7c0(0x55f)]=BattleManager[_0x3ad7c0(0x1ce)][_0x3ad7c0(0x55f)]||[];while(_0x5802e0--){if(BattleManager[_0x3ad7c0(0x1ce)][_0x3ad7c0(0x55f)][_0x3ad7c0(0x1c9)]<=0x0)break;BattleManager[_0x3ad7c0(0x1ce)][_0x3ad7c0(0x55f)]['shift']();}}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x443),_0x19fca1=>{const _0x3681f5=_0x45d586;if(!SceneManager[_0x3681f5(0x81a)]())return;if(!Imported[_0x3681f5(0x6b6)])return;VisuMZ['ConvertParams'](_0x19fca1,_0x19fca1);const _0x46efb4=VisuMZ[_0x3681f5(0x552)](_0x19fca1[_0x3681f5(0xba0)]),_0x12c28b=_0x19fca1[_0x3681f5(0x3e5)];for(const _0x592176 of _0x46efb4){if(!_0x592176)continue;if(!_0x592176[_0x3681f5(0x7f0)]())continue;_0x592176[_0x3681f5(0x69d)](_0x12c28b);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xb75),_0x102000=>{const _0x24f194=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x102000,_0x102000);const _0x228f0f=VisuMZ['CreateActionSequenceTargets'](_0x102000[_0x24f194(0xba0)]),_0xbe48bb=_0x102000[_0x24f194(0x6a0)],_0x3cda96={'textColor':ColorManager['getColor'](_0x102000[_0x24f194(0x56d)]),'flashColor':_0x102000[_0x24f194(0x5ec)],'flashDuration':_0x102000[_0x24f194(0x574)]};for(const _0x52dfe8 of _0x228f0f){if(!_0x52dfe8)continue;_0x52dfe8[_0x24f194(0x3e4)](_0xbe48bb,_0x3cda96);}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x834),_0x42e954=>{const _0x16f67e=_0x45d586;if(!SceneManager[_0x16f67e(0x81a)]())return;VisuMZ['ConvertParams'](_0x42e954,_0x42e954);const _0x2918da=VisuMZ[_0x16f67e(0x552)](_0x42e954[_0x16f67e(0xba0)]);let _0x5323ad=$gameVariables[_0x16f67e(0x72a)](_0x42e954[_0x16f67e(0x495)]);Imported[_0x16f67e(0xbc5)]&&_0x42e954['DigitGrouping']&&(_0x5323ad=VisuMZ['GroupDigits'](_0x5323ad));const _0x57f097=String(_0x5323ad),_0xfa14e5={'textColor':ColorManager[_0x16f67e(0xb9c)](_0x42e954[_0x16f67e(0x56d)]),'flashColor':_0x42e954['FlashColor'],'flashDuration':_0x42e954[_0x16f67e(0x574)]};for(const _0x3003a7 of _0x2918da){if(!_0x3003a7)continue;_0x3003a7[_0x16f67e(0x3e4)](_0x57f097,_0xfa14e5);}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x3ef),_0x3fb852=>{const _0x496855=_0x45d586;if(!SceneManager[_0x496855(0x81a)]())return;const _0x6b4137=$gameTemp[_0x496855(0x421)]();if(!_0x6b4137)return;_0x6b4137[_0x496855(0x9c6)](_0x496855(0x758));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5fb),_0x12f707=>{const _0x212e1d=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x212e1d(0x536)](_0x12f707,_0x12f707);const _0x8aaf66=VisuMZ[_0x212e1d(0x552)](_0x12f707['Targets']);for(const _0x4292c7 of _0x8aaf66){if(!_0x4292c7)continue;_0x4292c7[_0x212e1d(0x288)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xe0),_0x5ec6e7=>{const _0x3a76a7=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x3a76a7(0x536)](_0x5ec6e7,_0x5ec6e7);const _0x19364e=VisuMZ[_0x3a76a7(0x552)](_0x5ec6e7[_0x3a76a7(0xba0)]),_0x332b50=_0x5ec6e7[_0x3a76a7(0x937)][_0x3a76a7(0x2ab)]()['trim']();let _0x13b797=_0x5ec6e7['ShowWeapon'];const _0x5ee404=_0x5ec6e7[_0x3a76a7(0x700)];![_0x3a76a7(0x84c),_0x3a76a7(0x849),_0x3a76a7(0x470),_0x3a76a7(0x46b)]['includes'](_0x332b50)&&(_0x13b797=![]);for(const _0x449583 of _0x19364e){if(!_0x449583)continue;_0x449583['freezeMotion'](_0x332b50,_0x13b797,_0x5ee404);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Motion_MotionType',_0x57eec1=>{const _0x39b792=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x39b792(0x536)](_0x57eec1,_0x57eec1);const _0xe80228=VisuMZ['CreateActionSequenceTargets'](_0x57eec1[_0x39b792(0xba0)]),_0x38ea18=_0x57eec1[_0x39b792(0x937)][_0x39b792(0x2ab)]()[_0x39b792(0x379)](),_0x346f19=_0x57eec1[_0x39b792(0x5b9)];for(const _0x14b842 of _0xe80228){if(!_0x14b842)continue;_0x14b842[_0x39b792(0xb71)]=_0x346f19;if(_0x38ea18['match'](/ATTACK[ ](\d+)/i))_0x14b842['performAttackSlot'](Number(RegExp['$1']));else _0x38ea18===_0x39b792(0x84c)?_0x14b842[_0x39b792(0x3d6)]():_0x14b842['requestMotion'](_0x38ea18);if(!_0x346f19)_0x14b842[_0x39b792(0xbd2)](0x0);else{if(_0x346f19&&['thrust',_0x39b792(0x470),_0x39b792(0xb86)][_0x39b792(0x840)](_0x38ea18)){}}_0x14b842[_0x39b792(0xb71)]=undefined;}}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x38b),_0x44aa7f=>{const _0x482570=_0x45d586;if(!SceneManager[_0x482570(0x81a)]())return;VisuMZ[_0x482570(0x536)](_0x44aa7f,_0x44aa7f);const _0x47b5cb=BattleManager['_action'];if(!_0x47b5cb)return;if(!_0x47b5cb[_0x482570(0xba9)]())return;const _0x58c1b8=VisuMZ[_0x482570(0x552)](_0x44aa7f[_0x482570(0xba0)]);for(const _0x513392 of _0x58c1b8){if(!_0x513392)continue;_0x513392['performAction'](_0x47b5cb);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x644),_0x2937f7=>{const _0x191eea=_0x45d586;if(!SceneManager[_0x191eea(0x81a)]())return;VisuMZ['ConvertParams'](_0x2937f7,_0x2937f7);const _0x51e996=VisuMZ['CreateActionSequenceTargets'](_0x2937f7[_0x191eea(0xba0)]);for(const _0x39d5e0 of _0x51e996){if(!_0x39d5e0)continue;if(!_0x39d5e0[_0x191eea(0xa7b)]())continue;_0x39d5e0[_0x191eea(0xa7b)]()[_0x191eea(0x67b)]();}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x1df),_0x45f3b=>{const _0x3c0223=_0x45d586;if(!SceneManager[_0x3c0223(0x81a)]())return;VisuMZ['ConvertParams'](_0x45f3b,_0x45f3b);const _0x3e0459=$gameTemp[_0x3c0223(0x421)](),_0x586dfd=_0x45f3b[_0x3c0223(0x668)]*Sprite_Battler['_motionSpeed'];_0x3e0459[_0x3c0223(0x643)](_0x586dfd);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x5ea),_0x424c09=>{const _0x6bda4a=_0x45d586;if(!SceneManager[_0x6bda4a(0x81a)]())return;VisuMZ[_0x6bda4a(0x536)](_0x424c09,_0x424c09);const _0xa2f7df=$gameTemp[_0x6bda4a(0x421)](),_0x25a7ce=BattleManager[_0x6bda4a(0x9e9)];if(!_0xa2f7df||!_0x25a7ce)return;if(!_0x25a7ce[_0x6bda4a(0xba9)]())return;const _0x5dc31a=VisuMZ['CreateActionSequenceTargets'](_0x424c09['Targets']);for(const _0x1f03c4 of _0x5dc31a){if(!_0x1f03c4)continue;_0x1f03c4[_0x6bda4a(0x4dd)](_0x25a7ce);}if(_0x424c09[_0x6bda4a(0x9c0)])_0xa2f7df[_0x6bda4a(0x9c6)](_0x6bda4a(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x630),_0x32ec6e=>{const _0x4b7283=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x4b7283(0x536)](_0x32ec6e,_0x32ec6e);const _0x313100=$gameTemp[_0x4b7283(0x421)](),_0x17c7d8=VisuMZ[_0x4b7283(0x552)](_0x32ec6e['Targets']),_0x15ef6a=_0x32ec6e[_0x4b7283(0xa97)],_0x5bd190=_0x32ec6e[_0x4b7283(0xbd6)],_0x409354=_0x32ec6e[_0x4b7283(0x698)],_0x253f77=_0x32ec6e['Duration'],_0x2636e3=_0x32ec6e[_0x4b7283(0xe3)],_0x283d4c=_0x32ec6e[_0x4b7283(0xb1d)],_0x29d05c=_0x32ec6e[_0x4b7283(0x937)],_0x271bfe=_0x32ec6e[_0x4b7283(0x9c0)];if(!_0x313100)return;for(const _0x19bb75 of _0x17c7d8){if(!_0x19bb75)continue;let _0x1337b6=_0x5bd190,_0x4f871f=_0x409354;if(_0x15ef6a[_0x4b7283(0x95f)](/horz/i))_0x1337b6*=_0x19bb75[_0x4b7283(0x7f0)]()?-0x1:0x1;if(_0x15ef6a[_0x4b7283(0x95f)](/vert/i))_0x4f871f*=_0x19bb75[_0x4b7283(0x7f0)]()?-0x1:0x1;_0x19bb75[_0x4b7283(0x639)](_0x1337b6,_0x4f871f,_0x253f77,_0x2636e3,_0x283d4c),_0x19bb75[_0x4b7283(0x135)](_0x29d05c);}if(_0x271bfe)_0x313100['setWaitMode'](_0x4b7283(0x365));}),PluginManager['registerCommand'](pluginData['name'],_0x45d586(0x5a7),_0x52378a=>{const _0x47c8ac=_0x45d586;if(!SceneManager[_0x47c8ac(0x81a)]())return;if(!$gameSystem[_0x47c8ac(0x138)]())return;VisuMZ[_0x47c8ac(0x536)](_0x52378a,_0x52378a);const _0x6957d=$gameTemp[_0x47c8ac(0x421)](),_0x477270=VisuMZ['CreateActionSequenceTargets'](_0x52378a[_0x47c8ac(0xba0)]),_0x1478c9=_0x52378a[_0x47c8ac(0x631)],_0x47b1e2=_0x52378a[_0x47c8ac(0x34f)],_0x14e6ea=_0x52378a[_0x47c8ac(0x261)],_0x26beb1=_0x52378a[_0x47c8ac(0x7de)],_0x383499=_0x52378a[_0x47c8ac(0xe3)],_0x64e376=_0x52378a['EasingType'],_0x317bc7=_0x52378a[_0x47c8ac(0x937)],_0x569515=_0x52378a['WaitForMovement'];if(!_0x6957d)return;for(const _0x3dc7fb of _0x477270){if(!_0x3dc7fb)continue;const _0x1b3c7b=_0x52378a[_0x47c8ac(0x40a)](_0x3dc7fb)||{'x':0x0,'y':0x0};let _0x29bee7=_0x1b3c7b['x'],_0x2b3e17=_0x1b3c7b['y'];if(_0x1478c9[_0x47c8ac(0x95f)](/none/i))_0x29bee7+=_0x47b1e2,_0x2b3e17+=_0x14e6ea;else{if(_0x1478c9[_0x47c8ac(0x95f)](/horz/i)&&_0x1478c9[_0x47c8ac(0x95f)](/vert/i))_0x29bee7+=_0x3dc7fb[_0x47c8ac(0x7f0)]()?-_0x47b1e2:_0x47b1e2,_0x2b3e17+=_0x3dc7fb['isActor']()?-_0x14e6ea:_0x14e6ea;else{if(_0x1478c9[_0x47c8ac(0x95f)](/horz/i))_0x29bee7+=_0x3dc7fb[_0x47c8ac(0x7f0)]()?-_0x47b1e2:_0x47b1e2,_0x2b3e17+=_0x14e6ea;else _0x1478c9[_0x47c8ac(0x95f)](/vert/i)&&(_0x29bee7+=_0x47b1e2,_0x2b3e17+=_0x3dc7fb['isActor']()?-_0x14e6ea:_0x14e6ea);}}_0x3dc7fb['moveBattlerHomeToPoint'](_0x29bee7,_0x2b3e17,_0x26beb1,_0x383499,_0x64e376,-0x1),_0x3dc7fb[_0x47c8ac(0x135)](_0x317bc7);}if(_0x569515)_0x6957d[_0x47c8ac(0x9c6)](_0x47c8ac(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa00),_0x2b7934=>{const _0x2acb7b=_0x45d586;if(!SceneManager[_0x2acb7b(0x81a)]())return;if(!$gameSystem[_0x2acb7b(0x138)]())return;VisuMZ['ConvertParams'](_0x2b7934,_0x2b7934);const _0x59cb2e=$gameTemp[_0x2acb7b(0x421)](),_0x5acc3c=VisuMZ[_0x2acb7b(0x552)](_0x2b7934['Targets']),_0xf94c28=_0x2b7934[_0x2acb7b(0x93f)],_0x3fe862=_0x2b7934[_0x2acb7b(0x631)],_0x1ce97e=_0x2b7934[_0x2acb7b(0x34f)],_0x3ef83b=_0x2b7934[_0x2acb7b(0x261)],_0x3e3ee3=_0x2b7934[_0x2acb7b(0x7de)],_0x31a734=_0x2b7934['FaceDirection'],_0x2ef9d9=_0x2b7934[_0x2acb7b(0xb1d)],_0xd67ecb=_0x2b7934[_0x2acb7b(0x937)],_0x3d8b43=_0x2b7934[_0x2acb7b(0x9c0)];if(!_0x59cb2e)return;for(const _0x15e28b of _0x5acc3c){if(!_0x15e28b)continue;let _0x2cda65=_0x15e28b[_0x2acb7b(0xa7b)]()['_baseX'],_0x4a73fd=_0x15e28b[_0x2acb7b(0xa7b)]()['_baseY'];if(_0xf94c28['match'](/home/i))_0x2cda65=_0x15e28b['battler']()[_0x2acb7b(0x47c)],_0x4a73fd=_0x15e28b[_0x2acb7b(0xa7b)]()[_0x2acb7b(0xac0)];else{if(_0xf94c28[_0x2acb7b(0x95f)](/center/i))_0x2cda65=Graphics[_0x2acb7b(0x6ae)]/0x2,_0x4a73fd=Graphics[_0x2acb7b(0x56c)]/0x2;else _0xf94c28[_0x2acb7b(0x95f)](/point (\d+), (\d+)/i)&&(_0x2cda65=Number(RegExp['$1']),_0x4a73fd=Number(RegExp['$2']));}if(_0x3fe862[_0x2acb7b(0x95f)](/none/i))_0x2cda65+=_0x1ce97e,_0x4a73fd+=_0x3ef83b;else{if(_0x3fe862[_0x2acb7b(0x95f)](/horz/i)&&_0x3fe862[_0x2acb7b(0x95f)](/vert/i))_0x2cda65+=_0x15e28b[_0x2acb7b(0x7f0)]()?-_0x1ce97e:_0x1ce97e,_0x4a73fd+=_0x15e28b[_0x2acb7b(0x7f0)]()?-_0x3ef83b:_0x3ef83b;else{if(_0x3fe862['match'](/horz/i))_0x2cda65+=_0x15e28b['isActor']()?-_0x1ce97e:_0x1ce97e,_0x4a73fd+=_0x3ef83b;else _0x3fe862['match'](/vert/i)&&(_0x2cda65+=_0x1ce97e,_0x4a73fd+=_0x15e28b[_0x2acb7b(0x7f0)]()?-_0x3ef83b:_0x3ef83b);}}_0x15e28b[_0x2acb7b(0xb0f)](_0x2cda65,_0x4a73fd,_0x3e3ee3,_0x31a734,_0x2ef9d9,-0x1),_0x15e28b[_0x2acb7b(0x135)](_0xd67ecb);}if(_0x3d8b43)_0x59cb2e['setWaitMode']('battleMove');}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x71d),_0x20379b=>{const _0x26a637=_0x45d586;if(!SceneManager[_0x26a637(0x81a)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x20379b,_0x20379b);const _0x3fac1a=$gameTemp[_0x26a637(0x421)](),_0x3507e0=VisuMZ['CreateActionSequenceTargets'](_0x20379b[_0x26a637(0x4ca)]),_0x472fdb=VisuMZ[_0x26a637(0x552)](_0x20379b['Targets2']),_0x211a30=_0x20379b[_0x26a637(0x4c9)];let _0x314bf0=_0x20379b[_0x26a637(0x274)];const _0x288708=_0x20379b[_0x26a637(0x631)],_0x251edb=_0x20379b['OffsetX'],_0x134f4b=_0x20379b[_0x26a637(0x261)],_0x481ddd=_0x20379b[_0x26a637(0x7de)],_0xb31c85=_0x20379b[_0x26a637(0xe3)],_0x1e8cb4=_0x20379b['EasingType'],_0x24b92f=_0x20379b[_0x26a637(0x937)],_0x7d2db4=_0x20379b['WaitForMovement'],_0x5f3dc7=Math['min'](..._0x472fdb['map'](_0x32ff8e=>_0x32ff8e[_0x26a637(0xa7b)]()[_0x26a637(0x5bb)]-_0x32ff8e[_0x26a637(0xa7b)]()[_0x26a637(0x102)]()/0x2)),_0x3059e8=Math[_0x26a637(0x61a)](..._0x472fdb['map'](_0x149fb6=>_0x149fb6[_0x26a637(0xa7b)]()[_0x26a637(0x5bb)]+_0x149fb6[_0x26a637(0xa7b)]()[_0x26a637(0x102)]()/0x2)),_0x148901=Math[_0x26a637(0xb4b)](..._0x472fdb[_0x26a637(0x7a1)](_0x1a8f27=>_0x1a8f27[_0x26a637(0xa7b)]()[_0x26a637(0x83d)]-_0x1a8f27[_0x26a637(0xa7b)]()[_0x26a637(0xa23)]())),_0x34ec57=Math[_0x26a637(0x61a)](..._0x472fdb[_0x26a637(0x7a1)](_0x2ad2e3=>_0x2ad2e3[_0x26a637(0xa7b)]()[_0x26a637(0x83d)])),_0x564b55=_0x472fdb[_0x26a637(0x229)](_0x31a4dc=>_0x31a4dc['isActor']())[_0x26a637(0x1c9)],_0x3fd943=_0x472fdb[_0x26a637(0x229)](_0x5c9106=>_0x5c9106[_0x26a637(0x690)]())[_0x26a637(0x1c9)];let _0x12a6d1=0x0,_0x4dc2ac=0x0;if(_0x211a30['match'](/front/i))_0x12a6d1=_0x564b55>=_0x3fd943?_0x5f3dc7:_0x3059e8;else{if(_0x211a30[_0x26a637(0x95f)](/middle/i))_0x12a6d1=(_0x5f3dc7+_0x3059e8)/0x2,_0x314bf0=-0x1;else _0x211a30['match'](/back/i)&&(_0x12a6d1=_0x564b55>=_0x3fd943?_0x3059e8:_0x5f3dc7);}if(_0x211a30[_0x26a637(0x95f)](/head/i))_0x4dc2ac=_0x148901;else{if(_0x211a30['match'](/center/i))_0x4dc2ac=(_0x148901+_0x34ec57)/0x2;else _0x211a30[_0x26a637(0x95f)](/base/i)&&(_0x4dc2ac=_0x34ec57);}if(!_0x3fac1a)return;for(const _0x4b2539 of _0x3507e0){if(!_0x4b2539)continue;let _0x4d3ad3=_0x12a6d1,_0x3fd01b=_0x4dc2ac;if(_0x288708[_0x26a637(0x95f)](/none/i))_0x4d3ad3+=_0x251edb,_0x3fd01b+=_0x134f4b;else{if(_0x288708[_0x26a637(0x95f)](/horz/i)&&_0x288708['match'](/vert/i))_0x4d3ad3+=_0x4b2539[_0x26a637(0x7f0)]()?-_0x251edb:_0x251edb,_0x3fd01b+=_0x4b2539[_0x26a637(0x7f0)]()?-_0x134f4b:_0x134f4b;else{if(_0x288708[_0x26a637(0x95f)](/horz/i))_0x4d3ad3+=_0x4b2539[_0x26a637(0x7f0)]()?-_0x251edb:_0x251edb,_0x3fd01b+=_0x134f4b;else _0x288708[_0x26a637(0x95f)](/vert/i)&&(_0x4d3ad3+=_0x251edb,_0x3fd01b+=_0x4b2539[_0x26a637(0x7f0)]()?-_0x134f4b:_0x134f4b);}}_0x4b2539['moveBattlerHomeToPoint'](_0x4d3ad3,_0x3fd01b,_0x481ddd,_0xb31c85,_0x1e8cb4,_0x314bf0),_0x4b2539[_0x26a637(0x135)](_0x24b92f);}if(_0x7d2db4)_0x3fac1a[_0x26a637(0x9c6)](_0x26a637(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xaa0),_0x59907c=>{const _0x24c273=_0x45d586;if(!SceneManager[_0x24c273(0x81a)]())return;if(!$gameSystem[_0x24c273(0x138)]())return;VisuMZ[_0x24c273(0x536)](_0x59907c,_0x59907c);const _0x27c2a9=VisuMZ[_0x24c273(0x552)](_0x59907c[_0x24c273(0xba0)]);let _0x9f9c93=_0x59907c[_0x24c273(0x1fe)]['match'](/back/i);for(const _0x11326a of _0x27c2a9){if(!_0x11326a)continue;if(_0x59907c[_0x24c273(0x1fe)][_0x24c273(0x95f)](/rand/i))_0x9f9c93=Math[_0x24c273(0x356)](0x2);_0x11326a[_0x24c273(0x3f8)](!!_0x9f9c93);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x3f0),_0x54dca2=>{const _0x5aab75=_0x45d586;if(!SceneManager[_0x5aab75(0x81a)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x5aab75(0x536)](_0x54dca2,_0x54dca2);const _0x7d8ec1=VisuMZ[_0x5aab75(0x552)](_0x54dca2[_0x5aab75(0xba0)]),_0x2c733d=_0x54dca2[_0x5aab75(0x916)];for(const _0x5af6f1 of _0x7d8ec1){if(!_0x5af6f1)continue;const _0x39ab13=_0x54dca2[_0x5aab75(0x257)](_0x5af6f1)||{'x':0x0,'y':0x0};let _0x27c0d7=_0x39ab13['x'],_0x4f1dd8=_0x39ab13['y'];_0x5af6f1[_0x5aab75(0xb49)](Math[_0x5aab75(0x31d)](_0x27c0d7),Math[_0x5aab75(0x31d)](_0x4f1dd8),!!_0x2c733d);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x9ed),_0x5ca319=>{const _0x3faa3b=_0x45d586;if(!SceneManager[_0x3faa3b(0x81a)]())return;if(!$gameSystem['isSideView']())return;VisuMZ['ConvertParams'](_0x5ca319,_0x5ca319);const _0xd30ed9=VisuMZ[_0x3faa3b(0x552)](_0x5ca319[_0x3faa3b(0xba0)]);let _0x2eae0b=_0x5ca319['Point'];const _0x581ae9=_0x5ca319[_0x3faa3b(0x916)];for(const _0x46fa9f of _0xd30ed9){if(!_0x46fa9f)continue;let _0x52c633=_0x46fa9f[_0x3faa3b(0xa7b)]()[_0x3faa3b(0x5bb)],_0x1ba880=_0x46fa9f[_0x3faa3b(0xa7b)]()[_0x3faa3b(0x83d)];if(_0x2eae0b['match'](/home/i))_0x52c633=_0x46fa9f[_0x3faa3b(0xa7b)]()[_0x3faa3b(0x47c)],_0x1ba880=_0x46fa9f[_0x3faa3b(0xa7b)]()['_homeY'];else{if(_0x2eae0b[_0x3faa3b(0x95f)](/center/i))_0x52c633=Graphics[_0x3faa3b(0x6ae)]/0x2,_0x1ba880=Graphics[_0x3faa3b(0x56c)]/0x2;else _0x2eae0b[_0x3faa3b(0x95f)](/point (\d+), (\d+)/i)&&(_0x52c633=Number(RegExp['$1']),_0x1ba880=Number(RegExp['$2']));}_0x46fa9f[_0x3faa3b(0xb49)](Math[_0x3faa3b(0x31d)](_0x52c633),Math[_0x3faa3b(0x31d)](_0x1ba880),!!_0x581ae9);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xb52),_0xbdb8b2=>{const _0xad18d5=_0x45d586;if(!SceneManager[_0xad18d5(0x81a)]())return;if(!$gameSystem[_0xad18d5(0x138)]())return;VisuMZ[_0xad18d5(0x536)](_0xbdb8b2,_0xbdb8b2);const _0x161646=VisuMZ['CreateActionSequenceTargets'](_0xbdb8b2[_0xad18d5(0x4ca)]),_0x48102a=VisuMZ[_0xad18d5(0x552)](_0xbdb8b2[_0xad18d5(0x188)]),_0x3613d3=_0x48102a[_0xad18d5(0x7a1)](_0x3cb469=>_0x3cb469&&_0x3cb469[_0xad18d5(0xa7b)]()?_0x3cb469[_0xad18d5(0xa7b)]()[_0xad18d5(0x5bb)]:0x0)/(_0x48102a['length']||0x1),_0x165a21=_0x48102a[_0xad18d5(0x7a1)](_0x54292c=>_0x54292c&&_0x54292c[_0xad18d5(0xa7b)]()?_0x54292c[_0xad18d5(0xa7b)]()[_0xad18d5(0x83d)]:0x0)/(_0x48102a[_0xad18d5(0x1c9)]||0x1),_0x5325cf=_0xbdb8b2[_0xad18d5(0x916)];for(const _0x54a943 of _0x161646){if(!_0x54a943)continue;_0x54a943['setBattlerFacePoint'](Math[_0xad18d5(0x31d)](_0x3613d3),Math[_0xad18d5(0x31d)](_0x165a21),!!_0x5325cf);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_Float',_0x1339a6=>{const _0x203c47=_0x45d586;if(!SceneManager[_0x203c47(0x81a)]())return;VisuMZ[_0x203c47(0x536)](_0x1339a6,_0x1339a6);const _0x449536=$gameTemp['getLastPluginCommandInterpreter'](),_0x139cb8=VisuMZ[_0x203c47(0x552)](_0x1339a6['Targets']),_0x13013c=_0x1339a6[_0x203c47(0x8d0)],_0x3b48c0=_0x1339a6[_0x203c47(0x7de)],_0x15d18f=_0x1339a6['EasingType'],_0xbc160f=_0x1339a6[_0x203c47(0x962)];if(!_0x449536)return;for(const _0xab73bb of _0x139cb8){if(!_0xab73bb)continue;_0xab73bb['floatBattler'](_0x13013c,_0x3b48c0,_0x15d18f);}if(_0xbc160f)_0x449536[_0x203c47(0x9c6)](_0x203c47(0x9d4));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x12f),_0x4be388=>{const _0x4455ba=_0x45d586;if(!SceneManager[_0x4455ba(0x81a)]())return;VisuMZ[_0x4455ba(0x536)](_0x4be388,_0x4be388);const _0x9a6244=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x9a6244)return;const _0x3f71bb=VisuMZ['CreateActionSequenceTargets'](_0x4be388[_0x4455ba(0xba0)]);for(const _0x13370c of _0x3f71bb){if(!_0x13370c)continue;_0x13370c[_0x4455ba(0x9df)]();}BattleManager['_subject']&&BattleManager['_subject']['performActionEnd']();if(_0x4be388['WaitForMovement'])_0x9a6244[_0x4455ba(0x9c6)](_0x4455ba(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x784),_0x30f134=>{const _0x559ee3=_0x45d586;if(!SceneManager[_0x559ee3(0x81a)]())return;VisuMZ['ConvertParams'](_0x30f134,_0x30f134);const _0x4dadf3=$gameTemp[_0x559ee3(0x421)](),_0x35e6c1=VisuMZ['CreateActionSequenceTargets'](_0x30f134['Targets']),_0xdeecf6=_0x30f134['Height'],_0x1d37fd=_0x30f134[_0x559ee3(0x7de)],_0x3ff4c1=_0x30f134[_0x559ee3(0xbbe)];if(!_0x4dadf3)return;for(const _0x2f807e of _0x35e6c1){if(!_0x2f807e)continue;_0x2f807e['jumpBattler'](_0xdeecf6,_0x1d37fd);}if(_0x3ff4c1)_0x4dadf3[_0x559ee3(0x9c6)]('battleJump');}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_MoveBy',_0x41c6d2=>{const _0x35783c=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x35783c(0x138)]())return;VisuMZ[_0x35783c(0x536)](_0x41c6d2,_0x41c6d2);const _0x40769f=$gameTemp[_0x35783c(0x421)](),_0x1067e3=VisuMZ[_0x35783c(0x552)](_0x41c6d2[_0x35783c(0xba0)]),_0x465d53=_0x41c6d2[_0x35783c(0xa97)],_0x3a9ae3=_0x41c6d2[_0x35783c(0xbd6)],_0x4bd773=_0x41c6d2[_0x35783c(0x698)],_0x5a85cb=_0x41c6d2[_0x35783c(0x7de)],_0x567958=_0x41c6d2[_0x35783c(0xe3)],_0x3e14ca=_0x41c6d2[_0x35783c(0xb1d)],_0x7c666e=_0x41c6d2[_0x35783c(0x937)],_0x4d3d83=_0x41c6d2[_0x35783c(0x9c0)];if(!_0x40769f)return;for(const _0xa51abd of _0x1067e3){if(!_0xa51abd)continue;let _0x5c2ece=_0x3a9ae3,_0x40a622=_0x4bd773;if(_0x465d53[_0x35783c(0x95f)](/horz/i))_0x5c2ece*=_0xa51abd[_0x35783c(0x7f0)]()?-0x1:0x1;if(_0x465d53[_0x35783c(0x95f)](/vert/i))_0x40a622*=_0xa51abd[_0x35783c(0x7f0)]()?-0x1:0x1;_0xa51abd[_0x35783c(0x5f3)](_0x5c2ece,_0x40a622,_0x5a85cb,_0x567958,_0x3e14ca),_0xa51abd['requestMotion'](_0x7c666e);}if(_0x4d3d83)_0x40769f[_0x35783c(0x9c6)]('battleMove');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_MoveToJsPoint',_0x295f09=>{const _0x163a1c=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x163a1c(0x138)]())return;VisuMZ[_0x163a1c(0x536)](_0x295f09,_0x295f09);const _0x8e71ff=$gameTemp[_0x163a1c(0x421)](),_0x35ef9a=VisuMZ[_0x163a1c(0x552)](_0x295f09[_0x163a1c(0xba0)]),_0x5d2acc=_0x295f09[_0x163a1c(0x631)],_0x47c97a=_0x295f09['OffsetX'],_0x5d750c=_0x295f09[_0x163a1c(0x261)],_0x5573f0=_0x295f09[_0x163a1c(0x7de)],_0x17bdc5=_0x295f09[_0x163a1c(0xe3)],_0x126a2b=_0x295f09[_0x163a1c(0xb1d)],_0x23c23b=_0x295f09[_0x163a1c(0x937)],_0x4ffc75=_0x295f09[_0x163a1c(0x9c0)];if(!_0x8e71ff)return;for(const _0x55a27c of _0x35ef9a){if(!_0x55a27c)continue;const _0x33bb9f=_0x295f09['DestinationJS'](_0x55a27c)||{'x':0x0,'y':0x0};let _0x441763=_0x33bb9f['x'],_0x206798=_0x33bb9f['y'];if(_0x5d2acc['match'](/none/i))_0x441763+=_0x47c97a,_0x206798+=_0x5d750c;else{if(_0x5d2acc[_0x163a1c(0x95f)](/horz/i)&&_0x5d2acc[_0x163a1c(0x95f)](/vert/i))_0x441763+=_0x55a27c[_0x163a1c(0x7f0)]()?-_0x47c97a:_0x47c97a,_0x206798+=_0x55a27c[_0x163a1c(0x7f0)]()?-_0x5d750c:_0x5d750c;else{if(_0x5d2acc[_0x163a1c(0x95f)](/horz/i))_0x441763+=_0x55a27c[_0x163a1c(0x7f0)]()?-_0x47c97a:_0x47c97a,_0x206798+=_0x5d750c;else _0x5d2acc[_0x163a1c(0x95f)](/vert/i)&&(_0x441763+=_0x47c97a,_0x206798+=_0x55a27c['isActor']()?-_0x5d750c:_0x5d750c);}}_0x55a27c[_0x163a1c(0xb12)](_0x441763,_0x206798,_0x5573f0,_0x17bdc5,_0x126a2b,-0x1),_0x55a27c['requestMotion'](_0x23c23b);}if(_0x4ffc75)_0x8e71ff[_0x163a1c(0x9c6)]('battleMove');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xcf),_0x57aa33=>{const _0x1d75de=_0x45d586;if(!SceneManager[_0x1d75de(0x81a)]())return;if(!$gameSystem[_0x1d75de(0x138)]())return;VisuMZ[_0x1d75de(0x536)](_0x57aa33,_0x57aa33);const _0x427536=$gameTemp['getLastPluginCommandInterpreter'](),_0x46607b=VisuMZ[_0x1d75de(0x552)](_0x57aa33[_0x1d75de(0xba0)]),_0x337bec=_0x57aa33['Destination'],_0xa90c4b=_0x57aa33[_0x1d75de(0x631)],_0x42c65c=_0x57aa33[_0x1d75de(0x34f)],_0x4cd6b4=_0x57aa33[_0x1d75de(0x261)],_0x2b082e=_0x57aa33[_0x1d75de(0x7de)],_0x486ae4=_0x57aa33[_0x1d75de(0xe3)],_0x4e2f86=_0x57aa33['EasingType'],_0x4a1df5=_0x57aa33['MotionType'],_0x46e9c8=_0x57aa33[_0x1d75de(0x9c0)];if(!_0x427536)return;for(const _0x31d888 of _0x46607b){if(!_0x31d888)continue;let _0x1819f0=_0x31d888[_0x1d75de(0xa7b)]()[_0x1d75de(0x5bb)],_0x12cf25=_0x31d888[_0x1d75de(0xa7b)]()['_baseY'];if(_0x337bec['match'](/home/i))_0x1819f0=_0x31d888[_0x1d75de(0xa7b)]()['_homeX'],_0x12cf25=_0x31d888[_0x1d75de(0xa7b)]()[_0x1d75de(0xac0)];else{if(_0x337bec[_0x1d75de(0x95f)](/center/i))_0x1819f0=Graphics[_0x1d75de(0x6ae)]/0x2,_0x12cf25=Graphics[_0x1d75de(0x56c)]/0x2;else _0x337bec['match'](/point (\d+), (\d+)/i)&&(_0x1819f0=Number(RegExp['$1']),_0x12cf25=Number(RegExp['$2']));}if(_0xa90c4b[_0x1d75de(0x95f)](/none/i))_0x1819f0+=_0x42c65c,_0x12cf25+=_0x4cd6b4;else{if(_0xa90c4b[_0x1d75de(0x95f)](/horz/i)&&_0xa90c4b[_0x1d75de(0x95f)](/vert/i))_0x1819f0+=_0x31d888[_0x1d75de(0x7f0)]()?-_0x42c65c:_0x42c65c,_0x12cf25+=_0x31d888[_0x1d75de(0x7f0)]()?-_0x4cd6b4:_0x4cd6b4;else{if(_0xa90c4b['match'](/horz/i))_0x1819f0+=_0x31d888[_0x1d75de(0x7f0)]()?-_0x42c65c:_0x42c65c,_0x12cf25+=_0x4cd6b4;else _0xa90c4b[_0x1d75de(0x95f)](/vert/i)&&(_0x1819f0+=_0x42c65c,_0x12cf25+=_0x31d888[_0x1d75de(0x7f0)]()?-_0x4cd6b4:_0x4cd6b4);}}_0x31d888[_0x1d75de(0xb12)](_0x1819f0,_0x12cf25,_0x2b082e,_0x486ae4,_0x4e2f86,-0x1),_0x31d888[_0x1d75de(0x135)](_0x4a1df5);}if(_0x46e9c8)_0x427536[_0x1d75de(0x9c6)](_0x1d75de(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x802),_0x2e25d5=>{const _0x4649a4=_0x45d586;if(!SceneManager[_0x4649a4(0x81a)]())return;if(!$gameSystem[_0x4649a4(0x138)]())return;VisuMZ[_0x4649a4(0x536)](_0x2e25d5,_0x2e25d5);const _0x5a32ab=$gameTemp['getLastPluginCommandInterpreter'](),_0x45a10b=VisuMZ[_0x4649a4(0x552)](_0x2e25d5[_0x4649a4(0x4ca)]),_0x7984e0=VisuMZ[_0x4649a4(0x552)](_0x2e25d5[_0x4649a4(0x188)]),_0x41c0ec=_0x2e25d5[_0x4649a4(0x4c9)];let _0x4f3da4=_0x2e25d5[_0x4649a4(0x274)];const _0x27d264=_0x2e25d5[_0x4649a4(0x631)],_0x420332=_0x2e25d5[_0x4649a4(0x34f)],_0x7c401c=_0x2e25d5[_0x4649a4(0x261)],_0x18cc7c=_0x2e25d5[_0x4649a4(0x7de)],_0x3a9ea4=_0x2e25d5[_0x4649a4(0xe3)],_0x5969ad=_0x2e25d5[_0x4649a4(0xb1d)],_0x5c10c0=_0x2e25d5[_0x4649a4(0x937)],_0x3e32f2=_0x2e25d5[_0x4649a4(0x9c0)],_0xf07541=Math['min'](..._0x7984e0[_0x4649a4(0x7a1)](_0x2dad63=>_0x2dad63[_0x4649a4(0xa7b)]()[_0x4649a4(0x5bb)]-_0x2dad63[_0x4649a4(0xa7b)]()[_0x4649a4(0x102)]()/0x2)),_0x3eb174=Math[_0x4649a4(0x61a)](..._0x7984e0[_0x4649a4(0x7a1)](_0x2282d6=>_0x2282d6[_0x4649a4(0xa7b)]()[_0x4649a4(0x5bb)]+_0x2282d6[_0x4649a4(0xa7b)]()[_0x4649a4(0x102)]()/0x2)),_0x36c55a=Math[_0x4649a4(0xb4b)](..._0x7984e0[_0x4649a4(0x7a1)](_0x3d89b3=>_0x3d89b3['battler']()[_0x4649a4(0x83d)]-_0x3d89b3['battler']()[_0x4649a4(0xa23)]())),_0x53931d=Math['max'](..._0x7984e0[_0x4649a4(0x7a1)](_0x203811=>_0x203811[_0x4649a4(0xa7b)]()[_0x4649a4(0x83d)])),_0x4a8bf7=_0x7984e0[_0x4649a4(0x229)](_0x5b27f5=>_0x5b27f5[_0x4649a4(0x7f0)]())['length'],_0x34125f=_0x7984e0[_0x4649a4(0x229)](_0x3f9723=>_0x3f9723[_0x4649a4(0x690)]())[_0x4649a4(0x1c9)];let _0x25007=0x0,_0x54faa6=0x0;if(_0x41c0ec[_0x4649a4(0x95f)](/front/i))_0x25007=_0x4a8bf7>=_0x34125f?_0xf07541:_0x3eb174;else{if(_0x41c0ec[_0x4649a4(0x95f)](/middle/i))_0x25007=(_0xf07541+_0x3eb174)/0x2,_0x4f3da4=-0x1;else _0x41c0ec[_0x4649a4(0x95f)](/back/i)&&(_0x25007=_0x4a8bf7>=_0x34125f?_0x3eb174:_0xf07541);}if(_0x41c0ec['match'](/head/i))_0x54faa6=_0x36c55a;else{if(_0x41c0ec[_0x4649a4(0x95f)](/center/i))_0x54faa6=(_0x36c55a+_0x53931d)/0x2;else _0x41c0ec[_0x4649a4(0x95f)](/base/i)&&(_0x54faa6=_0x53931d);}if(!_0x5a32ab)return;for(const _0x40e243 of _0x45a10b){if(!_0x40e243)continue;let _0xc3cd08=_0x25007,_0x1af48c=_0x54faa6;if(_0x27d264['match'](/none/i))_0xc3cd08+=_0x420332,_0x1af48c+=_0x7c401c;else{if(_0x27d264['match'](/horz/i)&&_0x27d264[_0x4649a4(0x95f)](/vert/i))_0xc3cd08+=_0x40e243[_0x4649a4(0x7f0)]()?-_0x420332:_0x420332,_0x1af48c+=_0x40e243[_0x4649a4(0x7f0)]()?-_0x7c401c:_0x7c401c;else{if(_0x27d264[_0x4649a4(0x95f)](/horz/i))_0xc3cd08+=_0x40e243[_0x4649a4(0x7f0)]()?-_0x420332:_0x420332,_0x1af48c+=_0x7c401c;else _0x27d264[_0x4649a4(0x95f)](/vert/i)&&(_0xc3cd08+=_0x420332,_0x1af48c+=_0x40e243['isActor']()?-_0x7c401c:_0x7c401c);}}_0x40e243['moveBattlerToPoint'](_0xc3cd08,_0x1af48c,_0x18cc7c,_0x3a9ea4,_0x5969ad,_0x4f3da4),_0x40e243[_0x4649a4(0x135)](_0x5c10c0);}if(_0x3e32f2)_0x5a32ab[_0x4649a4(0x9c6)](_0x4649a4(0x365));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x82b),_0x49368d=>{const _0x321710=_0x45d586;if(!SceneManager[_0x321710(0x81a)]())return;VisuMZ[_0x321710(0x536)](_0x49368d,_0x49368d);const _0x34fdc5=$gameTemp[_0x321710(0x421)](),_0x5d1f6e=VisuMZ[_0x321710(0x552)](_0x49368d[_0x321710(0xba0)]),_0x4151a4=_0x49368d[_0x321710(0x433)],_0x54360a=_0x49368d[_0x321710(0x7de)],_0x1743df=_0x49368d['EasingType'],_0x2156f7=_0x49368d['WaitForOpacity'];if(!_0x34fdc5)return;for(const _0x3f3222 of _0x5d1f6e){if(!_0x3f3222)continue;_0x3f3222[_0x321710(0x6a1)](_0x4151a4,_0x54360a,_0x1743df);}if(_0x2156f7)_0x34fdc5['setWaitMode']('battleOpacity');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x29c),_0x382958=>{const _0x527369=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x527369(0x536)](_0x382958,_0x382958);const _0xc06b14=$gameTemp['getLastPluginCommandInterpreter'](),_0x1590c1=VisuMZ[_0x527369(0x552)](_0x382958['Targets']),_0x23afbe=_0x382958['ScaleX'],_0x3e4539=_0x382958[_0x527369(0x6dd)],_0x1be045=_0x382958[_0x527369(0x7de)],_0xdde762=_0x382958[_0x527369(0xb1d)],_0x1958b1=_0x382958['WaitForScale'];if(!_0xc06b14)return;for(const _0x1054ec of _0x1590c1){if(!_0x1054ec)continue;_0x1054ec[_0x527369(0x43a)](_0x23afbe,_0x3e4539,_0x1be045,_0xdde762);}if(_0x1958b1)_0xc06b14[_0x527369(0x9c6)]('battleGrow');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_Skew',_0x387d8c=>{const _0x2e9a8e=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2e9a8e(0x536)](_0x387d8c,_0x387d8c);const _0x4795e9=$gameTemp[_0x2e9a8e(0x421)](),_0x310810=VisuMZ[_0x2e9a8e(0x552)](_0x387d8c[_0x2e9a8e(0xba0)]),_0x453875=_0x387d8c[_0x2e9a8e(0x897)],_0x1e3ccd=_0x387d8c[_0x2e9a8e(0xa55)],_0x3d7997=_0x387d8c[_0x2e9a8e(0x7de)],_0x9d18b9=_0x387d8c[_0x2e9a8e(0xb1d)],_0x3b7fa3=_0x387d8c[_0x2e9a8e(0xa7d)];if(!_0x4795e9)return;for(const _0x553610 of _0x310810){if(!_0x553610)continue;_0x553610[_0x2e9a8e(0x567)](_0x453875,_0x1e3ccd,_0x3d7997,_0x9d18b9);}if(_0x3b7fa3)_0x4795e9[_0x2e9a8e(0x9c6)](_0x2e9a8e(0x739));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x2f8),_0x2f5c6b=>{const _0xdd9f4b=_0x45d586;if(!SceneManager[_0xdd9f4b(0x81a)]())return;VisuMZ[_0xdd9f4b(0x536)](_0x2f5c6b,_0x2f5c6b);const _0x46551e=$gameTemp[_0xdd9f4b(0x421)](),_0x5738f6=VisuMZ['CreateActionSequenceTargets'](_0x2f5c6b[_0xdd9f4b(0xba0)]),_0x2453e2=_0x2f5c6b[_0xdd9f4b(0xbde)],_0x4c40fd=_0x2f5c6b[_0xdd9f4b(0x7de)],_0x3ab1dc=_0x2f5c6b[_0xdd9f4b(0xb1d)],_0x1b12d2=_0x2f5c6b[_0xdd9f4b(0x2ca)],_0x1cad2e=_0x2f5c6b[_0xdd9f4b(0xb85)];if(!_0x46551e)return;for(const _0x328e36 of _0x5738f6){if(!_0x328e36)continue;_0x328e36[_0xdd9f4b(0x658)](_0x2453e2,_0x4c40fd,_0x3ab1dc,_0x1b12d2);}if(_0x1cad2e)_0x46551e[_0xdd9f4b(0x9c6)](_0xdd9f4b(0x687));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x290),_0x39d162=>{const _0x17722a=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x3bfee8=$gameTemp[_0x17722a(0x421)]();if(!_0x3bfee8)return;_0x3bfee8[_0x17722a(0x9c6)](_0x17722a(0x9d4));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_WaitForJump',_0x3afeae=>{const _0x5c3933=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x2b5b40=$gameTemp[_0x5c3933(0x421)]();if(!_0x2b5b40)return;_0x2b5b40['setWaitMode']('battleJump');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_WaitForMovement',_0x5ca894=>{const _0x221950=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x5eaf6c=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x5eaf6c)return;_0x5eaf6c[_0x221950(0x9c6)](_0x221950(0x365));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Movement_WaitForOpacity',_0x411aaa=>{const _0x192acc=_0x45d586;if(!SceneManager[_0x192acc(0x81a)]())return;const _0x3370a9=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x3370a9)return;_0x3370a9['setWaitMode'](_0x192acc(0xa58));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x861),_0x295a75=>{const _0x3efb59=_0x45d586;if(!SceneManager[_0x3efb59(0x81a)]())return;const _0x1c714d=$gameTemp[_0x3efb59(0x421)]();if(!_0x1c714d)return;_0x1c714d['setWaitMode']('battleGrow');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x129),_0x854f4e=>{const _0x286749=_0x45d586;if(!SceneManager[_0x286749(0x81a)]())return;const _0x59e5a3=$gameTemp[_0x286749(0x421)]();if(!_0x59e5a3)return;_0x59e5a3[_0x286749(0x9c6)](_0x286749(0x739));}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x4d5),_0x1ee48e=>{const _0x1b1289=_0x45d586;if(!SceneManager[_0x1b1289(0x81a)]())return;const _0x852010=$gameTemp[_0x1b1289(0x421)]();if(!_0x852010)return;_0x852010[_0x1b1289(0x9c6)](_0x1b1289(0x687));}),VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x2ea)]=function(){const _0x9f17e3=_0x45d586;if(!Imported[_0x9f17e3(0xbd7)])return;if(VisuMZ['ActSeqProjectiles'][_0x9f17e3(0x23e)]<1.08){let _0x10a6aa='';_0x10a6aa+=_0x9f17e3(0x906),_0x10a6aa+=_0x9f17e3(0x94d),alert(_0x10a6aa),SceneManager[_0x9f17e3(0x16f)]();}},PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x4af),_0x3da2e1=>{const _0x510a3e=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x510a3e(0xbd7)])return;VisuMZ[_0x510a3e(0x536)](_0x3da2e1,_0x3da2e1),VisuMZ[_0x510a3e(0x6fe)][_0x510a3e(0x2ea)]();const _0x7ab8ad=$gameTemp[_0x510a3e(0x421)](),_0x5c3717=_0x3da2e1[_0x510a3e(0x887)];if(!_0x7ab8ad)return;const _0x3c10a7=BattleManager['_spriteset'];if(!_0x3c10a7)return;_0x3c10a7['createActionSequenceProjectile'](_0x3da2e1);if(_0x5c3717)_0x7ab8ad[_0x510a3e(0x9c6)]('battleProjectiles');}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Projectile_Icon',_0x39f6c8=>{const _0x3ed484=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3ed484(0xbd7)])return;VisuMZ['ConvertParams'](_0x39f6c8,_0x39f6c8),VisuMZ[_0x3ed484(0x6fe)][_0x3ed484(0x2ea)]();const _0x5b9373=$gameTemp[_0x3ed484(0x421)](),_0x5d2c1e=_0x39f6c8[_0x3ed484(0x887)];if(!_0x5b9373)return;const _0x36fb25=BattleManager['_spriteset'];if(!_0x36fb25)return;_0x36fb25[_0x3ed484(0x164)](_0x39f6c8);if(_0x5d2c1e)_0x5b9373[_0x3ed484(0x9c6)](_0x3ed484(0x66e));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x374),_0x20a091=>{const _0x4ea8c5=_0x45d586;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x4ea8c5(0xbd7)])return;VisuMZ[_0x4ea8c5(0x536)](_0x20a091,_0x20a091),VisuMZ['BattleCore'][_0x4ea8c5(0x2ea)]();const _0x484206=$gameTemp[_0x4ea8c5(0x421)](),_0x11a0f3=_0x20a091[_0x4ea8c5(0x887)];if(!_0x484206)return;const _0x1b1cc4=BattleManager[_0x4ea8c5(0x992)];if(!_0x1b1cc4)return;_0x1b1cc4[_0x4ea8c5(0x164)](_0x20a091);if(_0x11a0f3)_0x484206['setWaitMode']('battleProjectiles');}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x69c),_0x681042=>{const _0xf5255b=_0x45d586;if(!SceneManager[_0xf5255b(0x81a)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0xf5255b(0x536)](_0x681042,_0x681042);const _0x1ffe4c=$gameTemp[_0xf5255b(0x421)](),_0x423bc3=_0x681042[_0xf5255b(0xa7d)];if(!_0x1ffe4c)return;$gameScreen[_0xf5255b(0x59b)](_0x681042[_0xf5255b(0x897)],_0x681042[_0xf5255b(0xa55)],_0x681042[_0xf5255b(0x7de)],_0x681042['EasingType']);if(_0x423bc3)_0x1ffe4c[_0xf5255b(0x9c6)](_0xf5255b(0x1bc));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0xa10),_0x21a2e5=>{const _0x4d4df9=_0x45d586;if(!SceneManager[_0x4d4df9(0x81a)]())return;if(!Imported[_0x4d4df9(0x2ff)])return;VisuMZ[_0x4d4df9(0x536)](_0x21a2e5,_0x21a2e5);const _0x4185ac=$gameTemp[_0x4d4df9(0x421)](),_0x42f759=_0x21a2e5[_0x4d4df9(0xa7d)];if(!_0x4185ac)return;$gameScreen['setBattleSkew'](0x0,0x0,_0x21a2e5[_0x4d4df9(0x7de)],_0x21a2e5[_0x4d4df9(0xb1d)]);if(_0x42f759)_0x4185ac[_0x4d4df9(0x9c6)](_0x4d4df9(0x1bc));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Skew_WaitForSkew',_0x17be8c=>{const _0x1d6d0c=_0x45d586;if(!SceneManager[_0x1d6d0c(0x81a)]())return;if(!Imported[_0x1d6d0c(0x2ff)])return;const _0x3ad59d=$gameTemp[_0x1d6d0c(0x421)]();if(!_0x3ad59d)return;_0x3ad59d[_0x1d6d0c(0x9c6)](_0x1d6d0c(0x1bc));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Target_CurrentIndex',_0x4e182e=>{const _0x5e6d0e=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5e6d0e(0x536)](_0x4e182e,_0x4e182e);const _0x4c88d6=$gameTemp[_0x5e6d0e(0x421)](),_0x320171=_0x4e182e['Index'],_0x45abd8=_0x4e182e[_0x5e6d0e(0x890)];if(!_0x4c88d6)return;BattleManager['_targetIndex']=_0x320171,BattleManager[_0x5e6d0e(0x798)]=BattleManager[_0x5e6d0e(0x424)]?BattleManager[_0x5e6d0e(0x424)][BattleManager[_0x5e6d0e(0x157)]]||null:null,BattleManager[_0x5e6d0e(0x798)]&&_0x45abd8['toUpperCase']()[_0x5e6d0e(0x379)]()!==_0x5e6d0e(0xaab)&&_0x4c88d6[_0x5e6d0e(0x493)]([_0x45abd8]);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x77f),_0x3d96bd=>{const _0x188812=_0x45d586;if(!SceneManager[_0x188812(0x81a)]())return;VisuMZ[_0x188812(0x536)](_0x3d96bd,_0x3d96bd);const _0x4c4b81=$gameTemp['getLastPluginCommandInterpreter'](),_0x585909=_0x3d96bd[_0x188812(0x890)];if(!_0x4c4b81)return;BattleManager[_0x188812(0x157)]++,BattleManager[_0x188812(0x798)]=BattleManager[_0x188812(0x424)][BattleManager[_0x188812(0x157)]]||null,BattleManager[_0x188812(0x798)]&&_0x585909[_0x188812(0x689)]()[_0x188812(0x379)]()!==_0x188812(0xaab)&&_0x4c4b81[_0x188812(0x493)]([_0x585909]);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x731),_0x4054fc=>{const _0x4179e1=_0x45d586;if(!SceneManager[_0x4179e1(0x81a)]())return;VisuMZ['ConvertParams'](_0x4054fc,_0x4054fc);const _0x4f7719=$gameTemp[_0x4179e1(0x421)](),_0x261060=_0x4054fc[_0x4179e1(0x890)];if(!_0x4f7719)return;BattleManager[_0x4179e1(0x157)]--,BattleManager[_0x4179e1(0x798)]=BattleManager['_allTargets'][BattleManager[_0x4179e1(0x157)]]||null,BattleManager[_0x4179e1(0x798)]&&_0x261060[_0x4179e1(0x689)]()[_0x4179e1(0x379)]()!==_0x4179e1(0xaab)&&_0x4f7719[_0x4179e1(0x493)]([_0x261060]);}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x6b7),_0x4f94ba=>{const _0x49f773=_0x45d586;if(!SceneManager[_0x49f773(0x81a)]())return;VisuMZ[_0x49f773(0x536)](_0x4f94ba,_0x4f94ba);const _0x47a0fd=$gameTemp[_0x49f773(0x421)](),_0x4cbdca=_0x4f94ba[_0x49f773(0x308)],_0x580d42=_0x4f94ba[_0x49f773(0x890)];if(!_0x47a0fd)return;const _0x1f413f=BattleManager[_0x49f773(0x157)];for(;;){BattleManager[_0x49f773(0x157)]=Math[_0x49f773(0x356)](BattleManager[_0x49f773(0x424)][_0x49f773(0x1c9)]);if(!_0x4cbdca)break;if(BattleManager[_0x49f773(0x157)]!==_0x1f413f)break;if(BattleManager[_0x49f773(0x424)][_0x49f773(0x1c9)]<=0x1){BattleManager[_0x49f773(0x157)]=0x0;break;}}BattleManager[_0x49f773(0x798)]=BattleManager[_0x49f773(0x424)][BattleManager['_targetIndex']]||null,BattleManager[_0x49f773(0x798)]&&_0x580d42[_0x49f773(0x689)]()[_0x49f773(0x379)]()!==_0x49f773(0xaab)&&_0x47a0fd['command119']([_0x580d42]);}),PluginManager[_0x45d586(0xb11)](pluginData['name'],'ActSeq_BattleVoice_PlayCommonLine',_0x2ef900=>{const _0x3a6b17=_0x45d586;if(!SceneManager[_0x3a6b17(0x81a)]())return;if(!Imported[_0x3a6b17(0x35a)])return;if(!ConfigManager[_0x3a6b17(0x9de)])return;VisuMZ['ConvertParams'](_0x2ef900,_0x2ef900);const _0x3f5843=VisuMZ[_0x3a6b17(0x552)](_0x2ef900[_0x3a6b17(0xba0)]);let _0x3c0726=_0x2ef900['VoiceLine']||'';for(const _0x64fef5 of _0x3f5843){if(!_0x64fef5)continue;_0x64fef5['playBattleVoice'](_0x3c0726);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_BattleVoice_PlaySpecialLine',_0x3718ae=>{const _0x7c38fd=_0x45d586;if(!SceneManager[_0x7c38fd(0x81a)]())return;if(!Imported['VisuMZ_3_BattleVoices'])return;if(!ConfigManager['battleVoices'])return;VisuMZ[_0x7c38fd(0x536)](_0x3718ae,_0x3718ae);const _0xd9ff7c=VisuMZ[_0x7c38fd(0x552)](_0x3718ae['Targets']);let _0x29ccfe=(_0x3718ae[_0x7c38fd(0xbee)]||'')+(_0x3718ae[_0x7c38fd(0xdb)]||'');for(const _0x433118 of _0xd9ff7c){if(!_0x433118)continue;_0x433118[_0x7c38fd(0x1da)](_0x29ccfe);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x4fc),_0x49f2d8=>{const _0x12f94d=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x12f94d(0x536)](_0x49f2d8,_0x49f2d8);const _0x451498=VisuMZ['CreateActionSequenceTargets'](_0x49f2d8[_0x12f94d(0xba0)]);for(const _0x432a7f of _0x451498){if(!_0x432a7f)continue;if(!_0x432a7f[_0x12f94d(0x7f0)]())continue;_0x432a7f['clearActiveWeaponSlot']();}}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x32d),_0x1c86e0=>{const _0x3afba5=_0x45d586;if(!SceneManager[_0x3afba5(0x81a)]())return;VisuMZ[_0x3afba5(0x536)](_0x1c86e0,_0x1c86e0);const _0x572eeb=$gameTemp[_0x3afba5(0x421)]();let _0x3e4a0c=![];const _0x16ad93=_0x1c86e0[_0x3afba5(0x890)],_0x3f22fe=VisuMZ[_0x3afba5(0x552)](_0x1c86e0[_0x3afba5(0xba0)]);for(const _0x10948f of _0x3f22fe){if(!_0x10948f)continue;if(!_0x10948f[_0x3afba5(0x7f0)]())continue;_0x10948f[_0x3afba5(0x866)](),_0x10948f[_0x3afba5(0x633)]()[_0x3afba5(0x1c9)]>0x0?_0x3e4a0c=!![]:_0x10948f[_0x3afba5(0x140)]();}_0x3e4a0c&&_0x16ad93['toUpperCase']()[_0x3afba5(0x379)]()!==_0x3afba5(0xaab)&&_0x572eeb[_0x3afba5(0x493)]([_0x16ad93]);}),PluginManager['registerCommand'](pluginData[_0x45d586(0x5c2)],_0x45d586(0x37f),_0x598121=>{const _0x373a18=_0x45d586;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x373a18(0x536)](_0x598121,_0x598121);let _0x185e33=_0x598121[_0x373a18(0x2ac)];_0x185e33--,_0x185e33=Math['max'](_0x185e33,0x0);const _0x5eae1d=VisuMZ[_0x373a18(0x552)](_0x598121[_0x373a18(0xba0)]);for(const _0x1acf30 of _0x5eae1d){if(!_0x1acf30)continue;if(!_0x1acf30['isActor']())continue;_0x1acf30[_0x373a18(0xa9a)](_0x185e33);}}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],'ActSeq_Zoom_Scale',_0x673056=>{const _0x342dbe=_0x45d586;if(!SceneManager[_0x342dbe(0x81a)]())return;if(!Imported[_0x342dbe(0x2ff)])return;VisuMZ[_0x342dbe(0x536)](_0x673056,_0x673056);const _0x515849=$gameTemp[_0x342dbe(0x421)](),_0x485bf4=_0x673056['WaitForZoom'];if(!_0x515849)return;$gameScreen[_0x342dbe(0xb51)](_0x673056[_0x342dbe(0x150)],_0x673056['Duration'],_0x673056[_0x342dbe(0xb1d)]);if(_0x485bf4)_0x515849['setWaitMode'](_0x342dbe(0x48e));}),PluginManager[_0x45d586(0xb11)](pluginData[_0x45d586(0x5c2)],_0x45d586(0x42c),_0x5846cc=>{const _0x2b4754=_0x45d586;if(!SceneManager[_0x2b4754(0x81a)]())return;if(!Imported[_0x2b4754(0x2ff)])return;VisuMZ[_0x2b4754(0x536)](_0x5846cc,_0x5846cc);const _0x4d867d=$gameTemp[_0x2b4754(0x421)](),_0x1432ca=_0x5846cc['WaitForZoom'];if(!_0x4d867d)return;$gameScreen[_0x2b4754(0xb51)](0x1,_0x5846cc[_0x2b4754(0x7de)],_0x5846cc[_0x2b4754(0xb1d)]);if(_0x1432ca)_0x4d867d['setWaitMode'](_0x2b4754(0x48e));}),PluginManager[_0x45d586(0xb11)](pluginData['name'],_0x45d586(0x444),_0x4d380e=>{const _0x32a680=_0x45d586;if(!SceneManager[_0x32a680(0x81a)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x559b6c=$gameTemp[_0x32a680(0x421)]();if(!_0x559b6c)return;_0x559b6c[_0x32a680(0x9c6)]('battleZoom');}),VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x7bf)]=Scene_Boot['prototype'][_0x45d586(0x53f)],Scene_Boot[_0x45d586(0x19f)]['onDatabaseLoaded']=function(){const _0x242c26=_0x45d586;this[_0x242c26(0x9bb)](),this[_0x242c26(0xa74)](),this[_0x242c26(0xa8b)](),this['process_VisuMZ_BattleCore_CreateRegExp'](),VisuMZ[_0x242c26(0x6fe)][_0x242c26(0x7bf)][_0x242c26(0x1b5)](this),this[_0x242c26(0x615)](),this[_0x242c26(0x67a)](),this[_0x242c26(0x4a1)](),this['process_VisuMZ_BattleCore_CommonEventKeys']();},Scene_Boot['prototype'][_0x45d586(0x615)]=function(){const _0x3efccd=_0x45d586;if(VisuMZ[_0x3efccd(0x461)])return;this['process_VisuMZ_BattleCore_Action_Notetags'](),this[_0x3efccd(0xb99)](),this['process_VisuMZ_BattleCore_jsFunctions']();},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0x9bb)]=function(){const _0x18bce5=_0x45d586,_0x5d9bbb=$dataSystem['weaponTypes'][_0x18bce5(0x1c9)];for(let _0x3a57d7=0x0;_0x3a57d7<_0x5d9bbb;_0x3a57d7++){const _0xb897af=$dataSystem[_0x18bce5(0x18a)][_0x3a57d7];if(_0xb897af)continue;$dataSystem['attackMotions'][_0x3a57d7]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot['prototype']['process_VisuMZ_BattleCore_PluginParams']=function(){const _0x18924a=_0x45d586,_0x525f64=VisuMZ[_0x18924a(0x6fe)][_0x18924a(0xa41)];_0x525f64[_0x18924a(0x244)][_0x18924a(0x7e0)]===undefined&&(_0x525f64[_0x18924a(0x244)][_0x18924a(0x7e0)]=_0x18924a(0x3e7)),_0x525f64[_0x18924a(0x540)][_0x18924a(0xa6b)]===undefined&&(_0x525f64[_0x18924a(0x540)][_0x18924a(0xa6b)]=![]),_0x525f64[_0x18924a(0x401)][_0x18924a(0xa6b)]===undefined&&(_0x525f64[_0x18924a(0x401)][_0x18924a(0xa6b)]=!![]),_0x525f64[_0x18924a(0x540)][_0x18924a(0x4b0)]===undefined&&(_0x525f64[_0x18924a(0x540)][_0x18924a(0x4b0)]=![]),_0x525f64['Actor'][_0x18924a(0x859)]===undefined&&(_0x525f64['Actor']['PrioritySortActors']=!![]);},VisuMZ[_0x45d586(0x58f)]={},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0xa8b)]=function(){const _0x469352=_0x45d586;for(const _0x1e6583 of VisuMZ[_0x469352(0x6fe)]['Settings'][_0x469352(0x244)][_0x469352(0xa30)]){if(!_0x1e6583)continue;const _0xe96f2c=_0x1e6583[_0x469352(0x519)][_0x469352(0x689)]()['trim']();VisuMZ['DamageStyles'][_0xe96f2c]=_0x1e6583;}},VisuMZ['BattleCore']['RegExp']={'jsAccuracy':/<JS (?:ACCURACY|ACC|HIT|EVA)>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA)>/i,'jsAccuracyAsUser':/<JS (?:ACCURACY|ACC|HIT|EVA) AS USER>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS USER>/i,'jsAccuracyAsTarget':/<JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:ACCURACY|ACC|HIT|EVA) AS TARGET>/i,'jsCritRateAsUser':/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i,'jsCritRateAsTarget':/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0x7ff)]=function(){const _0x32ab80=_0x45d586,_0x3aeb87=VisuMZ[_0x32ab80(0x6fe)]['RegExp'],_0x256e10='<%1>\x5cs*([\x5cs\x5cS]*)\x5cs*<\x5c/%1>',_0xd2ee12=[[_0x32ab80(0x56e),_0x32ab80(0x811)],[_0x32ab80(0xa49),'POST-']],_0x3aadf5=[[_0x32ab80(0x901),_0x32ab80(0x179)],['%1Damage%2JS','JS\x20%1DAMAGE\x20%2']],_0x46b996=[['',''],['AsUser','AS\x20USER'],['AsTarget','AS\x20TARGET']];for(const _0x1f1897 of _0x3aadf5){for(const _0x2083e1 of _0x46b996){for(const _0x40ce69 of _0xd2ee12){const _0x38c638=_0x1f1897[0x0][_0x32ab80(0x534)](_0x40ce69[0x0],_0x2083e1[0x0]),_0x4fd576=_0x1f1897[0x1][_0x32ab80(0x534)](_0x40ce69[0x1],_0x2083e1[0x1])['trim'](),_0x28dc7d=new RegExp(_0x256e10[_0x32ab80(0x534)](_0x4fd576),'i');_0x3aeb87[_0x38c638]=_0x28dc7d;}}}const _0x431bdb=[[_0x32ab80(0x831),_0x32ab80(0x86b)],['%1EndActionJS',_0x32ab80(0x6c9)]];for(const _0x92d2de of _0x431bdb){for(const _0xda6f9c of _0xd2ee12){const _0x4f1d4b=_0x92d2de[0x0]['format'](_0xda6f9c[0x0]),_0x89f05b=_0x92d2de[0x1][_0x32ab80(0x534)](_0xda6f9c[0x1]),_0x1dbb23=new RegExp(_0x256e10['format'](_0x89f05b),'i');_0x3aeb87[_0x4f1d4b]=_0x1dbb23;}}const _0x183dad=[[_0x32ab80(0x24a),_0x32ab80(0x2f3)],[_0x32ab80(0x4e8),_0x32ab80(0x415)],[_0x32ab80(0x440),_0x32ab80(0x117)],[_0x32ab80(0x266),_0x32ab80(0x453)],[_0x32ab80(0x46e),_0x32ab80(0x1a2)],[_0x32ab80(0xaa3),_0x32ab80(0x2d5)],[_0x32ab80(0x575),_0x32ab80(0x306)],[_0x32ab80(0x9f0),'JS\x20%1END\x20TURN'],[_0x32ab80(0x467),'JS\x20%1REGENERATE']];for(const _0x1e2ae9 of _0x183dad){for(const _0x218bb8 of _0xd2ee12){const _0x3f1a44=_0x1e2ae9[0x0]['format'](_0x218bb8[0x0]),_0x139659=_0x1e2ae9[0x1]['format'](_0x218bb8[0x1]),_0x3f6d94=new RegExp(_0x256e10['format'](_0x139659),'i');_0x3aeb87[_0x3f1a44]=_0x3f6d94;}}},Scene_Boot['prototype'][_0x45d586(0x9fb)]=function(){const _0x43548e=_0x45d586,_0x3e24fa=$dataSkills['concat']($dataItems);for(const _0x1970fc of _0x3e24fa){if(!_0x1970fc)continue;VisuMZ[_0x43548e(0x6fe)][_0x43548e(0xb97)](_0x1970fc);}},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0xb99)]=function(){const _0x54def9=_0x45d586,_0x3e8fce=$dataActors[_0x54def9(0xb10)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x525ab4 of _0x3e8fce){if(!_0x525ab4)continue;VisuMZ[_0x54def9(0x6fe)][_0x54def9(0xa16)](_0x525ab4),_0x525ab4['autoRemovalTiming']!==undefined&&VisuMZ['BattleCore'][_0x54def9(0x41c)](_0x525ab4);}},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0x67a)]=function(){const _0x2f5a37=_0x45d586,_0x26757d=VisuMZ[_0x2f5a37(0x6fe)]['Settings'][_0x2f5a37(0x4c4)][_0x2f5a37(0x9d2)],_0x34b4c4=[];for(const _0x5e3aa0 of _0x26757d){const _0x4bdac8=$dataTroops[_0x5e3aa0];if(_0x4bdac8)_0x34b4c4['push'](JsonEx[_0x2f5a37(0x9cc)](_0x4bdac8));}for(const _0x40190f of $dataTroops){if(!_0x40190f)continue;for(const _0x536a7f of _0x34b4c4){if(_0x536a7f['id']===_0x40190f['id'])continue;_0x40190f[_0x2f5a37(0xbda)]=_0x40190f[_0x2f5a37(0xbda)]['concat'](_0x536a7f[_0x2f5a37(0xbda)]);}}},Scene_Boot['prototype']['process_VisuMZ_BattleCore_PreBattleCommonEvent']=function(){const _0x10a61a=_0x45d586,_0x551e10=VisuMZ[_0x10a61a(0x6fe)][_0x10a61a(0xa41)]['Mechanics'];if(_0x551e10[_0x10a61a(0x95e)]>0x0&&$dataCommonEvents[_0x551e10[_0x10a61a(0x95e)]]){const _0x310dfc=$dataCommonEvents[_0x551e10[_0x10a61a(0x95e)]],_0x323659=_0x310dfc[_0x10a61a(0x505)][_0x10a61a(0x1c9)]-0x2,_0x259012=_0x310dfc[_0x10a61a(0x505)][_0x323659];if(_0x259012&&_0x259012[_0x10a61a(0xa27)]!==0xe6){const _0x599e31={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x5aa06a=_0x310dfc[_0x10a61a(0x505)][_0x10a61a(0x8c2)]();_0x310dfc[_0x10a61a(0x505)][_0x10a61a(0x96c)](_0x599e31),_0x310dfc[_0x10a61a(0x505)][_0x10a61a(0x96c)](_0x5aa06a);}}},Scene_Boot['prototype']['process_VisuMZ_BattleCore_CommonEventKeys']=function(){const _0x1ac7bc=_0x45d586;VisuMZ[_0x1ac7bc(0x6fe)][_0x1ac7bc(0x4c5)](),VisuMZ[_0x1ac7bc(0x6fe)][_0x1ac7bc(0x89e)]($dataSkills),VisuMZ['BattleCore'][_0x1ac7bc(0x89e)]($dataItems);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x4c5)]=function(){const _0x3d2e5f=_0x45d586;VisuMZ['BattleCore'][_0x3d2e5f(0x387)]={};for(const _0x4667de of $dataCommonEvents){if(!_0x4667de)continue;if(_0x4667de['name']['match'](/\[(.*)\]/i)){let _0x4b121f=String(RegExp['$1'])[_0x3d2e5f(0x646)](/,/g,'')[_0x3d2e5f(0x689)]()[_0x3d2e5f(0x379)]();VisuMZ[_0x3d2e5f(0x6fe)][_0x3d2e5f(0x387)][_0x4b121f]=_0x4667de['id'];}}},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x89e)]=function(_0x52aaab){const _0x4827f2=_0x45d586;for(const _0xca7a09 of _0x52aaab){if(!_0xca7a09)continue;VisuMZ[_0x4827f2(0x6fe)]['BindCommonEventKeysForObj'](_0xca7a09);}},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x701)]=function(_0x41e158){const _0x177e64=_0x45d586;if(!_0x41e158)return;if(!_0x41e158[_0x177e64(0x49d)])return;VisuMZ[_0x177e64(0x6fe)][_0x177e64(0x387)]=VisuMZ[_0x177e64(0x6fe)][_0x177e64(0x387)]||{};const _0x2eb8a8=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x20f550=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x4f79c8=[];const _0x4d461d=_0x41e158[_0x177e64(0x34a)][_0x177e64(0x95f)](_0x2eb8a8);if(_0x4d461d){for(const _0x3496b3 of _0x4d461d){_0x3496b3[_0x177e64(0x95f)](_0x2eb8a8);const _0x2a73ea=String(RegExp['$1'])[_0x177e64(0xaea)](',')['map'](_0x654595=>String(_0x654595)[_0x177e64(0x689)]()[_0x177e64(0x379)]());_0x4f79c8=_0x4f79c8[_0x177e64(0xb10)](_0x2a73ea);}!_0x41e158[_0x177e64(0x34a)][_0x177e64(0x95f)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x41e158['note']+='<CUSTOM\x20ACTION\x20SEQUENCE>');;}if(_0x41e158[_0x177e64(0x34a)][_0x177e64(0x95f)](_0x20f550)){const _0x201233=String(RegExp['$1'])[_0x177e64(0xaea)](/[\r\n]+/)[_0x177e64(0x7a1)](_0xdc4a0c=>String(_0xdc4a0c)[_0x177e64(0x689)]()['trim']());_0x4f79c8=_0x4f79c8[_0x177e64(0xb10)](_0x201233);!_0x41e158['note'][_0x177e64(0x95f)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x41e158[_0x177e64(0x34a)]+=_0x177e64(0xb02));;}for(const _0x31f251 of _0x4f79c8){if(VisuMZ[_0x177e64(0x6fe)]['_commonEventKey'][_0x31f251]){const _0x54a621=VisuMZ['BattleCore'][_0x177e64(0x387)][_0x31f251],_0x10d20a={'code':0x2c,'dataId':_0x54a621,'value1':0x1,'value2':0x0};_0x41e158[_0x177e64(0x49d)]['push'](_0x10d20a);}}},Scene_Boot[_0x45d586(0x19f)][_0x45d586(0x3e6)]=function(){const _0x293263=_0x45d586,_0xa341f0=$dataSkills['concat']($dataItems);for(const _0x3e07e0 of _0xa341f0){if(!_0x3e07e0)continue;VisuMZ[_0x293263(0x6fe)][_0x293263(0x817)](_0x3e07e0);}},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x3c3)]=VisuMZ['ParseActorNotetags'],VisuMZ[_0x45d586(0x3c3)]=function(_0x43e75d){const _0x56b911=_0x45d586;VisuMZ['BattleCore']['ParseActorNotetags']&&VisuMZ[_0x56b911(0x6fe)]['ParseActorNotetags'][_0x56b911(0x1b5)](this,_0x43e75d),VisuMZ[_0x56b911(0x6fe)]['Parse_Notetags_TraitObjects'](_0x43e75d);},VisuMZ['BattleCore'][_0x45d586(0x68f)]=VisuMZ[_0x45d586(0x68f)],VisuMZ['ParseClassNotetags']=function(_0x2c1f9a){const _0x362dd9=_0x45d586;VisuMZ[_0x362dd9(0x6fe)][_0x362dd9(0x68f)]&&VisuMZ[_0x362dd9(0x6fe)][_0x362dd9(0x68f)][_0x362dd9(0x1b5)](this,_0x2c1f9a),VisuMZ['BattleCore'][_0x362dd9(0xa16)](_0x2c1f9a);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x6c8)]=VisuMZ[_0x45d586(0x6c8)],VisuMZ[_0x45d586(0x6c8)]=function(_0x4c4f50){const _0x4dd475=_0x45d586;VisuMZ['BattleCore'][_0x4dd475(0x6c8)]&&VisuMZ[_0x4dd475(0x6fe)]['ParseSkillNotetags']['call'](this,_0x4c4f50),VisuMZ[_0x4dd475(0x6fe)]['Parse_Notetags_Action'](_0x4c4f50),VisuMZ['BattleCore'][_0x4dd475(0x817)](_0x4c4f50);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xf4)]=VisuMZ[_0x45d586(0xf4)],VisuMZ[_0x45d586(0xf4)]=function(_0x163f04){const _0x422ecb=_0x45d586;VisuMZ[_0x422ecb(0x6fe)][_0x422ecb(0xf4)]&&VisuMZ[_0x422ecb(0x6fe)][_0x422ecb(0xf4)]['call'](this,_0x163f04),VisuMZ[_0x422ecb(0x6fe)][_0x422ecb(0xb97)](_0x163f04),VisuMZ[_0x422ecb(0x6fe)][_0x422ecb(0x817)](_0x163f04);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x754)]=VisuMZ[_0x45d586(0x754)],VisuMZ[_0x45d586(0x754)]=function(_0x3fd318){const _0x18010d=_0x45d586;VisuMZ[_0x18010d(0x6fe)][_0x18010d(0x754)]&&VisuMZ['BattleCore'][_0x18010d(0x754)][_0x18010d(0x1b5)](this,_0x3fd318),VisuMZ['BattleCore']['Parse_Notetags_TraitObjects'](_0x3fd318);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x13d)]=VisuMZ[_0x45d586(0x13d)],VisuMZ['ParseArmorNotetags']=function(_0x1f2973){const _0x22d9b5=_0x45d586;VisuMZ['BattleCore'][_0x22d9b5(0x13d)]&&VisuMZ[_0x22d9b5(0x6fe)][_0x22d9b5(0x13d)][_0x22d9b5(0x1b5)](this,_0x1f2973),VisuMZ['BattleCore']['Parse_Notetags_TraitObjects'](_0x1f2973);},VisuMZ[_0x45d586(0x6fe)]['ParseEnemyNotetags']=VisuMZ[_0x45d586(0x968)],VisuMZ[_0x45d586(0x968)]=function(_0x47d001){const _0x146bb0=_0x45d586;VisuMZ[_0x146bb0(0x6fe)][_0x146bb0(0x968)]&&VisuMZ[_0x146bb0(0x6fe)][_0x146bb0(0x968)][_0x146bb0(0x1b5)](this,_0x47d001),VisuMZ['BattleCore'][_0x146bb0(0xa16)](_0x47d001);},VisuMZ['BattleCore']['ParseStateNotetags']=VisuMZ[_0x45d586(0x582)],VisuMZ[_0x45d586(0x582)]=function(_0x32a05a){const _0x2fc263=_0x45d586;VisuMZ[_0x2fc263(0x6fe)]['ParseStateNotetags']&&VisuMZ[_0x2fc263(0x6fe)][_0x2fc263(0x582)][_0x2fc263(0x1b5)](this,_0x32a05a),VisuMZ[_0x2fc263(0x6fe)][_0x2fc263(0xa16)](_0x32a05a),VisuMZ[_0x2fc263(0x6fe)][_0x2fc263(0x41c)](_0x32a05a);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xb97)]=function(_0x425c8c){const _0x2fe3c4=_0x45d586,_0x29b496=[_0x2fe3c4(0x5cb),_0x2fe3c4(0x960),_0x2fe3c4(0x335),_0x2fe3c4(0xe1),_0x2fe3c4(0x2b1),_0x2fe3c4(0x581),_0x2fe3c4(0xaf1),_0x2fe3c4(0x966)];for(const _0x2e9074 of _0x29b496){VisuMZ[_0x2fe3c4(0x6fe)][_0x2fe3c4(0x511)](_0x425c8c,_0x2e9074);}const _0x5a7503=_0x425c8c['note'];_0x5a7503[_0x2fe3c4(0x95f)](/<ALWAYS CRITICAL/i)&&(_0x425c8c[_0x2fe3c4(0xb5d)][_0x2fe3c4(0x1f7)]=!![]),_0x5a7503[_0x2fe3c4(0x95f)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x425c8c[_0x2fe3c4(0x5ed)]=Math[_0x2fe3c4(0x61a)](0x1,Number(RegExp['$1']))),_0x5a7503[_0x2fe3c4(0x95f)](/<TARGET:[ ](.*)>/i)&&(_0x425c8c[_0x2fe3c4(0x657)]=String(RegExp['$1'])['toUpperCase']()[_0x2fe3c4(0x379)]());},VisuMZ['BattleCore'][_0x45d586(0xa16)]=function(_0x47934d){const _0x5f0165=_0x45d586,_0x3ca591=[_0x5f0165(0x989),'PostApplyAsUserJS',_0x5f0165(0x95a),_0x5f0165(0x694),_0x5f0165(0x607),_0x5f0165(0x80c),'PreDamageAsTargetJS',_0x5f0165(0xbb3),'PreStartActionJS',_0x5f0165(0x581),_0x5f0165(0xaf1),_0x5f0165(0x966),_0x5f0165(0xaa9),_0x5f0165(0x90b),'PreEndBattleJS',_0x5f0165(0x932),_0x5f0165(0x440),_0x5f0165(0x266),_0x5f0165(0x46e),'EscapeFailureJS',_0x5f0165(0x1bb),'PostStartTurnJS',_0x5f0165(0x50c),_0x5f0165(0x76b),_0x5f0165(0xbcc),_0x5f0165(0x6a2)];for(const _0x336190 of _0x3ca591){VisuMZ[_0x5f0165(0x6fe)][_0x5f0165(0x511)](_0x47934d,_0x336190);}const _0x5b97fb=['jsAccuracy',_0x5f0165(0x5d0),_0x5f0165(0x22e),_0x5f0165(0x7ab),'jsCritRateAsTarget'];for(const _0xbf7291 of _0x5b97fb){VisuMZ['BattleCore'][_0x5f0165(0x62d)](_0x47934d,_0xbf7291);}},VisuMZ['BattleCore'][_0x45d586(0x817)]=function(_0x4ae3ac){const _0x14ba51=_0x45d586,_0x2df853=_0x4ae3ac[_0x14ba51(0x34a)];if(_0x2df853['match'](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){const _0x2b00f6=String(RegExp['$1']),_0xee3517=VisuMZ[_0x14ba51(0x6fe)][_0x14ba51(0x2f1)](_0x4ae3ac,'Targets');VisuMZ[_0x14ba51(0x6fe)][_0x14ba51(0xa7a)](_0x2b00f6,_0xee3517);}if(_0x2df853[_0x14ba51(0x95f)](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){const _0x18225b=String(RegExp['$1']),_0x1efb5a=VisuMZ[_0x14ba51(0x6fe)][_0x14ba51(0x2f1)](_0x4ae3ac,_0x14ba51(0x9a3));VisuMZ['BattleCore'][_0x14ba51(0x98d)](_0x18225b,_0x1efb5a);}},VisuMZ['BattleCore']['JS']={},VisuMZ['BattleCore'][_0x45d586(0x511)]=function(_0xc634ec,_0x172b23){const _0xafd279=_0x45d586,_0x8d9e0d=_0xc634ec[_0xafd279(0x34a)];if(_0x8d9e0d[_0xafd279(0x95f)](VisuMZ[_0xafd279(0x6fe)][_0xafd279(0xa98)][_0x172b23])){const _0x9d3dd6=RegExp['$1'],_0x4a5643='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'[_0xafd279(0x534)](_0x9d3dd6),_0x306e94=VisuMZ[_0xafd279(0x6fe)][_0xafd279(0x2f1)](_0xc634ec,_0x172b23);VisuMZ['BattleCore']['JS'][_0x306e94]=new Function(_0x4a5643);}},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x2f1)]=function(_0x5cc47b,_0x267541){const _0x3f415a=_0x45d586;if(VisuMZ[_0x3f415a(0x2f1)])return VisuMZ[_0x3f415a(0x2f1)](_0x5cc47b,_0x267541);let _0x134f2c='';if($dataActors[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0x279)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataClasses['includes'](_0x5cc47b))_0x134f2c=_0x3f415a(0x400)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataSkills[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0xb39)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataItems[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0x49e)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataWeapons[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0xa1c)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataArmors[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0x1b2)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);if($dataEnemies[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0x12e)['format'](_0x5cc47b['id'],_0x267541);if($dataStates[_0x3f415a(0x840)](_0x5cc47b))_0x134f2c=_0x3f415a(0x79b)[_0x3f415a(0x534)](_0x5cc47b['id'],_0x267541);return _0x134f2c;},VisuMZ[_0x45d586(0x6fe)]['createTargetsJS']=function(_0x36fe6d,_0x287c29){const _0x39ff44=_0x45d586,_0x1aee4d='\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20let\x20targets\x20=\x20arguments[1];\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20return\x20targets\x20||\x20[];\x0a\x20\x20\x20\x20'[_0x39ff44(0x534)](_0x36fe6d);VisuMZ['BattleCore']['JS'][_0x287c29]=new Function(_0x1aee4d);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x98d)]=function(_0x1d5074,_0x52cd3c){const _0x168ced=_0x45d586,_0x3840bf=_0x168ced(0xab7)['format'](_0x1d5074);VisuMZ['BattleCore']['JS'][_0x52cd3c]=new Function(_0x3840bf);},VisuMZ['BattleCore'][_0x45d586(0x62d)]=function(_0x52fae7,_0x3468f8){const _0x1a0d07=_0x45d586,_0x68dc4=_0x52fae7['note'];if(_0x68dc4['match'](VisuMZ[_0x1a0d07(0x6fe)][_0x1a0d07(0xa98)][_0x3468f8])){const _0x215812=RegExp['$1'],_0x1b1acf=_0x1a0d07(0x14e)[_0x1a0d07(0x534)](_0x215812),_0x10a9bb=VisuMZ[_0x1a0d07(0x6fe)][_0x1a0d07(0x2f1)](_0x52fae7,_0x3468f8);VisuMZ[_0x1a0d07(0x6fe)]['JS'][_0x10a9bb]=new Function(_0x1b1acf);}},VisuMZ['BattleCore'][_0x45d586(0x41c)]=function(_0x4f0038){const _0x5bb441=_0x45d586;_0x4f0038[_0x5bb441(0x30c)]='-';const _0x561f41=_0x4f0038[_0x5bb441(0x34a)];_0x561f41[_0x5bb441(0x95f)](/<(?:HELP|HELP DESCRIPTION|DESCRIPTION)>\s*([\s\S]*)\s*<\/(?:HELP|HELP DESCRIPTION|DESCRIPTION)>/i)&&(_0x4f0038[_0x5bb441(0x30c)]=String(RegExp['$1'])[_0x5bb441(0x379)]()),_0x561f41['match'](/<(?:IN-BATTLE |)STATUS DESCRIPTION>\s*([\s\S]*)\s*<\/(?:IN-BATTLE |)STATUS DESCRIPTION>/i)&&(_0x4f0038['statusDescription']=String(RegExp['$1'])[_0x5bb441(0x379)]()),_0x561f41['match'](/<EXCLUDE FROM (?:HELP|STATUS|STATUS LIST|LISTING)>/i)&&(_0x4f0038[_0x5bb441(0xa11)]=!![]);},TextManager[_0x45d586(0xbdc)]=VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xa41)][_0x45d586(0x6f3)][_0x45d586(0x200)],TextManager[_0x45d586(0x25c)]=VisuMZ[_0x45d586(0x6fe)]['Settings']['AutoBattle'][_0x45d586(0xa38)],TextManager[_0x45d586(0xa34)]=VisuMZ['BattleCore'][_0x45d586(0xa41)][_0x45d586(0x2cb)][_0x45d586(0xa7c)],TextManager['visualHpGauge']=VisuMZ['BattleCore'][_0x45d586(0xa41)][_0x45d586(0x518)][_0x45d586(0x519)],ColorManager[_0x45d586(0xb9c)]=function(_0x4e3c28){const _0x289ddf=_0x45d586;return _0x4e3c28=String(_0x4e3c28),_0x4e3c28[_0x289ddf(0x95f)](/#(.*)/i)?_0x289ddf(0xa95)['format'](String(RegExp['$1'])):this[_0x289ddf(0x614)](Number(_0x4e3c28));},DataManager[_0x45d586(0x64e)]=function(_0x2e52be){const _0x4b37b5=_0x45d586;if(_0x2e52be['note']['match'](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x1d3bf5=String(RegExp['$1'])[_0x4b37b5(0x689)]()[_0x4b37b5(0x379)]();if(_0x1d3bf5===_0x4b37b5(0x5e1))return _0x4b37b5(0x5e1);if(VisuMZ[_0x4b37b5(0x58f)][_0x1d3bf5])return _0x1d3bf5;}const _0x3ee288=VisuMZ[_0x4b37b5(0x6fe)]['Settings'][_0x4b37b5(0x244)]['DefaultDamageStyle']['toUpperCase']()[_0x4b37b5(0x379)]();if(VisuMZ[_0x4b37b5(0x58f)][_0x3ee288])return _0x3ee288;return _0x4b37b5(0x5e1);},DataManager[_0x45d586(0x1b0)]=function(_0x59a417){const _0x10f872=_0x45d586;_0x59a417=_0x59a417[_0x10f872(0x689)]()[_0x10f872(0x379)](),this[_0x10f872(0x393)]=this[_0x10f872(0x393)]||{};if(this['_stypeIDs'][_0x59a417])return this['_stypeIDs'][_0x59a417];for(let _0x59ebb0=0x1;_0x59ebb0<0x64;_0x59ebb0++){if(!$dataSystem[_0x10f872(0xbcb)][_0x59ebb0])continue;let _0x100a76=$dataSystem['skillTypes'][_0x59ebb0][_0x10f872(0x689)]()[_0x10f872(0x379)]();_0x100a76=_0x100a76[_0x10f872(0x646)](/\x1I\[(\d+)\]/gi,''),_0x100a76=_0x100a76[_0x10f872(0x646)](/\\I\[(\d+)\]/gi,''),this['_stypeIDs'][_0x100a76]=_0x59ebb0;}return this[_0x10f872(0x393)][_0x59a417]||0x0;},DataManager[_0x45d586(0x184)]=function(_0x308614){const _0x4dcc05=_0x45d586;_0x308614=_0x308614[_0x4dcc05(0x689)]()['trim'](),this[_0x4dcc05(0x547)]=this['_skillIDs']||{};if(this['_skillIDs'][_0x308614])return this[_0x4dcc05(0x547)][_0x308614];for(const _0x37813a of $dataSkills){if(!_0x37813a)continue;this[_0x4dcc05(0x547)][_0x37813a['name'][_0x4dcc05(0x689)]()['trim']()]=_0x37813a['id'];}return this[_0x4dcc05(0x547)][_0x308614]||0x0;},DataManager[_0x45d586(0x316)]=function(_0x31e890){const _0x5e379c=_0x45d586;_0x31e890=_0x31e890[_0x5e379c(0x689)]()['trim'](),this[_0x5e379c(0x520)]=this['_enemyIDs']||{};if(this[_0x5e379c(0x520)][_0x31e890])return this[_0x5e379c(0x520)][_0x31e890];for(const _0x40451d of $dataEnemies){if(!_0x40451d)continue;this['_enemyIDs'][_0x40451d[_0x5e379c(0x5c2)][_0x5e379c(0x689)]()['trim']()]=_0x40451d['id'];}return this[_0x5e379c(0x520)][_0x31e890]||0x0;},DataManager[_0x45d586(0xadf)]=function(_0x13a1f1){const _0x2d164d=_0x45d586;_0x13a1f1=_0x13a1f1['toUpperCase']()['trim'](),this[_0x2d164d(0x2f0)]=this[_0x2d164d(0x2f0)]||{};if(this[_0x2d164d(0x2f0)][_0x13a1f1])return this['_wtypeIDs'][_0x13a1f1];for(let _0x3b054d=0x1;_0x3b054d<0x64;_0x3b054d++){if(!$dataSystem[_0x2d164d(0x141)][_0x3b054d])continue;let _0x10e11e=$dataSystem[_0x2d164d(0x141)][_0x3b054d][_0x2d164d(0x689)]()[_0x2d164d(0x379)]();_0x10e11e=_0x10e11e['replace'](/\x1I\[(\d+)\]/gi,''),_0x10e11e=_0x10e11e[_0x2d164d(0x646)](/\\I\[(\d+)\]/gi,''),this[_0x2d164d(0x2f0)][_0x10e11e]=_0x3b054d;}return this[_0x2d164d(0x2f0)][_0x2d164d(0x204)]=0x0,this[_0x2d164d(0x2f0)][_0x13a1f1]||0x0;},DataManager[_0x45d586(0x4e1)]=function(_0x3f74a8){const _0x3b7ea9=_0x45d586,_0x8490a4=_0x3b7ea9(0x4cc);let _0x277dc2=_0x3f74a8[_0x3b7ea9(0x49b)],_0x330eb6=_0x3f74a8[_0x3b7ea9(0x5c2)];const _0x433f0a=_0x3f74a8[_0x3b7ea9(0x34a)];return _0x433f0a['match'](/<DISPLAY ICON: (\d+)>/i)&&(_0x277dc2=Number(RegExp['$1'])),_0x433f0a[_0x3b7ea9(0x95f)](/<DISPLAY TEXT: (.*)>/i)&&(_0x330eb6=String(RegExp['$1'])),_0x8490a4[_0x3b7ea9(0x534)](_0x277dc2,_0x330eb6);},DataManager[_0x45d586(0x742)]=function(_0x44553f){const _0x3de1b0=_0x45d586;return _0x44553f['note'][_0x3de1b0(0x95f)](/<COMMAND TEXT: (.*)>/i)?String(RegExp['$1']):_0x44553f[_0x3de1b0(0x5c2)];},DataManager[_0x45d586(0x721)]=function(_0x3201be){const _0x4bdec5=_0x45d586;return _0x3201be[_0x4bdec5(0x34a)]['match'](/<COMMAND ICON: (\d+)>/i)?Number(RegExp['$1']):_0x3201be[_0x4bdec5(0x49b)];},DataManager['swapEnemyIDs']=function(_0x4415ac){const _0x2e4465=_0x45d586,_0x49b66c=$dataEnemies[_0x4415ac];if(_0x49b66c){if(_0x49b66c['note'][_0x2e4465(0x95f)](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){const _0x56ca86=String(RegExp['$1'])[_0x2e4465(0xaea)](/[\r\n]+/)[_0x2e4465(0x4e7)](''),_0x14937a=this[_0x2e4465(0xa3d)](_0x56ca86);_0x4415ac=this[_0x2e4465(0x316)](_0x14937a)||_0x4415ac,_0x4415ac=DataManager[_0x2e4465(0x1d6)](_0x4415ac);}}return _0x4415ac;},DataManager['processRandomizedData']=function(_0x417986){const _0x17ea85=_0x45d586;let _0x5ef351=0x0;const _0x4a02ea={};for(const _0x326797 of _0x417986){if(_0x326797[_0x17ea85(0x95f)](/(.*):[ ](\d+)/i)){const _0x22ee49=String(RegExp['$1'])['trim'](),_0x3abfd1=Number(RegExp['$2']);_0x4a02ea[_0x22ee49]=_0x3abfd1,_0x5ef351+=_0x3abfd1;}else{if(_0x326797['match'](/(.*):[ ](\d+\.?\d+)/i)){const _0x5f51bd=String(RegExp['$1'])[_0x17ea85(0x379)](),_0x454ab9=Number(RegExp['$2']);_0x4a02ea[_0x5f51bd]=_0x454ab9,_0x5ef351+=_0x454ab9;}else _0x326797!==''&&(_0x4a02ea[_0x326797]=0x1,_0x5ef351++);}}if(_0x5ef351<=0x0)return'';let _0x4fe4c4=Math['random']()*_0x5ef351;for(const _0x458b1 in _0x4a02ea){_0x4fe4c4-=_0x4a02ea[_0x458b1];if(_0x4fe4c4<=0x0)return _0x458b1;}return'';},DataManager['checkAutoCustomActionSequenceNotetagEffect']=function(_0x45f04c){const _0x471b33=_0x45d586;if(!_0x45f04c)return![];if(!VisuMZ[_0x471b33(0x6fe)]['Settings'][_0x471b33(0x205)]['AutoNotetag'])return![];if(_0x45f04c[_0x471b33(0x34a)][_0x471b33(0x95f)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x45f04c[_0x471b33(0x34a)]['match'](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x5513f2 of _0x45f04c['effects']){if(!_0x5513f2)continue;if(_0x5513f2[_0x471b33(0xa27)]===Game_Action[_0x471b33(0x5e3)])return!![];}return![];},DataManager['createTroopNote']=function(_0x3db84f){const _0x5a59a7=_0x45d586,_0x4959ad=$dataTroops[_0x3db84f];if(!_0x4959ad)return'';let _0x13f9eb='';_0x13f9eb+=_0x4959ad[_0x5a59a7(0x5c2)];for(const _0x3f7c46 of _0x4959ad['pages']){for(const _0x5d01a0 of _0x3f7c46[_0x5a59a7(0x505)]){[0x6c,0x198][_0x5a59a7(0x840)](_0x5d01a0[_0x5a59a7(0xa27)])&&(_0x13f9eb+='\x0a',_0x13f9eb+=_0x5d01a0[_0x5a59a7(0x8e0)][0x0]);}}return _0x13f9eb;},ConfigManager[_0x45d586(0xa29)]=ConfigManager[_0x45d586(0xa29)]??![],ConfigManager[_0x45d586(0x92c)]=ConfigManager[_0x45d586(0x92c)]??![],ConfigManager['visualHpGauge']=ConfigManager[_0x45d586(0xb83)]??!![],VisuMZ[_0x45d586(0x6fe)]['ConfigManager_makeData']=ConfigManager[_0x45d586(0x554)],ConfigManager[_0x45d586(0x554)]=function(){const _0x257a91=_0x45d586,_0x415684=VisuMZ[_0x257a91(0x6fe)][_0x257a91(0x684)]['call'](this);return _0x415684[_0x257a91(0xa29)]=this[_0x257a91(0xa29)],_0x415684[_0x257a91(0x92c)]=this['autoBattleUseSkills'],_0x415684[_0x257a91(0xb83)]=this['visualHpGauge'],_0x415684;},VisuMZ['BattleCore']['ConfigManager_applyData']=ConfigManager[_0x45d586(0x820)],ConfigManager[_0x45d586(0x820)]=function(_0x4bd142){const _0x451210=_0x45d586;VisuMZ[_0x451210(0x6fe)]['ConfigManager_applyData'][_0x451210(0x1b5)](this,_0x4bd142),_0x451210(0xa29)in _0x4bd142?this[_0x451210(0xa29)]=_0x4bd142['autoBattleAtStart']:this[_0x451210(0xa29)]=![],_0x451210(0x92c)in _0x4bd142?this[_0x451210(0x92c)]=_0x4bd142[_0x451210(0x92c)]:this[_0x451210(0x92c)]=![],_0x451210(0xb83)in _0x4bd142?this[_0x451210(0xb83)]=_0x4bd142['visualHpGauge']:this[_0x451210(0xb83)]=!![];},ImageManager['svActorHorzCells']=ImageManager[_0x45d586(0x280)]||0x9,ImageManager[_0x45d586(0x398)]=ImageManager['svActorVertCells']||0x6,VisuMZ[_0x45d586(0x6fe)]['BattleManager_setup']=BattleManager[_0x45d586(0x846)],BattleManager['setup']=function(_0x3db836,_0x458d66,_0x184882){const _0x2b367f=_0x45d586;VisuMZ[_0x2b367f(0x6fe)][_0x2b367f(0x2c1)]['call'](this,_0x3db836,_0x458d66,_0x184882),this[_0x2b367f(0xa8c)]={};},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x4c8)]=BattleManager[_0x45d586(0x2fc)],BattleManager['initMembers']=function(){const _0x480971=_0x45d586;VisuMZ[_0x480971(0x6fe)]['BattleManager_initMembers'][_0x480971(0x1b5)](this),this['_forcedBattlers']=[];},BattleManager[_0x45d586(0xb6a)]=function(){const _0x28ed1b=_0x45d586;if(!SceneManager[_0x28ed1b(0x81a)]())return;const _0x5a682a=SceneManager[_0x28ed1b(0x4f4)][_0x28ed1b(0x3c5)];if(_0x5a682a)_0x5a682a[_0x28ed1b(0x6d2)]();},BattleManager[_0x45d586(0x319)]=function(){const _0x511dcf=_0x45d586;if(BattleManager[_0x511dcf(0xad9)]())return _0x511dcf(0x442);return _0x511dcf(0x8e5);},BattleManager[_0x45d586(0x75a)]=function(_0x142dec){const _0x4187f2=_0x45d586;return _0x142dec=_0x142dec[_0x4187f2(0x689)]()['trim'](),this[_0x4187f2(0x319)]()===_0x142dec;},BattleManager[_0x45d586(0x4fe)]=function(){const _0x3438da=_0x45d586;return this[_0x3438da(0x75a)](_0x3438da(0x8e5));},BattleManager[_0x45d586(0x550)]=function(){const _0x9dfdc2=_0x45d586;return this[_0x9dfdc2(0x4fe)]();},BattleManager[_0x45d586(0x85f)]=function(){const _0x269348=_0x45d586;return!this[_0x269348(0x550)]();},BattleManager[_0x45d586(0xa79)]=function(){const _0x1e4e7b=_0x45d586;return!this['isTurnBased']()&&!this[_0x1e4e7b(0x85f)]();},BattleManager[_0x45d586(0x5dc)]=function(_0x4c5754){const _0x2a039a=_0x45d586;this[_0x2a039a(0xa8c)]=this[_0x2a039a(0xa8c)]||{};if(this[_0x2a039a(0xa8c)][_0x4c5754]!==undefined)return this[_0x2a039a(0xa8c)][_0x4c5754];this['_battlerKeyCache'][_0x4c5754]=null;const _0x82b67c=this[_0x2a039a(0x488)](),_0x41b32b=_0x82b67c['find'](_0x55c06a=>_0x55c06a[_0x2a039a(0x8da)]()===_0x4c5754);if(_0x41b32b)this[_0x2a039a(0xa8c)][_0x4c5754]=_0x41b32b;return this[_0x2a039a(0xa8c)][_0x4c5754];},Game_BattlerBase['prototype']['battlerKey']=function(){const _0x320895=_0x45d586;return _0x320895(0x2b0)[_0x320895(0x534)](this['isActor']()?_0x320895(0xb77):_0x320895(0x6bc),this[_0x320895(0x5c2)]()+'-'+(this[_0x320895(0x7f0)]()?this[_0x320895(0x533)]():this[_0x320895(0x302)]()));},Game_Action[_0x45d586(0x19f)][_0x45d586(0x1c4)]=function(_0x10b5b7){const _0xa28ed0=_0x45d586;if(this[_0xa28ed0(0x1cf)]!=='')return;typeof _0x10b5b7==='string'?this[_0xa28ed0(0x1cf)]=_0x10b5b7[_0xa28ed0(0x2ab)]()['trim']():this[_0xa28ed0(0x1cf)]=_0x10b5b7[_0xa28ed0(0x8da)]();},Game_Action['prototype'][_0x45d586(0x5f5)]=function(){const _0x236d95=_0x45d586;return[this[_0x236d95(0x20a)]()];},Game_Action['prototype'][_0x45d586(0x20a)]=function(){const _0x1e3f3a=_0x45d586,_0x356616=this[_0x1e3f3a(0x1cf)]||'',_0x3e5c0b=BattleManager[_0x1e3f3a(0x5dc)](_0x356616);if(!_0x3e5c0b)return this[_0x1e3f3a(0x824)]();if(!_0x3e5c0b[_0x1e3f3a(0x45d)]())return this[_0x1e3f3a(0x824)]();return _0x3e5c0b;},Game_Action['prototype'][_0x45d586(0x824)]=function(){const _0x4eec52=_0x45d586,_0x8ee42a=this[_0x4eec52(0x1cf)];return _0x8ee42a[_0x4eec52(0x95f)](/ACTOR/i)?this[_0x4eec52(0x904)]()[_0x4eec52(0x6be)]():this[_0x4eec52(0x276)]()['trueRandomTarget']();},BattleManager[_0x45d586(0x4ff)]=function(){const _0x4da43a=_0x45d586;return this[_0x4da43a(0x488)]()['filter'](_0x4a4c50=>_0x4a4c50[_0x4da43a(0x5bc)]());},BattleManager[_0x45d586(0x6f4)]=function(_0x22ab9d){const _0x3f7895=_0x45d586;_0x22ab9d===_0x3f7895(0x440)&&(this[_0x3f7895(0xba4)]=!![]),$gameParty[_0x3f7895(0x6f4)](_0x22ab9d),$gameTroop['processBattleCoreJS'](_0x22ab9d);},VisuMZ['BattleCore'][_0x45d586(0x5b3)]=BattleManager['startBattle'],BattleManager['startBattle']=function(){const _0x24d8a8=_0x45d586;this[_0x24d8a8(0x27c)]=![],this[_0x24d8a8(0xa4b)]=ConfigManager['autoBattleAtStart'],this[_0x24d8a8(0xba4)]=![],this[_0x24d8a8(0x6f4)](_0x24d8a8(0xaa9)),VisuMZ[_0x24d8a8(0x6fe)][_0x24d8a8(0x5b3)]['call'](this),this[_0x24d8a8(0x6f4)]('PostStartBattleJS');},BattleManager[_0x45d586(0x16d)]=function(_0x5e4b73){const _0x544af3=_0x45d586,_0x538aa2=VisuMZ[_0x544af3(0x6fe)][_0x544af3(0xa41)][_0x544af3(0x4c4)];_0x5e4b73!==_0x544af3(0x425)&&_0x538aa2[_0x544af3(0x248)]&&VisuMZ['BattleCore'][_0x544af3(0x508)](_0x538aa2[_0x544af3(0x248)])&&$gameTemp['reserveCommonEvent'](_0x538aa2[_0x544af3(0x248)]);const _0x22a4aa=_0x544af3(0x7d0)['format'](_0x5e4b73);_0x538aa2[_0x22a4aa]&&VisuMZ['BattleCore']['CheckMapBattleEventValid'](_0x538aa2[_0x22a4aa])&&$gameTemp[_0x544af3(0x485)](_0x538aa2[_0x22a4aa]);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x6f8)]=BattleManager[_0x45d586(0x83f)],BattleManager[_0x45d586(0x83f)]=function(){const _0x47657f=_0x45d586;VisuMZ[_0x47657f(0x6fe)][_0x47657f(0x6f8)]['call'](this),SceneManager['isSceneBattle']()&&BattleManager['updateEvent']();},VisuMZ['BattleCore'][_0x45d586(0x2cf)]=BattleManager[_0x45d586(0xb2a)],BattleManager[_0x45d586(0xb2a)]=function(){const _0x5a6cf2=_0x45d586;if(this[_0x5a6cf2(0x5ca)]===_0x5a6cf2(0x345)){if($gameTemp['isCommonEventReserved']())return![];}return VisuMZ['BattleCore'][_0x5a6cf2(0x2cf)]['call'](this);},VisuMZ['BattleCore'][_0x45d586(0x6ec)]=BattleManager[_0x45d586(0xa22)],BattleManager[_0x45d586(0xa22)]=function(){const _0x1d89a4=_0x45d586;this[_0x1d89a4(0xba4)]=!![],this[_0x1d89a4(0x6f4)](_0x1d89a4(0x440)),VisuMZ['BattleCore']['BattleManager_processVictory'][_0x1d89a4(0x1b5)](this),this['processPostBattleCommonEvents']('Victory');},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x303)]=BattleManager[_0x45d586(0x491)],BattleManager[_0x45d586(0x491)]=function(){const _0x2384cf=_0x45d586;this[_0x2384cf(0xba4)]=!![],VisuMZ[_0x2384cf(0x6fe)][_0x2384cf(0x303)]['call'](this);},VisuMZ[_0x45d586(0x6fe)]['BattleManager_processDefeat']=BattleManager[_0x45d586(0x7b6)],BattleManager['processDefeat']=function(){const _0x3640b0=_0x45d586;this[_0x3640b0(0xba4)]=!![],this['processBattleCoreJS']('BattleDefeatJS'),VisuMZ[_0x3640b0(0x6fe)]['BattleManager_processDefeat'][_0x3640b0(0x1b5)](this),this[_0x3640b0(0x16d)](_0x3640b0(0x49c));},VisuMZ['BattleCore'][_0x45d586(0x454)]=BattleManager[_0x45d586(0x561)],BattleManager[_0x45d586(0x561)]=function(_0x4ef940){const _0x3d6f58=_0x45d586;this[_0x3d6f58(0x27c)]=!![],this['_autoBattle']=![],this['processBattleCoreJS'](_0x3d6f58(0x768)),VisuMZ[_0x3d6f58(0x6fe)][_0x3d6f58(0x454)][_0x3d6f58(0x1b5)](this,_0x4ef940),this['processBattleCoreJS'](_0x3d6f58(0x932));},VisuMZ['BattleCore'][_0x45d586(0x745)]=BattleManager[_0x45d586(0x74e)],BattleManager[_0x45d586(0x74e)]=function(){const _0x33eedc=_0x45d586;if(this[_0x33eedc(0x550)]())this['processBattleCoreJS'](_0x33eedc(0x1bb));VisuMZ[_0x33eedc(0x6fe)]['BattleManager_startTurn']['call'](this);if(this[_0x33eedc(0x550)]())this[_0x33eedc(0x6f4)]('PostStartTurnJS');},BattleManager['processTurn']=function(){const _0x298db7=_0x45d586,_0x5c17f2=this[_0x298db7(0x1ce)],_0x147b5e=_0x5c17f2[_0x298db7(0x74c)]();_0x147b5e?(_0x147b5e[_0x298db7(0x726)](),_0x147b5e[_0x298db7(0x7ce)]()?(this[_0x298db7(0x133)](),_0x5c17f2['removeCurrentAction']()):(_0x5c17f2[_0x298db7(0x9c1)](),this[_0x298db7(0xa59)]())):(this['endAction'](),this['_subject']=null);},VisuMZ['BattleCore']['BattleManager_startAction']=BattleManager['startAction'],BattleManager['startAction']=function(){const _0x147e83=_0x45d586,_0x4dbab0=this[_0x147e83(0x1ce)][_0x147e83(0x74c)](),_0x3605c4=this[_0x147e83(0x1ce)];_0x4dbab0&&_0x4dbab0[_0x147e83(0x3ac)]()===_0x3605c4&&_0x4dbab0[_0x147e83(0x707)]('PreStartActionJS'),VisuMZ['BattleCore']['BattleManager_startAction']['call'](this),_0x4dbab0&&_0x4dbab0[_0x147e83(0x3ac)]()===_0x3605c4&&_0x4dbab0[_0x147e83(0x707)](_0x147e83(0x581));},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x294)]=BattleManager[_0x45d586(0xa59)],BattleManager['endAction']=function(){const _0x21cc61=_0x45d586,_0x4c0288=this[_0x21cc61(0x9e9)],_0x8e9603=this['_subject'];_0x4c0288&&_0x4c0288!==this[_0x21cc61(0x333)]&&_0x4c0288[_0x21cc61(0x3ac)]()===_0x8e9603&&_0x4c0288[_0x21cc61(0x707)](_0x21cc61(0xaf1)),this[_0x21cc61(0x1ce)]?VisuMZ['BattleCore']['BattleManager_endAction'][_0x21cc61(0x1b5)](this):this[_0x21cc61(0x5ca)]=_0x21cc61(0x345),_0x4c0288&&_0x4c0288!==this[_0x21cc61(0x333)]&&_0x4c0288['subject']()===_0x8e9603&&_0x4c0288[_0x21cc61(0x707)]('PostEndActionJS'),this[_0x21cc61(0x284)](this['allBattleMembers']()),this[_0x21cc61(0x333)]=this[_0x21cc61(0x9e9)];},BattleManager['refreshBattlerMotions']=function(_0x2666ae){const _0x4c0ec1=_0x45d586;for(const _0x18bd90 of _0x2666ae){if(!_0x18bd90)continue;if(!_0x18bd90[_0x4c0ec1(0xa7b)]())continue;_0x18bd90[_0x4c0ec1(0xa7b)]()['refreshMotion']();}},BattleManager[_0x45d586(0x344)]=function(){const _0x5f3d16=_0x45d586;!this[_0x5f3d16(0x936)][_0x5f3d16(0x3d8)]()&&this[_0x5f3d16(0xa59)]();},Game_Battler['prototype']['onAllActionsEnd']=function(){const _0x4f12a1=_0x45d586;this[_0x4f12a1(0x893)]();if(Imported['VisuMZ_1_SkillsStatesCore']){const _0x33d898=VisuMZ[_0x4f12a1(0x621)][_0x4f12a1(0xa41)][_0x4f12a1(0x489)];_0x33d898&&_0x33d898[_0x4f12a1(0x22d)]===![]&&this['removeStatesAuto'](0x1);}else this['removeStatesAuto'](0x1);this[_0x4f12a1(0x44d)]();},VisuMZ['BattleCore'][_0x45d586(0x3a7)]=BattleManager[_0x45d586(0x3c6)],BattleManager[_0x45d586(0x3c6)]=function(_0x1d8939,_0x30be3f){const _0x3f0bd7=_0x45d586;this['_bypassCanCounterCheck']=!![],VisuMZ[_0x3f0bd7(0x6fe)][_0x3f0bd7(0x3a7)][_0x3f0bd7(0x1b5)](this,_0x1d8939,_0x30be3f),this['_bypassCanCounterCheck']=undefined;},BattleManager['makeEscapeRatio']=function(){const _0x222ae3=_0x45d586;this['_escapeRatio']=VisuMZ[_0x222ae3(0x6fe)][_0x222ae3(0xa41)][_0x222ae3(0x4c4)]['CalcEscapeRatioJS'][_0x222ae3(0x1b5)](this);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xa31)]=BattleManager[_0x45d586(0x47e)],BattleManager[_0x45d586(0x47e)]=function(){const _0x6b52ab=_0x45d586;this['processBattleCoreJS'](_0x6b52ab(0x46e)),BattleManager[_0x6b52ab(0x992)][_0x6b52ab(0x579)](),VisuMZ['BattleCore'][_0x6b52ab(0xa31)]['call'](this),this[_0x6b52ab(0x16d)](_0x6b52ab(0x484));},VisuMZ['BattleCore'][_0x45d586(0x9f3)]=BattleManager[_0x45d586(0x16c)],BattleManager[_0x45d586(0x16c)]=function(){const _0x338e10=_0x45d586;this[_0x338e10(0x6f4)](_0x338e10(0xaa3));const _0x5e36d9=this[_0x338e10(0x64b)];VisuMZ[_0x338e10(0x6fe)][_0x338e10(0x9f3)]['call'](this),this[_0x338e10(0x64b)]=_0x5e36d9+VisuMZ['BattleCore'][_0x338e10(0xa41)][_0x338e10(0x4c4)][_0x338e10(0x97e)]['call'](this),this['_inputting']=![],this[_0x338e10(0x16d)](_0x338e10(0x425));},BattleManager['displayStartMessages']=function(){const _0x5dcd9e=_0x45d586;let _0x2ab699=![];if(this['isDisplayEmergedEnemies']())for(const _0x3b5fda of $gameTroop[_0x5dcd9e(0x149)]()){this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)](_0x5dcd9e(0x53b),TextManager[_0x5dcd9e(0x247)]['format'](_0x3b5fda)),this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)](_0x5dcd9e(0x643)),_0x2ab699=!![];}if(this[_0x5dcd9e(0x1c1)])this['_logWindow'][_0x5dcd9e(0x119)](_0x5dcd9e(0x53b),TextManager[_0x5dcd9e(0x976)]['format']($gameParty['name']())),this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)]('wait');else this['_surprise']&&(this[_0x5dcd9e(0x936)]['push']('addText',TextManager[_0x5dcd9e(0x413)]['format']($gameParty[_0x5dcd9e(0x5c2)]())),this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)](_0x5dcd9e(0x643)));_0x2ab699&&(this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)](_0x5dcd9e(0x643)),this[_0x5dcd9e(0x936)][_0x5dcd9e(0x119)](_0x5dcd9e(0xb8d))),this['isTpb']()&&this[_0x5dcd9e(0x86d)]()&&(this[_0x5dcd9e(0x61c)]=![]);},BattleManager['isDisplayEmergedEnemies']=function(){const _0x157268=_0x45d586;if(BattleManager[_0x157268(0xa4b)])return![];return VisuMZ[_0x157268(0x6fe)][_0x157268(0xa41)][_0x157268(0x401)][_0x157268(0x4fa)];},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x50a)]=BattleManager['startInput'],BattleManager[_0x45d586(0xba6)]=function(){const _0x266066=_0x45d586;VisuMZ['BattleCore'][_0x266066(0x50a)][_0x266066(0x1b5)](this),this[_0x266066(0x4fe)]()&&this[_0x266066(0x86d)]()&&!this['_surprise']&&$gameParty['canInput']()&&this[_0x266066(0xb88)]();},BattleManager['isSkipPartyCommandWindow']=function(){const _0x1dc3e7=_0x45d586;return VisuMZ[_0x1dc3e7(0x6fe)][_0x1dc3e7(0xa41)][_0x1dc3e7(0x6f3)]['SkipPartyCmd'];},BattleManager['checkTpbInputOpen']=function(){const _0x759f7c=_0x45d586;this[_0x759f7c(0x5cf)]()&&this[_0x759f7c(0xb88)]();},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x95b)]=Scene_Battle['prototype'][_0x45d586(0x264)],Scene_Battle[_0x45d586(0x19f)][_0x45d586(0x264)]=function(){const _0x3d6040=_0x45d586;VisuMZ[_0x3d6040(0x6fe)][_0x3d6040(0x95b)][_0x3d6040(0x1b5)](this),BattleManager[_0x3d6040(0xad9)]()&&BattleManager[_0x3d6040(0x61c)]&&(BattleManager[_0x3d6040(0x61c)]=![],this[_0x3d6040(0xb6b)]());},BattleManager[_0x45d586(0x6bd)]=function(_0x2f6155,_0x51daf8,_0x2bf0d2){const _0x336a4c=_0x45d586;if(!_0x2bf0d2)return;if(!_0x2f6155)return;if(!_0x51daf8)return;const _0x2d099d=this['_action'];this[_0x336a4c(0x9e9)]=new Game_Action(_0x2f6155);if(DataManager[_0x336a4c(0x1c8)](_0x2bf0d2))this[_0x336a4c(0x9e9)][_0x336a4c(0x778)](_0x2bf0d2['id']);if(DataManager[_0x336a4c(0xb36)](_0x2bf0d2))this[_0x336a4c(0x9e9)][_0x336a4c(0x839)](_0x2bf0d2['id']);if(this[_0x336a4c(0x9e9)][_0x336a4c(0xba9)]())BattleManager[_0x336a4c(0x38c)](_0x2f6155,_0x51daf8);this[_0x336a4c(0x9e9)]=_0x2d099d;},BattleManager[_0x45d586(0xa24)]=function(_0x15245d,_0x5c35b2){const _0x5b19ca=_0x45d586;this[_0x5b19ca(0x9e9)][_0x5b19ca(0x4ce)]=_0x5c35b2,this['_logWindow']['displayReflection'](_0x5c35b2),this[_0x5b19ca(0x936)][_0x5b19ca(0x705)](_0x15245d,this['_action']),this[_0x5b19ca(0x9e9)][_0x5b19ca(0x6f1)](_0x15245d),this['_logWindow'][_0x5b19ca(0x512)](_0x15245d,_0x15245d);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x35d)]=BattleManager['makeActionOrders'],BattleManager['makeActionOrders']=function(){const _0x3d300a=_0x45d586;VisuMZ[_0x3d300a(0x6fe)]['BattleManager_makeActionOrders'][_0x3d300a(0x1b5)](this),this['_actionBattlers']=this[_0x3d300a(0xbc0)][_0x3d300a(0x229)](_0x5071b9=>_0x5071b9&&_0x5071b9[_0x3d300a(0x2bd)]());},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x2bc)]=BattleManager[_0x45d586(0xe9)],BattleManager[_0x45d586(0xe9)]=function(_0x2cf667){const _0x233842=_0x45d586;if(this[_0x233842(0x5ca)]===_0x233842(0x7b3))this[_0x233842(0x944)]();else this[_0x233842(0x5ca)]===_0x233842(0x66c)?this[_0x233842(0xce)]():VisuMZ[_0x233842(0x6fe)][_0x233842(0x2bc)][_0x233842(0x1b5)](this,_0x2cf667);},BattleManager['prepareCustomActionSequence']=function(){const _0x280f66=_0x45d586;this[_0x280f66(0x424)]=this[_0x280f66(0x708)][_0x280f66(0x25a)](0x0),this[_0x280f66(0x157)]=0x0,this[_0x280f66(0x798)]=this[_0x280f66(0x424)][0x0]||null,this[_0x280f66(0x5ca)]=_0x280f66(0x7b3);},BattleManager['updateCustomActionSequence']=function(){const _0x1001fc=_0x45d586;!this['updateEventMain']()&&!this[_0x1001fc(0x936)][_0x1001fc(0x3d8)]()&&(this[_0x1001fc(0x5ca)]=_0x1001fc(0xaf9));},BattleManager[_0x45d586(0x66c)]=function(_0x5b7442){const _0xd0fb78=_0x45d586;this[_0xd0fb78(0xbc0)][_0xd0fb78(0x4e7)](_0x5b7442);if(_0x5b7442===this['_subject'])return;const _0x5609c2=JsonEx[_0xd0fb78(0x9cc)](_0x5b7442[_0xd0fb78(0x74c)]());this[_0xd0fb78(0x99a)][_0xd0fb78(0x119)]([_0x5b7442,_0x5609c2]);},BattleManager[_0x45d586(0x807)]=function(){},BattleManager[_0x45d586(0x72d)]=function(){const _0x53bca8=_0x45d586;if(this['isTpb']())this[_0x53bca8(0x5ca)]='turn';else this[_0x53bca8(0x99a)][_0x53bca8(0x1c9)]>0x0?this[_0x53bca8(0x5ca)]=_0x53bca8(0x345):this['startInput']();},BattleManager[_0x45d586(0x6c3)]=function(){const _0x3c5508=_0x45d586,_0x1e2bd6=this[_0x3c5508(0x1ce)];_0x1e2bd6&&this[_0x3c5508(0xad9)]()&&_0x1e2bd6[_0x3c5508(0x4c2)](_0x3c5508(0x28a));for(;;){const _0x5c5b8b=this[_0x3c5508(0x9e4)]();if(!_0x5c5b8b)return null;if(_0x5c5b8b[_0x3c5508(0x77b)]()&&_0x5c5b8b[_0x3c5508(0x45d)]())return _0x5c5b8b;}},BattleManager['getNextSubjectFromPool']=function(){const _0x4b5164=_0x45d586;if(this['_forcedBattlers'][_0x4b5164(0x1c9)]>0x0){const _0x31c735=this[_0x4b5164(0x99a)][_0x4b5164(0x6b4)](),_0x2ffb3d=_0x31c735[0x0];return _0x2ffb3d['_actions']=_0x2ffb3d[_0x4b5164(0x55f)]||[],_0x2ffb3d[_0x4b5164(0x55f)][0x0]=_0x31c735[0x1],_0x2ffb3d;}else return this[_0x4b5164(0xbc0)]['shift']();},VisuMZ[_0x45d586(0x6fe)]['Game_Battler_forceAction']=Game_Battler[_0x45d586(0x19f)][_0x45d586(0x66c)],Game_Battler[_0x45d586(0x19f)][_0x45d586(0x66c)]=function(_0x7a0475,_0x20eac6){const _0x1ad222=_0x45d586;VisuMZ[_0x1ad222(0x6fe)][_0x1ad222(0x795)][_0x1ad222(0x1b5)](this,_0x7a0475,_0x20eac6),this[_0x1ad222(0x55f)][this[_0x1ad222(0x55f)][_0x1ad222(0x1c9)]-0x1][_0x1ad222(0xa87)]=!![];},Game_Interpreter[_0x45d586(0x19f)]['command339']=function(_0x395856){return this['iterateBattler'](_0x395856[0x0],_0x395856[0x1],_0x4342fa=>{const _0x30eb7f=_0x442c;!_0x4342fa['isDeathStateAffected']()&&(_0x4342fa[_0x30eb7f(0x66c)](_0x395856[0x2],_0x395856[0x3]),BattleManager[_0x30eb7f(0x66c)](_0x4342fa));}),!![];},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x894)]=Game_Battler['prototype']['makeSpeed'],Game_Battler[_0x45d586(0x19f)][_0x45d586(0x9d6)]=function(){const _0xca5ef9=_0x45d586;VisuMZ[_0xca5ef9(0x6fe)]['Game_Battler_makeSpeed'][_0xca5ef9(0x1b5)](this),this[_0xca5ef9(0x55f)]['length']<=0x0&&(this[_0xca5ef9(0x571)]=Number[_0xca5ef9(0x8dd)]);},BattleManager[_0x45d586(0xa68)]=function(){const _0x54de00=_0x45d586;if(VisuMZ[_0x54de00(0x6fe)][_0x54de00(0xa41)]['Damage'][_0x54de00(0x2da)]??!![])return![];return SceneManager['isSceneBattle']()&&this[_0x54de00(0xba4)];},VisuMZ[_0x45d586(0x6fe)]['BattleManager_selectNextCommand']=BattleManager[_0x45d586(0xb88)],BattleManager[_0x45d586(0xb88)]=function(){const _0x3d465e=_0x45d586;this['isTpb']()?this[_0x3d465e(0x19e)]():VisuMZ['BattleCore']['BattleManager_selectNextCommand'][_0x3d465e(0x1b5)](this);},BattleManager[_0x45d586(0x19e)]=function(){const _0x2ed39b=_0x45d586;if(this[_0x2ed39b(0x386)]){if(this[_0x2ed39b(0x386)][_0x2ed39b(0xb88)]())return;this[_0x2ed39b(0x5a9)](),this[_0x2ed39b(0x25b)](),!this[_0x2ed39b(0x1ce)]&&!this[_0x2ed39b(0x386)]&&SceneManager['_scene'][_0x2ed39b(0x5b1)]();}else!this['_subject']&&this[_0x2ed39b(0x339)]();},BattleManager[_0x45d586(0x25b)]=function(){const _0x76eba4=_0x45d586;(!this[_0x76eba4(0x5cf)]()||this[_0x76eba4(0x1f6)]())&&(this[_0x76eba4(0x59f)]&&(!$gameParty[_0x76eba4(0xb5c)]()[_0x76eba4(0x840)](this[_0x76eba4(0x59f)])&&(this['_tpbSceneChangeCacheActor']=null)),!this[_0x76eba4(0x59f)]?(this[_0x76eba4(0x6ea)](),this[_0x76eba4(0x386)]=null,this[_0x76eba4(0x7c4)]=![]):this[_0x76eba4(0x2e3)]());},BattleManager[_0x45d586(0x2e3)]=function(){const _0x28e7c1=_0x45d586;!$gameParty['battleMembers']()[_0x28e7c1(0x840)](this[_0x28e7c1(0x59f)])&&(this['_tpbSceneChangeCacheActor']=null),this[_0x28e7c1(0x59f)]?(this[_0x28e7c1(0x386)]=this[_0x28e7c1(0x59f)],this[_0x28e7c1(0x386)]['_tpbState']=_0x28e7c1(0x122),this[_0x28e7c1(0x7c4)]=!![],this[_0x28e7c1(0x59f)]=null):(this[_0x28e7c1(0x6ea)](),this[_0x28e7c1(0x386)]=null,this['_inputting']=![]);},VisuMZ['BattleCore'][_0x45d586(0x2c4)]=BattleManager[_0x45d586(0xa8a)],BattleManager[_0x45d586(0xa8a)]=function(){const _0x4df0c0=_0x45d586;return this['_phase']===_0x4df0c0(0x7b3)?this['battleCoreTpbMainPhase']():VisuMZ[_0x4df0c0(0x6fe)]['BattleManager_isTpbMainPhase'][_0x4df0c0(0x1b5)](this);},BattleManager['battleCoreTpbMainPhase']=function(){const _0x4dbe77=_0x45d586;return this[_0x4dbe77(0x971)]();},VisuMZ[_0x45d586(0x6fe)]['BattleManager_cancelActorInput']=BattleManager['cancelActorInput'],BattleManager[_0x45d586(0x6ea)]=function(){const _0x378a19=_0x45d586;this['isTpb']()&&this['_phase']===_0x378a19(0x8d4)&&(this[_0x378a19(0x386)]=null),VisuMZ['BattleCore'][_0x378a19(0x22f)][_0x378a19(0x1b5)](this);},VisuMZ[_0x45d586(0x6fe)]['BattleManager_inputtingAction']=BattleManager[_0x45d586(0x517)],BattleManager['inputtingAction']=function(){const _0xabb589=_0x45d586,_0x397f15=this[_0xabb589(0x386)];if(_0x397f15&&!_0x397f15[_0xabb589(0x517)]()){const _0x34d839=_0x397f15[_0xabb589(0x563)];_0x397f15['_actions'][_0x34d839]=new Game_Action(_0x397f15);}return VisuMZ['BattleCore'][_0xabb589(0x148)][_0xabb589(0x1b5)](this);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xf2)]=BattleManager[_0x45d586(0xb92)],BattleManager[_0x45d586(0xb92)]=function(_0x3b33c5){const _0x359bc3=_0x45d586;if(this[_0x359bc3(0x9e9)]['isForFriend']())return![];return VisuMZ[_0x359bc3(0x6fe)][_0x359bc3(0xf2)][_0x359bc3(0x1b5)](this,_0x3b33c5);},SceneManager[_0x45d586(0x81a)]=function(){const _0x859aa8=_0x45d586;return this[_0x859aa8(0x4f4)]&&this[_0x859aa8(0x4f4)][_0x859aa8(0xb62)]===Scene_Battle;},SceneManager[_0x45d586(0x8cd)]=function(){const _0xa7d711=_0x45d586;return Spriteset_Battle[_0xa7d711(0x19f)]['isFlipped']();},SceneManager[_0x45d586(0x55e)]=function(){const _0x4c6b1e=_0x45d586;if(SceneManager[_0x4c6b1e(0x3ca)](Scene_Options))return!![];return![];},SceneManager[_0x45d586(0x74a)]=function(){if(SceneManager['isNextScene'](Scene_Options))return!![];return![];},SceneManager[_0x45d586(0x81f)]=function(_0x21f13e){const _0x106e2e=_0x45d586;if(!SceneManager[_0x106e2e(0x81a)]())return!![];const _0x124839=[_0x106e2e(0x928),_0x106e2e(0x7e1),_0x106e2e(0x8af)];return _0x124839['includes'](_0x21f13e[_0x106e2e(0x5c2)]);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x3c1)]=SceneManager['push'],SceneManager[_0x45d586(0x119)]=function(_0x56baee){const _0x2d3c54=_0x45d586;if(!SceneManager[_0x2d3c54(0x81f)](_0x56baee))return this[_0x2d3c54(0x3df)](_0x56baee);VisuMZ[_0x2d3c54(0x6fe)][_0x2d3c54(0x3c1)][_0x2d3c54(0x1b5)](this,_0x56baee);},SceneManager[_0x45d586(0x3df)]=function(_0x4ab3d2){const _0x22949c=_0x45d586;if(!$gameTemp[_0x22949c(0x292)]())return;if(this[_0x22949c(0x7b2)])return;this[_0x22949c(0x7b2)]=!![];let _0x1e4ff5='';_0x1e4ff5+='VisuMZ_1_BattleCore\x20does\x20NOT\x20support\x20changing',_0x1e4ff5+='\x20to\x20%1\x20midbattle.'[_0x22949c(0x534)](_0x4ab3d2[_0x22949c(0x5c2)]),alert(_0x1e4ff5);},VisuMZ['BattleCore'][_0x45d586(0x2db)]=Game_Temp['prototype'][_0x45d586(0x6d1)],Game_Temp[_0x45d586(0x19f)][_0x45d586(0x6d1)]=function(){const _0x9ec9ac=_0x45d586;VisuMZ[_0x9ec9ac(0x6fe)]['Game_Temp_initialize'][_0x9ec9ac(0x1b5)](this),this[_0x9ec9ac(0x40f)]=[];},VisuMZ['BattleCore'][_0x45d586(0x8a5)]=Game_Temp['prototype'][_0x45d586(0x131)],Game_Temp[_0x45d586(0x19f)]['requestAnimation']=function(_0x1360f8,_0x3d5a29,_0x3a9ac7){const _0x1e8758=_0x45d586;_0x1360f8=_0x1360f8[_0x1e8758(0x229)]((_0x4f0004,_0x5f17d7,_0x58b3f5)=>_0x58b3f5[_0x1e8758(0xa63)](_0x4f0004)===_0x5f17d7);SceneManager[_0x1e8758(0x81a)]()&&SceneManager[_0x1e8758(0x8cd)]()&&(_0x3a9ac7=!_0x3a9ac7);VisuMZ[_0x1e8758(0x6fe)][_0x1e8758(0x8a5)]['call'](this,_0x1360f8,_0x3d5a29,_0x3a9ac7);SceneManager[_0x1e8758(0x81a)]()&&BattleManager[_0x1e8758(0x992)][_0x1e8758(0xa57)]();for(const _0x541f7a of _0x1360f8){_0x541f7a&&_0x541f7a[_0x1e8758(0x690)]&&_0x541f7a[_0x1e8758(0x690)]()&&_0x541f7a[_0x1e8758(0xb84)]();}},Game_Temp[_0x45d586(0x19f)]['setLastPluginCommandInterpreter']=function(_0x5922a7){const _0xd56cbd=_0x45d586;this[_0xd56cbd(0x9b2)]=_0x5922a7;},Game_Temp[_0x45d586(0x19f)][_0x45d586(0x421)]=function(){const _0x7c53c9=_0x45d586;return this[_0x7c53c9(0x9b2)];},Game_Temp['prototype'][_0x45d586(0x2e4)]=function(){this['_forcedBattleLayout']=undefined;},Game_Temp[_0x45d586(0x19f)]['applyForcedGameTroopSettingsBattleCore']=function(_0x1aa09a){const _0x1a991=_0x45d586;$gameMap&&$dataMap&&$dataMap[_0x1a991(0x34a)]&&this['parseForcedGameTroopSettingsBattleCore']($dataMap[_0x1a991(0x34a)]);const _0x4d9708=$dataTroops[_0x1aa09a];if(_0x4d9708){let _0x24f8e7=DataManager[_0x1a991(0x350)](_0x4d9708['id']);this[_0x1a991(0x86f)](_0x24f8e7);}},Game_Temp['prototype'][_0x45d586(0x86f)]=function(_0x31a8ce){const _0x5629fd=_0x45d586;if(!_0x31a8ce)return;if(_0x31a8ce['match'](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){const _0x5e40f0=String(RegExp['$1']);if(_0x5e40f0[_0x5629fd(0x95f)](/DEFAULT/i))this[_0x5629fd(0x4f0)]=_0x5629fd(0x915);else{if(_0x5e40f0[_0x5629fd(0x95f)](/LIST/i))this[_0x5629fd(0x4f0)]=_0x5629fd(0x505);else{if(_0x5e40f0[_0x5629fd(0x95f)](/XP/i))this['_forcedBattleLayout']='xp';else{if(_0x5e40f0['match'](/PORTRAIT/i))this[_0x5629fd(0x4f0)]=_0x5629fd(0x376);else{if(_0x5e40f0[_0x5629fd(0x95f)](/BORDER/i))this[_0x5629fd(0x4f0)]=_0x5629fd(0x70e);else{if(_0x5e40f0[_0x5629fd(0x95f)](/(?:SIDEVIEW UI|SIDEVIEW)/i))Imported[_0x5629fd(0x7b1)]?this[_0x5629fd(0x4f0)]=_0x5629fd(0x5d5):this['_forcedBattleLayout']='default';else _0x5e40f0['match'](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported[_0x5629fd(0xb8f)]?this['_forcedBattleLayout']=_0x5629fd(0x8d3):this['_forcedBattleLayout']='default');}}}}}}},VisuMZ['BattleCore'][_0x45d586(0xafb)]=Game_Temp[_0x45d586(0x19f)][_0x45d586(0xa20)],Game_Temp[_0x45d586(0x19f)][_0x45d586(0xa20)]=function(_0x6da11b,_0x5968d8){const _0x2a8b56=_0x45d586;SceneManager[_0x2a8b56(0x81a)]()?this[_0x2a8b56(0x226)](_0x6da11b,_0x5968d8):VisuMZ['BattleCore']['Game_Temp_requestBalloon']['call'](this,_0x6da11b,_0x5968d8);},Game_Temp['prototype'][_0x45d586(0x226)]=function(_0x464405,_0x37b953){const _0x5d5931=_0x45d586,_0x535e62={'target':_0x464405,'balloonId':_0x37b953};this[_0x5d5931(0x40f)]=this[_0x5d5931(0x40f)]||[],this[_0x5d5931(0x40f)][_0x5d5931(0x119)](_0x535e62);},Game_Temp['prototype']['retrieveBattleBalloon']=function(){const _0x4661e5=_0x45d586;return this[_0x4661e5(0x40f)]=this[_0x4661e5(0x40f)]||[],this[_0x4661e5(0x40f)]['shift']();},Game_Temp[_0x45d586(0x19f)]['clearBattleBalloons']=function(){this['_battleBalloonQueue']=[];},Spriteset_Battle[_0x45d586(0x19f)][_0x45d586(0xa77)]=function(){const _0x52e4df=_0x45d586;this[_0x52e4df(0x297)]===undefined&&(this[_0x52e4df(0x297)]=[]);for(const _0x5659b9 of this[_0x52e4df(0x297)]){!_0x5659b9[_0x52e4df(0x723)]()&&this[_0x52e4df(0x474)](_0x5659b9);}this['processBattleBalloonRequests']();},Spriteset_Battle[_0x45d586(0x19f)]['processBattleBalloonRequests']=function(){const _0x5c18b5=_0x45d586;for(;;){const _0x264fa9=$gameTemp[_0x5c18b5(0x749)]();if(_0x264fa9)this[_0x5c18b5(0xb46)](_0x264fa9);else break;}},Spriteset_Battle[_0x45d586(0x19f)]['createBattleBalloon']=function(_0x589f28){const _0xe771e1=_0x45d586,_0x1abeab=this[_0xe771e1(0x44b)](_0x589f28[_0xe771e1(0x371)]);if(_0x1abeab){let _0x39f835=null;Imported[_0xe771e1(0x57e)]&&Array[_0xe771e1(0x10a)](_0x589f28[_0xe771e1(0x825)])?_0x39f835=new Sprite_IconBalloon():_0x39f835=new Sprite_Balloon(),_0x39f835[_0xe771e1(0x180)]=_0x589f28[_0xe771e1(0x371)],_0x39f835[_0xe771e1(0x798)]=_0x1abeab,_0x39f835[_0xe771e1(0x798)]['_character']=_0x1abeab,_0x39f835[_0xe771e1(0x846)](_0x1abeab,_0x589f28[_0xe771e1(0x825)]),BattleManager[_0xe771e1(0x57a)](_0x39f835),this[_0xe771e1(0x297)][_0xe771e1(0x119)](_0x39f835);}},Spriteset_Battle[_0x45d586(0x19f)]['removeBattleBalloon']=function(_0x1fefda){const _0x226a28=_0x45d586;this[_0x226a28(0x297)]['remove'](_0x1fefda),BattleManager[_0x226a28(0x789)](_0x1fefda),_0x1fefda[_0x226a28(0x9ac)]();},Sprite_Battler[_0x45d586(0x19f)][_0x45d586(0x92d)]=function(_0x27557a,_0x5bcb5e){},Sprite_Battler[_0x45d586(0x19f)]['isSpriteVS8dir']=function(){return![];},Spriteset_Battle['prototype'][_0x45d586(0x853)]=function(){const _0x1e989f=_0x45d586;return this[_0x1e989f(0x297)]=this[_0x1e989f(0x297)]||[],this['_battleBalloonSprites'][_0x1e989f(0x1c9)]>0x0;},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x87b)]=Game_System[_0x45d586(0x19f)]['initialize'],Game_System[_0x45d586(0x19f)][_0x45d586(0x6d1)]=function(){const _0x4b028a=_0x45d586;VisuMZ[_0x4b028a(0x6fe)]['Game_System_initialize'][_0x4b028a(0x1b5)](this),this[_0x4b028a(0x3fa)]();},Game_System[_0x45d586(0x19f)][_0x45d586(0x3fa)]=function(){const _0x76bede=_0x45d586;this[_0x76bede(0x570)]=this[_0x76bede(0x570)]||[];},Game_System['prototype'][_0x45d586(0x672)]=function(){const _0x29c637=_0x45d586;if(this['_defeatedEnemies']===undefined)this[_0x29c637(0x3fa)]();return this['_defeatedEnemies'];},Game_System[_0x45d586(0x19f)][_0x45d586(0xa15)]=function(_0xad9b2d){const _0x588b62=_0x45d586;if(this[_0x588b62(0x570)]===undefined)this[_0x588b62(0x3fa)]();if(!_0xad9b2d)return;if(this[_0x588b62(0x570)][_0x588b62(0x840)](_0xad9b2d))return;this[_0x588b62(0x570)][_0x588b62(0x119)](_0xad9b2d),this['_defeatedEnemies'][_0x588b62(0x680)]((_0x47fc24,_0x39e5e2)=>_0x47fc24-_0x39e5e2);},VisuMZ['BattleCore'][_0x45d586(0x3b8)]=Game_BattlerBase[_0x45d586(0x19f)]['addNewState'],Game_BattlerBase['prototype'][_0x45d586(0x6fb)]=function(_0x453cb4){const _0x552894=_0x45d586,_0x4f10cc=this[_0x552894(0x45d)](),_0x25172a=this[_0x552894(0x5f7)]();VisuMZ[_0x552894(0x6fe)][_0x552894(0x3b8)]['call'](this,_0x453cb4),this[_0x552894(0x690)]()&&_0x4f10cc&&this[_0x552894(0x1e3)]()&&(this['_visualHpGauge_JustDied']=!this[_0x552894(0x5cd)](),$gameSystem[_0x552894(0xa15)](this[_0x552894(0x4a5)]())),SceneManager[_0x552894(0x81a)]()&&_0x25172a!==this['stateMotionIndex']()&&(this[_0x552894(0xa7b)]()&&this['battler']()[_0x552894(0x67b)]());},Game_Enemy[_0x45d586(0x19f)][_0x45d586(0x5cd)]=function(){const _0x536dc3=_0x45d586;return $gameSystem['getDefeatedEnemies']()['includes'](this[_0x536dc3(0x5d1)]);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x53c)]=Game_BattlerBase[_0x45d586(0x19f)][_0x45d586(0x3d5)],Game_BattlerBase['prototype'][_0x45d586(0x3d5)]=function(_0x43fde6){const _0x4c5212=_0x45d586;VisuMZ[_0x4c5212(0x6fe)]['Game_BattlerBase_eraseState']['call'](this,_0x43fde6),this[_0x4c5212(0x690)]()&&_0x43fde6===this[_0x4c5212(0x19d)]()&&this[_0x4c5212(0x45d)]()&&(this[_0x4c5212(0xe5)]=![]),!this[_0x4c5212(0xb94)]&&!this[_0x4c5212(0xba1)]&&SceneManager[_0x4c5212(0x81a)]()&&this['requestMotionRefresh']();},VisuMZ[_0x45d586(0x6fe)]['Game_Action_clear']=Game_Action[_0x45d586(0x19f)][_0x45d586(0xb8d)],Game_Action['prototype'][_0x45d586(0xb8d)]=function(){const _0x4a4584=_0x45d586;VisuMZ[_0x4a4584(0x6fe)][_0x4a4584(0xa99)][_0x4a4584(0x1b5)](this),this['_armorPenetration']={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x4a4584(0x97c)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this[_0x4a4584(0x68d)]=_0x4a4584(0x915),this[_0x4a4584(0xaad)]();},Game_Action[_0x45d586(0x19f)][_0x45d586(0xaad)]=function(){const _0x20b63b=_0x45d586;this[_0x20b63b(0x1cf)]='';},VisuMZ['BattleCore'][_0x45d586(0x999)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x70a)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x70a)]=function(_0x56298c){const _0x1797b4=_0x45d586;VisuMZ['BattleCore']['Game_Action_setSubject'][_0x1797b4(0x1b5)](this,_0x56298c),this[_0x1797b4(0xaad)]();},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x751)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x839)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x839)]=function(_0x4478a8){const _0x3bedcf=_0x45d586;VisuMZ[_0x3bedcf(0x6fe)]['Game_Action_setSkill'][_0x3bedcf(0x1b5)](this,_0x4478a8),this[_0x3bedcf(0xaad)]();},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x5bf)]=Game_Action['prototype'][_0x45d586(0x778)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x778)]=function(_0x20ef3a){const _0x47517e=_0x45d586;VisuMZ[_0x47517e(0x6fe)][_0x47517e(0x5bf)][_0x47517e(0x1b5)](this,_0x20ef3a),this['clearTargetBattlerKey']();},Game_Action['prototype'][_0x45d586(0x2b8)]=function(_0x2e4925,_0x5bc6f5){const _0x36bb42=_0x45d586;return VisuMZ[_0x36bb42(0x6fe)]['Settings'][_0x36bb42(0x244)][_0x36bb42(0x73d)][_0x36bb42(0x1b5)](this,_0x2e4925,_0x5bc6f5);},Game_Action[_0x45d586(0x19f)][_0x45d586(0xb0a)]=function(_0x522d9c,_0x1f272c){const _0x110767=_0x45d586;return VisuMZ['BattleCore'][_0x110767(0xa41)][_0x110767(0x244)][_0x110767(0x760)][_0x110767(0x1b5)](this,_0x522d9c,_0x1f272c);},Game_Action['prototype'][_0x45d586(0x3de)]=function(_0x1ae89d,_0x41bcfe){const _0x516460=_0x45d586;return VisuMZ[_0x516460(0x6fe)]['Settings'][_0x516460(0x244)][_0x516460(0x81d)][_0x516460(0x1b5)](this,_0x1ae89d,_0x41bcfe);},VisuMZ['BattleCore']['Game_Action_itemHit']=Game_Action[_0x45d586(0x19f)][_0x45d586(0x23f)],Game_Action['prototype'][_0x45d586(0x23f)]=function(_0x4d9f8e){const _0x2acf8c=_0x45d586,_0x16b0c0=this[_0x2acf8c(0xba9)]()[_0x2acf8c(0x34a)];if(_0x16b0c0[_0x2acf8c(0x95f)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x16b0c0[_0x2acf8c(0x95f)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x3a7fcb=VisuMZ[_0x2acf8c(0x6fe)][_0x2acf8c(0x14b)]['call'](this,_0x4d9f8e);return _0x3a7fcb=this[_0x2acf8c(0x97c)]['hitRate']*_0x3a7fcb+this[_0x2acf8c(0x97c)]['hitFlat'],$gameParty[_0x2acf8c(0x1d1)]()&&(_0x3a7fcb=this[_0x2acf8c(0x196)](_0x3a7fcb,_0x4d9f8e)),_0x3a7fcb;}}},VisuMZ[_0x45d586(0x6fe)]['Game_Action_updateLastTarget']=Game_Action['prototype']['updateLastTarget'],Game_Action[_0x45d586(0x19f)][_0x45d586(0x246)]=function(_0x36c8e7){const _0x3aa9c3=_0x45d586;this['_bypass_applyBattleCoreHitRateJS']=!![],VisuMZ[_0x3aa9c3(0x6fe)][_0x3aa9c3(0x72b)][_0x3aa9c3(0x1b5)](this,_0x36c8e7),this[_0x3aa9c3(0xa03)]=undefined;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x1c2)]=function(_0x40fb96){const _0x2d5ec0=_0x45d586;window['action']=this,window['a']=this['subject'](),window['b']=_0x40fb96,window[_0x2d5ec0(0xa02)]=this[_0x2d5ec0(0x3ac)](),window[_0x2d5ec0(0x371)]=_0x40fb96,window['obj']=this['item'](),window[_0x2d5ec0(0x76c)]=this[_0x2d5ec0(0xba9)](),window[_0x2d5ec0(0xba9)]=this[_0x2d5ec0(0xba9)]();},Game_Action[_0x45d586(0x19f)][_0x45d586(0x9da)]=function(_0x3446ca){const _0x24fc05=_0x45d586;window[_0x24fc05(0xaf9)]=undefined,window['a']=undefined,window['b']=undefined,window[_0x24fc05(0xa02)]=undefined,window[_0x24fc05(0x371)]=undefined,window['obj']=undefined,window[_0x24fc05(0x76c)]=undefined,window[_0x24fc05(0xba9)]=undefined;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x196)]=function(_0x2e978d,_0x32f6c4){const _0x5e4d3c=_0x45d586;if(this[_0x5e4d3c(0xa03)])return _0x2e978d;this['declareGlobalVariables'](_0x32f6c4);if(this[_0x5e4d3c(0xba9)]()){let _0x54e58c=VisuMZ[_0x5e4d3c(0x6fe)][_0x5e4d3c(0x2f1)](this[_0x5e4d3c(0xba9)](),'jsAccuracy');VisuMZ[_0x5e4d3c(0x6fe)]['JS'][_0x54e58c]&&(_0x2e978d=VisuMZ[_0x5e4d3c(0x6fe)]['JS'][_0x54e58c][_0x5e4d3c(0x1b5)](this,this[_0x5e4d3c(0x3ac)](),_0x32f6c4,this['item'](),_0x2e978d));}for(const _0x1c30d9 of this[_0x5e4d3c(0x3ac)]()[_0x5e4d3c(0xa0d)]()){if(!_0x1c30d9)continue;key=VisuMZ[_0x5e4d3c(0x6fe)][_0x5e4d3c(0x2f1)](_0x1c30d9,_0x5e4d3c(0x5d0)),VisuMZ[_0x5e4d3c(0x6fe)]['JS'][key]&&(_0x2e978d=VisuMZ[_0x5e4d3c(0x6fe)]['JS'][key][_0x5e4d3c(0x1b5)](this,this[_0x5e4d3c(0x3ac)](),_0x32f6c4,this[_0x5e4d3c(0xba9)](),_0x2e978d));}for(const _0x436aff of _0x32f6c4[_0x5e4d3c(0xa0d)]()){if(!_0x436aff)continue;key=VisuMZ['BattleCore'][_0x5e4d3c(0x2f1)](_0x436aff,_0x5e4d3c(0x22e)),VisuMZ[_0x5e4d3c(0x6fe)]['JS'][key]&&(_0x2e978d=VisuMZ[_0x5e4d3c(0x6fe)]['JS'][key][_0x5e4d3c(0x1b5)](this,this[_0x5e4d3c(0x3ac)](),_0x32f6c4,this[_0x5e4d3c(0xba9)](),_0x2e978d));}return this[_0x5e4d3c(0x9da)](_0x32f6c4),_0x2e978d;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x18e)]=function(_0x1e287c){const _0xf1f95=_0x45d586;if(!this[_0xf1f95(0xba9)]()[_0xf1f95(0xb5d)][_0xf1f95(0x1f7)])return 0x0;let _0x3a0030=VisuMZ[_0xf1f95(0x6fe)][_0xf1f95(0xa41)]['Damage'][_0xf1f95(0x763)][_0xf1f95(0x1b5)](this,_0x1e287c);return _0x3a0030=this['_multipliers'][_0xf1f95(0x4ae)]*_0x3a0030+this[_0xf1f95(0x97c)]['criticalHitFlat'],$gameParty[_0xf1f95(0x1d1)]()&&(_0x3a0030=this['applyBattleCoreCriticalHitRateJS'](_0x3a0030,_0x1e287c)),_0x3a0030;},Game_Action[_0x45d586(0x19f)]['applyBattleCoreCriticalHitRateJS']=function(_0x34707e,_0x4214e9){const _0x46db6b=_0x45d586;this[_0x46db6b(0x1c2)](_0x4214e9),window[_0x46db6b(0xa26)]=_0x34707e;{const _0x12828e=this[_0x46db6b(0x3ac)]()[_0x46db6b(0xa0d)]();for(const _0x204a79 of _0x12828e){if(!_0x204a79)continue;if(_0x204a79['note'][_0x46db6b(0x95f)](/<JS (?:CRITICAL RATE|CRI) AS USER>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS USER>/i)){const _0x534da0=String(RegExp['$1']);try{eval(_0x534da0);}catch(_0x3bc6b1){if($gameTemp[_0x46db6b(0x292)]())console[_0x46db6b(0x833)](_0x3bc6b1);}}}}{const _0x11326c=_0x4214e9['traitObjects']();for(const _0x2ef294 of _0x11326c){if(!_0x2ef294)continue;if(_0x2ef294['note'][_0x46db6b(0x95f)](/<JS (?:CRITICAL RATE|CRI) AS TARGET>\s*([\s\S]*?)\s*<\/JS (?:CRITICAL RATE|CRI) AS TARGET>/i)){const _0x32bc62=String(RegExp['$1']);try{eval(_0x32bc62);}catch(_0x46e3fe){if($gameTemp['isPlaytest']())console[_0x46db6b(0x833)](_0x46e3fe);}}}}return _0x34707e=window[_0x46db6b(0xa26)],this[_0x46db6b(0x9da)](_0x4214e9),_0x34707e;},Game_Action[_0x45d586(0x19f)]['applyBattleCoreCriticalHitRateJS']=function(_0x319933,_0x5b1de7){const _0x4ea006=_0x45d586;this[_0x4ea006(0x1c2)](_0x5b1de7);for(const _0x1ecdc8 of this[_0x4ea006(0x3ac)]()[_0x4ea006(0xa0d)]()){if(!_0x1ecdc8)continue;key=VisuMZ[_0x4ea006(0x6fe)]['createKeyJS'](_0x1ecdc8,_0x4ea006(0x7ab)),VisuMZ[_0x4ea006(0x6fe)]['JS'][key]&&(_0x319933=VisuMZ[_0x4ea006(0x6fe)]['JS'][key][_0x4ea006(0x1b5)](this,this[_0x4ea006(0x3ac)](),_0x5b1de7,this[_0x4ea006(0xba9)](),_0x319933));}for(const _0x23c62f of _0x5b1de7[_0x4ea006(0xa0d)]()){if(!_0x23c62f)continue;key=VisuMZ[_0x4ea006(0x6fe)][_0x4ea006(0x2f1)](_0x23c62f,_0x4ea006(0xb98)),VisuMZ[_0x4ea006(0x6fe)]['JS'][key]&&(_0x319933=VisuMZ[_0x4ea006(0x6fe)]['JS'][key][_0x4ea006(0x1b5)](this,this[_0x4ea006(0x3ac)](),_0x5b1de7,this[_0x4ea006(0xba9)](),_0x319933));}return this[_0x4ea006(0x9da)](_0x5b1de7),_0x319933;},Game_Action[_0x45d586(0x19f)]['applyCritical']=function(_0x14281a){const _0x15d4ab=_0x45d586;return _0x14281a=VisuMZ['BattleCore'][_0x15d4ab(0xa41)][_0x15d4ab(0x244)][_0x15d4ab(0x2a9)][_0x15d4ab(0x1b5)](this,_0x14281a),_0x14281a=this[_0x15d4ab(0x97c)][_0x15d4ab(0x7ac)]*_0x14281a+this[_0x15d4ab(0x97c)]['criticalDmgFlat'],_0x14281a;},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x396)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x649)],Game_Action['prototype'][_0x45d586(0x649)]=function(_0x4e8ccc){const _0x4f47f4=_0x45d586;if(this['_customDamageFormula']!==_0x4f47f4(0x915))return this['customDamageFormula'](_0x4e8ccc);else return DataManager[_0x4f47f4(0x64e)](this[_0x4f47f4(0xba9)]())===_0x4f47f4(0x5e1)?VisuMZ[_0x4f47f4(0x6fe)][_0x4f47f4(0x396)][_0x4f47f4(0x1b5)](this,_0x4e8ccc):this[_0x4f47f4(0x380)](_0x4e8ccc);},Game_Action['prototype'][_0x45d586(0x94f)]=function(_0x134a80){const _0x4ba424=_0x45d586;this[_0x4ba424(0x68d)]=_0x134a80;},Game_Action[_0x45d586(0x19f)]['customDamageFormula']=function(_0x6fd27a){const _0x3aca6e=_0x45d586,_0x427c9a=this[_0x3aca6e(0xba9)](),_0xe72ad4=_0x427c9a['damage'][_0x3aca6e(0x17a)];_0x427c9a[_0x3aca6e(0xb5d)][_0x3aca6e(0x17a)]=this[_0x3aca6e(0x68d)];let _0x2a26ef=VisuMZ['BattleCore'][_0x3aca6e(0x396)][_0x3aca6e(0x1b5)](this,_0x6fd27a);return _0x427c9a[_0x3aca6e(0xb5d)]['formula']=_0xe72ad4,_0x2a26ef;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x2a2)]=function(){const _0x36058d=_0x45d586;if(this[_0x36058d(0xba9)]()[_0x36058d(0x34a)][_0x36058d(0x95f)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x5f4458=String(RegExp['$1'])[_0x36058d(0x689)]()['trim']();return _0x5f4458;}return _0x36058d(0x5e1);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x380)]=function(_0x4103cb){const _0x322c1a=_0x45d586,_0x78d7f7=DataManager[_0x322c1a(0x64e)](this[_0x322c1a(0xba9)]()),_0x1aefbf=VisuMZ['DamageStyles'][_0x78d7f7];try{return _0x1aefbf[_0x322c1a(0x6e9)][_0x322c1a(0x1b5)](this,_0x4103cb);}catch(_0x5eebae){if($gameTemp[_0x322c1a(0x292)]())console[_0x322c1a(0x833)](_0x5eebae);return VisuMZ[_0x322c1a(0x6fe)][_0x322c1a(0x396)][_0x322c1a(0x1b5)](this);}},Game_Action[_0x45d586(0x19f)][_0x45d586(0x8f2)]=function(_0x53a273,_0x25dcd7){const _0x4fe2a1=_0x45d586;if(this[_0x4fe2a1(0x13a)]())return _0x25dcd7;const _0x554d4e=this[_0x4fe2a1(0x3ac)](),_0x220bd8=_0x53a273;let _0x4e3cce=[],_0x583e58=[];_0x4e3cce[_0x4fe2a1(0x119)](this[_0x4fe2a1(0xb73)][_0x4fe2a1(0x4e9)],this['_armorPenetration'][_0x4fe2a1(0x69a)]),_0x583e58[_0x4fe2a1(0x119)](this[_0x4fe2a1(0xb73)][_0x4fe2a1(0x11c)],this[_0x4fe2a1(0xb73)][_0x4fe2a1(0x1fb)]);const _0xa4ca13=this[_0x4fe2a1(0x560)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x1c1256=this['isPhysical']()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0x9ba039=this[_0x4fe2a1(0x560)]()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x50c9e8=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;return _0x4e3cce=_0x4e3cce[_0x4fe2a1(0xb10)](_0x220bd8[_0x4fe2a1(0xa0d)]()[_0x4fe2a1(0x7a1)](_0x4f9fea=>_0x4f9fea&&_0x4f9fea[_0x4fe2a1(0x34a)]['match'](_0xa4ca13)?Number(RegExp['$1']):0x0)),_0x583e58=_0x583e58['concat'](_0x220bd8[_0x4fe2a1(0xa0d)]()[_0x4fe2a1(0x7a1)](_0x5ab0a9=>_0x5ab0a9&&_0x5ab0a9[_0x4fe2a1(0x34a)][_0x4fe2a1(0x95f)](_0x1c1256)?Number(RegExp['$1'])/0x64:0x0)),_0x4e3cce=_0x4e3cce[_0x4fe2a1(0xb10)](_0x554d4e[_0x4fe2a1(0xa0d)]()[_0x4fe2a1(0x7a1)](_0x1ce1c6=>_0x1ce1c6&&_0x1ce1c6[_0x4fe2a1(0x34a)][_0x4fe2a1(0x95f)](_0x9ba039)?Number(RegExp['$1']):0x0)),_0x583e58=_0x583e58['concat'](_0x554d4e[_0x4fe2a1(0xa0d)]()[_0x4fe2a1(0x7a1)](_0x3d3302=>_0x3d3302&&_0x3d3302[_0x4fe2a1(0x34a)][_0x4fe2a1(0x95f)](_0x50c9e8)?Number(RegExp['$1'])/0x64:0x0)),this[_0x4fe2a1(0xba9)]()[_0x4fe2a1(0x34a)][_0x4fe2a1(0x95f)](_0x9ba039)&&_0x4e3cce[_0x4fe2a1(0x119)](Number(RegExp['$1'])),this[_0x4fe2a1(0xba9)]()[_0x4fe2a1(0x34a)]['match'](_0x50c9e8)&&_0x583e58[_0x4fe2a1(0x119)](Number(RegExp['$1'])),_0x25dcd7=_0x4e3cce[_0x4fe2a1(0x25e)]((_0x1550b6,_0x260151)=>_0x1550b6-_0x260151,_0x25dcd7),_0x25dcd7>0x0&&(_0x25dcd7=_0x583e58[_0x4fe2a1(0x25e)]((_0x4f781d,_0x403958)=>_0x4f781d*(0x1-_0x403958),_0x25dcd7)),_0x25dcd7;},VisuMZ[_0x45d586(0x6fe)]['Game_Action_executeDamage']=Game_Action[_0x45d586(0x19f)]['executeDamage'],Game_Action['prototype']['executeDamage']=function(_0x90defd,_0x9ecd56){const _0x8c65d0=_0x45d586;_0x9ecd56=_0x9ecd56*this[_0x8c65d0(0x97c)][_0x8c65d0(0xb79)],_0x9ecd56+=this[_0x8c65d0(0x97c)][_0x8c65d0(0x67f)]*(_0x9ecd56>=0x0?0x1:-0x1),_0x9ecd56=this[_0x8c65d0(0x3d9)](_0x8c65d0(0x2c5),_0x90defd,_0x9ecd56,![]),_0x9ecd56=this['applyDamageCaps'](_0x9ecd56),_0x9ecd56>0x0?_0x9ecd56=Math[_0x8c65d0(0xb32)](_0x9ecd56):_0x9ecd56=Math['floor'](_0x9ecd56),this['_executedValue']=_0x9ecd56,this[_0x8c65d0(0x71a)]=this[_0x8c65d0(0x71a)]||0x0,this[_0x8c65d0(0x71a)]+=_0x9ecd56,VisuMZ['BattleCore'][_0x8c65d0(0x63c)][_0x8c65d0(0x1b5)](this,_0x90defd,_0x9ecd56),this[_0x8c65d0(0x3d9)](_0x8c65d0(0x813),_0x90defd,_0x9ecd56,!![]);},Game_Action[_0x45d586(0x19f)][_0x45d586(0xbdf)]=function(_0x5d06b5){if(this['isBypassDamageCap']())return _0x5d06b5;return _0x5d06b5=this['applySoftDamageCap'](_0x5d06b5),_0x5d06b5=this['applyHardDamageCap'](_0x5d06b5),_0x5d06b5;},Game_Action[_0x45d586(0x19f)][_0x45d586(0xbd1)]=function(){const _0x2abc4e=_0x45d586,_0x54f323=/<BYPASS DAMAGE CAP>/i;if(this[_0x2abc4e(0xba9)]()[_0x2abc4e(0x34a)][_0x2abc4e(0x95f)](_0x54f323))return!![];if(this['subject']()['traitObjects']()['some'](_0x33fd0a=>_0x33fd0a&&_0x33fd0a[_0x2abc4e(0x34a)][_0x2abc4e(0x95f)](_0x54f323)))return!![];return!VisuMZ['BattleCore'][_0x2abc4e(0xa41)][_0x2abc4e(0x244)]['EnableDamageCap'];},Game_Action[_0x45d586(0x19f)]['applySoftDamageCap']=function(_0x456d46){const _0x5548e9=_0x45d586;if(!VisuMZ[_0x5548e9(0x6fe)]['Settings']['Damage']['EnableSoftCap'])return _0x456d46;const _0x1bbf01=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x5548e9(0xba9)]()[_0x5548e9(0x34a)][_0x5548e9(0x95f)](_0x1bbf01))return _0x456d46;if(this[_0x5548e9(0x3ac)]()[_0x5548e9(0xa0d)]()['some'](_0x1bb12d=>_0x1bb12d&&_0x1bb12d['note']['match'](_0x1bbf01)))return _0x456d46;const _0x32d231=_0x456d46<0x0?-0x1:0x1;_0x456d46=Math[_0x5548e9(0xb5e)](_0x456d46);let _0x4c9c31=this[_0x5548e9(0x3ac)]()[_0x5548e9(0x445)]();this['item']()['note']['match'](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x4c9c31+=Number(RegExp['$1'])/0x64);_0x4c9c31=_0x4c9c31['clamp'](0.01,0x1);const _0x9a56b=this['getHardDamageCap'](),_0x16b05a=_0x4c9c31*_0x9a56b;if(_0x456d46>_0x16b05a&&_0x9a56b>_0x16b05a){_0x456d46-=_0x16b05a;const _0x3b9465=VisuMZ[_0x5548e9(0x6fe)][_0x5548e9(0xa41)][_0x5548e9(0x244)][_0x5548e9(0x3bd)],_0x1caea7=Math[_0x5548e9(0x61a)](0x1-_0x456d46/((_0x9a56b-_0x16b05a)*_0x3b9465+_0x456d46),0.01);_0x456d46*=_0x1caea7,_0x456d46+=_0x16b05a;}return _0x456d46*_0x32d231;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x828)]=function(){const _0x332058=_0x45d586;return this['item']()[_0x332058(0x34a)]['match'](/<DAMAGE CAP:[ ](\d+)>/i)?Number(RegExp['$1']):this[_0x332058(0x3ac)]()['hardDamageCap']();},Game_Action['prototype'][_0x45d586(0x441)]=function(_0x2b6129){const _0x2271cf=_0x45d586;let _0x1971ee=this[_0x2271cf(0x828)]();return _0x2b6129[_0x2271cf(0xa3f)](-_0x1971ee,_0x1971ee);},Game_Action[_0x45d586(0x19f)]['shouldDisperseDamage']=function(){const _0x27413a=_0x45d586;if(!this[_0x27413a(0xba9)]())return![];if(!$gameParty[_0x27413a(0x1d1)]())return![];return(this[_0x27413a(0xba9)]()['note']||'')[_0x27413a(0x95f)](/<DISPERSE DAMAGE>/i);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x885)]=function(_0x44abb6){const _0x3ed23a=_0x45d586;if(this[_0x3ed23a(0x249)]()){let _0x5f0a14=BattleManager[_0x3ed23a(0x708)];_0x44abb6/=_0x5f0a14[_0x3ed23a(0x1c9)],this['isAttack']()&&(_0x44abb6*=this[_0x3ed23a(0x3ac)]()[_0x3ed23a(0xd8)]()+0x1),_0x44abb6=_0x44abb6>0x0?Math['ceil'](_0x44abb6):Math[_0x3ed23a(0x85a)](_0x44abb6);}return _0x44abb6;},VisuMZ[_0x45d586(0x6fe)]['Game_Action_makeDamageValueDisperse']=Game_Action[_0x45d586(0x19f)][_0x45d586(0x2b8)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x2b8)]=function(_0x1b782e,_0x307689){const _0x1a8a0e=_0x45d586;let _0x4b8d65=VisuMZ[_0x1a8a0e(0x6fe)][_0x1a8a0e(0x476)]['call'](this,_0x1b782e,_0x307689);return this[_0x1a8a0e(0x885)](_0x4b8d65);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x65d)]=function(_0x8c0cd,_0x3a5b8d){const _0x5f3221=_0x45d586;let _0x5d7ded=(_0x8c0cd['mhp']*_0x3a5b8d['value1']+_0x3a5b8d[_0x5f3221(0x93d)])*_0x8c0cd['rec'];_0x5d7ded=this[_0x5f3221(0x885)](_0x5d7ded),this[_0x5f3221(0x1c8)]()&&(_0x5d7ded*=this[_0x5f3221(0x3ac)]()[_0x5f3221(0x736)]),_0x5d7ded=Math[_0x5f3221(0x85a)](_0x5d7ded),_0x5d7ded!==0x0&&(_0x8c0cd['gainHp'](_0x5d7ded),this[_0x5f3221(0x5c3)](_0x8c0cd));},Game_Action['prototype'][_0x45d586(0xbc4)]=function(_0x40f1f7,_0x5b1ac7){const _0x2daa57=_0x45d586;let _0x58088d=(_0x40f1f7[_0x2daa57(0x13c)]*_0x5b1ac7[_0x2daa57(0x1ba)]+_0x5b1ac7[_0x2daa57(0x93d)])*_0x40f1f7[_0x2daa57(0x90a)];_0x58088d=this[_0x2daa57(0x885)](_0x58088d),this['isItem']()&&(_0x58088d*=this[_0x2daa57(0x3ac)]()[_0x2daa57(0x736)]),_0x58088d=Math[_0x2daa57(0x85a)](_0x58088d),_0x58088d!==0x0&&(_0x40f1f7[_0x2daa57(0x8ef)](_0x58088d),this[_0x2daa57(0x5c3)](_0x40f1f7));},Game_Action['prototype'][_0x45d586(0x667)]=function(_0x3904e3,_0x435364){const _0x4b463b=_0x45d586;let _0x27c709=Math[_0x4b463b(0x85a)](_0x435364[_0x4b463b(0x1ba)]);_0x27c709=this[_0x4b463b(0x885)](_0x27c709),_0x27c709!==0x0&&(_0x3904e3[_0x4b463b(0x732)](_0x27c709),this[_0x4b463b(0x5c3)](_0x3904e3));},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xbb8)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x6f1)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x6f1)]=function(_0x38daa8){const _0x3abe85=_0x45d586;if(_0x38daa8&&_0x38daa8[_0x3abe85(0x690)]())_0x38daa8[_0x3abe85(0xb84)]();this[_0x3abe85(0x3d9)]('PreApply%1JS',_0x38daa8,0x0,!![]),VisuMZ[_0x3abe85(0x6fe)][_0x3abe85(0xbb8)]['call'](this,_0x38daa8),this['applyBattleCoreJS']('PostApply%1JS',_0x38daa8,this['_executedValue']||0x0,!![]),this['applyResultSwitches'](_0x38daa8);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x3d9)]=function(_0xd58cb,_0x44e3e0,_0xf6fb17,_0x552465){const _0x3e8759=_0x45d586;if(this[_0x3e8759(0xba1)]||this[_0x3e8759(0xb94)])return;_0xf6fb17=_0xf6fb17||0x0;const _0x4b3bf6=_0xf6fb17,_0x3e7cf0=VisuMZ[_0x3e8759(0x6fe)]['Settings'][_0x3e8759(0x4c4)],_0x5254d2=_0xd58cb[_0x3e8759(0x534)]('');if(_0x3e7cf0[_0x5254d2]){_0xf6fb17=_0x3e7cf0[_0x5254d2][_0x3e8759(0x1b5)](this,_0xf6fb17,_0x44e3e0);if(_0x552465)_0xf6fb17=_0x4b3bf6;}let _0x490874=VisuMZ['BattleCore']['createKeyJS'](this[_0x3e8759(0xba9)](),_0xd58cb[_0x3e8759(0x534)](''));if(VisuMZ[_0x3e8759(0x6fe)]['JS'][_0x490874]){_0xf6fb17=VisuMZ[_0x3e8759(0x6fe)]['JS'][_0x490874][_0x3e8759(0x1b5)](this,this[_0x3e8759(0x3ac)](),_0x44e3e0,this[_0x3e8759(0xba9)](),_0xf6fb17);if(_0x552465)_0xf6fb17=_0x4b3bf6;}for(const _0x2b964e of this[_0x3e8759(0x3ac)]()[_0x3e8759(0xa0d)]()){if(!_0x2b964e)continue;_0x490874=VisuMZ[_0x3e8759(0x6fe)][_0x3e8759(0x2f1)](_0x2b964e,_0xd58cb[_0x3e8759(0x534)]('AsUser'));if(VisuMZ[_0x3e8759(0x6fe)]['JS'][_0x490874]){_0xf6fb17=VisuMZ[_0x3e8759(0x6fe)]['JS'][_0x490874][_0x3e8759(0x1b5)](this,this[_0x3e8759(0x3ac)](),_0x44e3e0,_0x2b964e,_0xf6fb17);if(_0x552465)_0xf6fb17=_0x4b3bf6;}}for(const _0x1417f6 of _0x44e3e0[_0x3e8759(0xa0d)]()){if(!_0x1417f6)continue;_0x490874=VisuMZ[_0x3e8759(0x6fe)][_0x3e8759(0x2f1)](_0x1417f6,_0xd58cb[_0x3e8759(0x534)](_0x3e8759(0x457)));if(VisuMZ['BattleCore']['JS'][_0x490874]){_0xf6fb17=VisuMZ[_0x3e8759(0x6fe)]['JS'][_0x490874][_0x3e8759(0x1b5)](this,this[_0x3e8759(0x3ac)](),_0x44e3e0,_0x1417f6,_0xf6fb17);if(_0x552465)_0xf6fb17=_0x4b3bf6;}}return _0xf6fb17;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x707)]=function(_0x3b07ec){const _0x550988=_0x45d586,_0x1afee4=this[_0x550988(0x71a)]||0x0,_0xb1719f=VisuMZ[_0x550988(0x6fe)][_0x550988(0xa41)]['Mechanics'],_0xc1f0c6=_0x3b07ec[_0x550988(0x534)]('');_0xb1719f[_0xc1f0c6]&&_0xb1719f[_0xc1f0c6][_0x550988(0x1b5)](this,_0x1afee4);let _0x8af9d4=VisuMZ[_0x550988(0x6fe)][_0x550988(0x2f1)](this[_0x550988(0xba9)](),_0x3b07ec);VisuMZ['BattleCore']['JS'][_0x8af9d4]&&VisuMZ[_0x550988(0x6fe)]['JS'][_0x8af9d4]['call'](this,this[_0x550988(0x3ac)](),this['subject'](),this[_0x550988(0xba9)](),_0x1afee4);for(const _0x2818a5 of this['subject']()['traitObjects']()){if(!_0x2818a5)continue;_0x8af9d4=VisuMZ['BattleCore'][_0x550988(0x2f1)](_0x2818a5,_0x3b07ec),VisuMZ[_0x550988(0x6fe)]['JS'][_0x8af9d4]&&VisuMZ[_0x550988(0x6fe)]['JS'][_0x8af9d4][_0x550988(0x1b5)](this,this['subject'](),this[_0x550988(0x3ac)](),_0x2818a5,_0x1afee4);}},Game_Action[_0x45d586(0x19f)][_0x45d586(0x9fd)]=function(){const _0x5d4b72=_0x45d586;return VisuMZ[_0x5d4b72(0x6fe)][_0x5d4b72(0xa41)][_0x5d4b72(0x4c4)]['CalcActionSpeedJS']['call'](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x76f)]=function(){const _0x369f86=_0x45d586;return VisuMZ[_0x369f86(0x6fe)]['Settings'][_0x369f86(0x4c4)][_0x369f86(0x41f)];},Game_Action[_0x45d586(0x19f)][_0x45d586(0x814)]=function(){const _0x51ba82=_0x45d586;if(this['_targetBattlerKey']===_0x51ba82(0x7a7))return![];if(this['_targetBattlerKey']===_0x51ba82(0x245))return![];if(!this['item']())return![];return this['item']()[_0x51ba82(0x34a)][_0x51ba82(0x95f)](/<JS TARGETS>/i);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x892)]=function(){const _0x59d1d5=_0x45d586;if(this[_0x59d1d5(0x1cf)]===_0x59d1d5(0x7a7))return![];if(this[_0x59d1d5(0x1cf)]===_0x59d1d5(0x245))return![];if(!this[_0x59d1d5(0x6cf)]&&this[_0x59d1d5(0x3ac)]()[_0x59d1d5(0xb4e)]())return![];if(this[_0x59d1d5(0x814)]())return!![];if(!this[_0x59d1d5(0xba9)]())return![];return typeof this[_0x59d1d5(0xba9)]()['scope']===_0x59d1d5(0x832);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x8eb)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x29f)],Game_Action['prototype']['isForOpponent']=function(){const _0x32b252=_0x45d586;if(this[_0x32b252(0x1cf)]===_0x32b252(0x7a7))return![];if(this[_0x32b252(0x1cf)]===_0x32b252(0x245))return!![];return this[_0x32b252(0x892)]()&&!this[_0x32b252(0x814)]()?this[_0x32b252(0x38f)]():VisuMZ[_0x32b252(0x6fe)][_0x32b252(0x8eb)][_0x32b252(0x1b5)](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x38f)]=function(){const _0x3f13ca=_0x45d586,_0x20da30=String(this[_0x3f13ca(0xba9)]()[_0x3f13ca(0x657)]);if(_0x20da30[_0x3f13ca(0x95f)](/ANY/i))return!![];return _0x20da30[_0x3f13ca(0x95f)](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x611)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x979)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x979)]=function(){const _0x554e0b=_0x45d586;if(this[_0x554e0b(0x1cf)]==='all\x20actors')return!![];if(this[_0x554e0b(0x1cf)]===_0x554e0b(0x245))return![];return this['isBattleCoreTargetScope']()&&!this[_0x554e0b(0x814)]()?this[_0x554e0b(0x364)]():VisuMZ[_0x554e0b(0x6fe)]['Game_Action_isForFriend']['call'](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x364)]=function(){const _0x335a65=_0x45d586,_0x1fa57c=String(this[_0x335a65(0xba9)]()[_0x335a65(0x657)]);return _0x1fa57c[_0x335a65(0x95f)](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x652)]=function(){const _0x327129=_0x45d586;if(this['isBattleCoreTargetScope']()&&!this[_0x327129(0x814)]()){const _0x407079=String(this['item']()['scope']);return _0x407079[_0x327129(0x95f)](/(?:ENEMY|FOE)/i)&&_0x407079[_0x327129(0x95f)](/OR/i)&&_0x407079[_0x327129(0x95f)](/(?:ALLY|FRIEND)/i);}else return![];},Game_Action['prototype']['isForAnyoneFocusFriends']=function(){const _0x213c1e=_0x45d586;if(this[_0x213c1e(0x652)]()){const _0x5d6fde=String(this[_0x213c1e(0xba9)]()[_0x213c1e(0x657)]);if(_0x5d6fde[_0x213c1e(0x95f)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action[_0x45d586(0x19f)][_0x45d586(0x4b2)]=function(){const _0x5e65ed=_0x45d586;if(this[_0x5e65ed(0x652)]()){const _0x5670fc=String(this[_0x5e65ed(0xba9)]()[_0x5e65ed(0x657)]);if(_0x5670fc[_0x5e65ed(0x95f)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}return![];},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x4c1)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x674)],Game_Action['prototype'][_0x45d586(0x674)]=function(){const _0x278dab=_0x45d586;if(this[_0x278dab(0x1cf)]===_0x278dab(0x7a7))return!![];return this['isBattleCoreTargetScope']()&&!this[_0x278dab(0x814)]()?this[_0x278dab(0x908)]():VisuMZ[_0x278dab(0x6fe)][_0x278dab(0x4c1)][_0x278dab(0x1b5)](this);},VisuMZ[_0x45d586(0x6fe)]['Game_Action_isForDeadFriend']=Game_Action['prototype'][_0x45d586(0x99b)],Game_Action[_0x45d586(0x19f)]['isForDeadFriend']=function(){const _0x394cc9=_0x45d586;if(this[_0x394cc9(0x1cf)]===_0x394cc9(0x7a7))return VisuMZ[_0x394cc9(0x6fe)][_0x394cc9(0x224)][_0x394cc9(0x1b5)](this);return VisuMZ['BattleCore'][_0x394cc9(0x224)][_0x394cc9(0x1b5)](this);},Game_Action['prototype'][_0x45d586(0x908)]=function(){const _0x16cb8c=_0x45d586;if(this[_0x16cb8c(0x652)]())return!![];return![];},Game_Action['prototype'][_0x45d586(0x998)]=function(){const _0x4b067f=_0x45d586;return this[_0x4b067f(0xba9)]()&&this[_0x4b067f(0xba9)]()['note'][_0x4b067f(0x95f)](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x2b4)]=Game_Action[_0x45d586(0x19f)]['isForOne'],Game_Action[_0x45d586(0x19f)]['isForOne']=function(){const _0x359f28=_0x45d586;if(this[_0x359f28(0x1cf)]===_0x359f28(0x7a7))return![];if(this[_0x359f28(0x1cf)]===_0x359f28(0x245))return![];return this[_0x359f28(0x892)]()&&!this[_0x359f28(0x814)]()?this[_0x359f28(0x42a)]():VisuMZ[_0x359f28(0x6fe)]['Game_Action_isForOne'][_0x359f28(0x1b5)](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x42a)]=function(){const _0x25d0d1=_0x45d586;if(this[_0x25d0d1(0x652)]())return!![];return![];},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x327)]=Game_Action[_0x45d586(0x19f)]['isForRandom'],Game_Action[_0x45d586(0x19f)]['isForRandom']=function(){const _0x29d372=_0x45d586;if(this[_0x29d372(0x1cf)]===_0x29d372(0x7a7))return![];if(this[_0x29d372(0x1cf)]==='all\x20enemies')return![];return this[_0x29d372(0x892)]()&&!this[_0x29d372(0x814)]()?this[_0x29d372(0xa8d)]():VisuMZ[_0x29d372(0x6fe)][_0x29d372(0x327)][_0x29d372(0x1b5)](this);},Game_Action['prototype'][_0x45d586(0xa8d)]=function(){const _0x429873=_0x45d586,_0xdb9337=String(this[_0x429873(0xba9)]()[_0x429873(0x657)]);return _0xdb9337['match'](/(?:RAND|RANDOM)/i);},VisuMZ[_0x45d586(0x6fe)]['Game_Action_isForAll']=Game_Action[_0x45d586(0x19f)]['isForAll'],Game_Action['prototype'][_0x45d586(0xb67)]=function(){const _0x2411e0=_0x45d586;if(this[_0x2411e0(0x1cf)]===_0x2411e0(0x7a7))return!![];if(this['_targetBattlerKey']===_0x2411e0(0x245))return!![];return VisuMZ[_0x2411e0(0x6fe)][_0x2411e0(0x5d8)][_0x2411e0(0x1b5)](this);},Game_Action['prototype'][_0x45d586(0x1f3)]=function(){const _0x1913dd=_0x45d586;if(!this['item']())return![];if(this[_0x1913dd(0x99b)]())return![];return(this[_0x1913dd(0xba9)]()[_0x1913dd(0x34a)]||'')[_0x1913dd(0x95f)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x5c5)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0xb55)],Game_Action[_0x45d586(0x19f)][_0x45d586(0xb55)]=function(_0x446b26){const _0x437b50=_0x45d586;if(this[_0x437b50(0x998)]()&&_0x446b26===this['subject']())return![];return VisuMZ[_0x437b50(0x6fe)][_0x437b50(0x5c5)]['call'](this,_0x446b26);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x715)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x752)],Game_Action['prototype'][_0x45d586(0x752)]=function(){const _0x4a18e8=_0x45d586,_0x59d9ba=VisuMZ[_0x4a18e8(0x6fe)]['Game_Action_itemTargetCandidates'][_0x4a18e8(0x1b5)](this);if(this[_0x4a18e8(0x998)]())_0x59d9ba['remove'](this[_0x4a18e8(0x3ac)]());return _0x59d9ba;},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x111)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x312)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x312)]=function(){const _0x2f367b=_0x45d586;return this['isBattleCoreTargetScope']()&&!this[_0x2f367b(0x814)]()?this[_0x2f367b(0x377)]():VisuMZ[_0x2f367b(0x6fe)][_0x2f367b(0x111)]['call'](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x377)]=function(){const _0x280678=_0x45d586,_0x2abd33=String(this[_0x280678(0xba9)]()['scope']);if(_0x2abd33[_0x280678(0x95f)](/RANDOM/i))return![];if(_0x2abd33[_0x280678(0x95f)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x2abd33[_0x280678(0x95f)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x2abd33[_0x280678(0x95f)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x2abd33[_0x280678(0x95f)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ[_0x280678(0x6fe)][_0x280678(0x111)][_0x280678(0x1b5)](this);},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x187)]=Game_Action['prototype'][_0x45d586(0x48b)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x48b)]=function(){const _0x14ccc5=_0x45d586;let _0x40cd69=[];return this[_0x14ccc5(0x892)]()?this[_0x14ccc5(0x814)]()?_0x40cd69=this[_0x14ccc5(0x872)]():_0x40cd69=this[_0x14ccc5(0xaff)]():_0x40cd69=VisuMZ[_0x14ccc5(0x6fe)]['Game_Action_makeTargets']['call'](this),_0x40cd69=this['applyTargetFilters'](_0x40cd69),_0x40cd69;},Game_Action['prototype'][_0x45d586(0x170)]=function(){const _0x4e35cc=_0x45d586;return this[_0x4e35cc(0x3ac)]()['isActor']()&&!this['subject']()['isAutoBattle']();},Game_Action['prototype'][_0x45d586(0x872)]=function(){const _0x4b5b7a=_0x45d586,_0x22040d=VisuMZ[_0x4b5b7a(0x6fe)][_0x4b5b7a(0x2f1)](this[_0x4b5b7a(0xba9)](),'Targets');if(VisuMZ[_0x4b5b7a(0x6fe)]['JS'][_0x22040d]){targets=VisuMZ[_0x4b5b7a(0x6fe)]['Game_Action_makeTargets']['call'](this);const _0x4e96ab=VisuMZ[_0x4b5b7a(0x6fe)][_0x4b5b7a(0x2f1)](this[_0x4b5b7a(0xba9)](),_0x4b5b7a(0xba0));return targets=VisuMZ[_0x4b5b7a(0x6fe)]['JS'][_0x4e96ab]['call'](this,this[_0x4b5b7a(0x3ac)](),targets),this[_0x4b5b7a(0x661)](targets);}return this[_0x4b5b7a(0xaff)]();},Game_Action['prototype'][_0x45d586(0xaff)]=function(){const _0x3e714e=_0x45d586;let _0x54b85b=[];const _0x4db42d=String(this[_0x3e714e(0xba9)]()[_0x3e714e(0x657)]);if(this[_0x3e714e(0x4b2)]())return this['isSubjectValidForAnyoneSelect']()?(_0x54b85b=this[_0x3e714e(0x5f5)](),this[_0x3e714e(0x661)](_0x54b85b)):(this['_targetIndex']=-0x1,_0x54b85b[_0x3e714e(0x119)](...this[_0x3e714e(0xb7a)]()),this[_0x3e714e(0x661)](_0x54b85b));if(this[_0x3e714e(0x92f)]()){if(this[_0x3e714e(0x170)]())return _0x54b85b=this['getBattlerKeyTargets'](),this['repeatTargets'](_0x54b85b);else{if(Imported[_0x3e714e(0x12c)]){if(VisuMZ['BattleAI'][_0x3e714e(0x23e)]<1.19){let _0x474840='';_0x474840+=_0x3e714e(0xa2c),_0x474840+='in\x20order\x20for\x20Ally\x20or\x20Enemy\x20targeting\x20to\x20work\x20',_0x474840+=_0x3e714e(0x87c),alert(_0x474840),SceneManager[_0x3e714e(0x16f)]();}}return this[_0x3e714e(0x157)]=-0x1,_0x54b85b['push'](...this[_0x3e714e(0x592)]()),this[_0x3e714e(0x661)](_0x54b85b);}}if(_0x4db42d[_0x3e714e(0x95f)](/(\d+) RANDOM ANY/i)){let _0xb49b98=Number(RegExp['$1']);while(_0xb49b98--){const _0x54c58a=Math[_0x3e714e(0x356)](0x2)===0x0?this[_0x3e714e(0x276)]():this[_0x3e714e(0x904)]();_0x54b85b[_0x3e714e(0x119)](_0x54c58a[_0x3e714e(0x6be)]());}return this[_0x3e714e(0x661)](_0x54b85b);}if(_0x4db42d[_0x3e714e(0x95f)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x41cdd4=Number(RegExp['$1']);while(_0x41cdd4--){_0x54b85b[_0x3e714e(0x119)](this[_0x3e714e(0x276)]()[_0x3e714e(0x6be)]());}return this[_0x3e714e(0x661)](_0x54b85b);}if(_0x4db42d[_0x3e714e(0x95f)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){let _0x5cac39=Number(RegExp['$1']);while(_0x5cac39--){_0x54b85b['push'](this['friendsUnit']()[_0x3e714e(0x6be)]());}return this[_0x3e714e(0x661)](_0x54b85b);}if(_0x4db42d[_0x3e714e(0x95f)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i))return _0x54b85b[_0x3e714e(0x119)](...this[_0x3e714e(0x904)]()[_0x3e714e(0x60c)]()['filter'](_0x39d812=>_0x39d812!==this[_0x3e714e(0x3ac)]())),this[_0x3e714e(0x661)](_0x54b85b);return VisuMZ[_0x3e714e(0x6fe)]['Game_Action_makeTargets']['call'](this);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x9e7)]=function(_0x408070){const _0x11b45f=_0x45d586,_0x264bdb=[];for(let _0x4c38d7=0x0;_0x4c38d7<this[_0x11b45f(0x52c)]();_0x4c38d7++){_0x264bdb[_0x11b45f(0x119)](_0x408070[_0x11b45f(0x6be)]());}return _0x264bdb;},Game_Action[_0x45d586(0x19f)][_0x45d586(0x985)]=function(_0x331fad){const _0x5f041b=_0x45d586;if(!this[_0x5f041b(0xba9)]())return _0x331fad;const _0x27511a=this[_0x5f041b(0xba9)]()[_0x5f041b(0x34a)];if(this[_0x5f041b(0x998)]()){this[_0x5f041b(0xb67)]()&&_0x331fad[_0x5f041b(0x4e7)](this[_0x5f041b(0x3ac)]());if(_0x331fad[_0x5f041b(0x840)](this['subject']())){const _0x23490d=this[_0x5f041b(0x904)]()[_0x5f041b(0x60c)]()[_0x5f041b(0x4e7)](this['subject']());if(_0x23490d[_0x5f041b(0x1c9)]>0x0){_0x23490d[_0x5f041b(0x680)]((_0x193df0,_0x72b88)=>_0x193df0['hpRate']()-_0x72b88[_0x5f041b(0xb14)]());while(_0x331fad['includes'](this['subject']())){const _0x5bb68c=_0x331fad[_0x5f041b(0xa63)](this[_0x5f041b(0x3ac)]());_0x331fad[_0x5bb68c]=_0x23490d[Math['randomInt'](_0x23490d[_0x5f041b(0x1c9)])];}}else _0x331fad[_0x5f041b(0x4e7)](this[_0x5f041b(0x3ac)]());}}return _0x331fad;},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0x8de)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x1a3)],Game_Action['prototype'][_0x45d586(0x1a3)]=function(_0x581240,_0x1cbbfc){const _0x48b580=_0x45d586;VisuMZ['BattleCore'][_0x48b580(0x8de)][_0x48b580(0x1b5)](this,_0x581240,_0x1cbbfc);if(!_0x581240[_0x48b580(0x711)]())return;for(const _0x18a397 of this['subject']()['attackStates']()){if(_0x18a397===_0x581240[_0x48b580(0x19d)]()){let _0x57afed=_0x1cbbfc[_0x48b580(0x1ba)];_0x57afed*=_0x581240[_0x48b580(0xbbf)](_0x18a397),_0x57afed*=this['subject']()[_0x48b580(0x1dd)](_0x18a397),_0x57afed*=this['lukEffectRate'](_0x581240),Math[_0x48b580(0x201)]()<_0x57afed&&(_0x581240[_0x48b580(0xa73)]=!![],this[_0x48b580(0x5c3)](_0x581240));}}},VisuMZ[_0x45d586(0x6fe)]['Game_Action_itemEffectAddNormalState']=Game_Action[_0x45d586(0x19f)][_0x45d586(0x8f5)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x8f5)]=function(_0xc30dc7,_0xe6cc3a){const _0x7dbe6d=_0x45d586;VisuMZ[_0x7dbe6d(0x6fe)][_0x7dbe6d(0x8b2)][_0x7dbe6d(0x1b5)](this,_0xc30dc7,_0xe6cc3a);if(!_0xc30dc7[_0x7dbe6d(0x711)]())return;if(_0xe6cc3a['dataId']!==_0xc30dc7[_0x7dbe6d(0x19d)]())return;let _0x2ed1a1=_0xe6cc3a['value1'];!this[_0x7dbe6d(0x13a)]()&&(_0x2ed1a1*=_0xc30dc7[_0x7dbe6d(0xbbf)](_0xe6cc3a[_0x7dbe6d(0x70b)]),_0x2ed1a1*=this[_0x7dbe6d(0x899)](_0xc30dc7)),Math[_0x7dbe6d(0x201)]()<_0x2ed1a1&&(_0xc30dc7['_deathStateApplied']=!![],this['makeSuccess'](_0xc30dc7));},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xaf3)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x29a)],Game_Action[_0x45d586(0x19f)][_0x45d586(0x29a)]=function(){const _0x20eb1a=_0x45d586;VisuMZ[_0x20eb1a(0x6fe)][_0x20eb1a(0xaf3)]['call'](this),this[_0x20eb1a(0x69f)](),this['resetResultSwitches']();},Game_Action[_0x45d586(0x19f)][_0x45d586(0x69f)]=function(){const _0x493fe8=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x4a131d=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x5d07b0=this[_0x493fe8(0xba9)]()[_0x493fe8(0x34a)]['match'](_0x4a131d);if(_0x5d07b0)for(const _0x5ef2ca of _0x5d07b0){if(!_0x5ef2ca)continue;_0x5ef2ca[_0x493fe8(0x95f)](_0x4a131d);const _0x431998=String(RegExp['$1'])[_0x493fe8(0xaea)](',')[_0x493fe8(0x7a1)](_0x355a05=>String(_0x355a05)['trim']()),_0x1c54cf=_0x431998[_0x493fe8(0x7a1)](_0x37ee72=>DataManager[_0x493fe8(0x468)](_0x37ee72));for(const _0x435abd of _0x1c54cf){const _0x239095=$dataCommonEvents[_0x435abd];_0x239095&&$gameTemp[_0x493fe8(0x485)](_0x435abd);}}},DataManager[_0x45d586(0x468)]=function(_0x223642){const _0x5ac850=_0x45d586;_0x223642=_0x223642[_0x5ac850(0x689)]()[_0x5ac850(0x379)](),this[_0x5ac850(0x8aa)]=this[_0x5ac850(0x8aa)]||{};if(this[_0x5ac850(0x8aa)][_0x223642])return this['_commonEventIDs'][_0x223642];for(const _0x44aaf2 of $dataCommonEvents){if(!_0x44aaf2)continue;let _0x198200=_0x44aaf2['name'];_0x198200=_0x198200[_0x5ac850(0x646)](/\x1I\[(\d+)\]/gi,''),_0x198200=_0x198200[_0x5ac850(0x646)](/\\I\[(\d+)\]/gi,''),this[_0x5ac850(0x8aa)][_0x198200[_0x5ac850(0x689)]()[_0x5ac850(0x379)]()]=_0x44aaf2['id'];}return this[_0x5ac850(0x8aa)][_0x223642]||0x0;},Game_Action[_0x45d586(0x19f)]['resetResultSwitches']=function(){const _0x129494=_0x45d586;if(!SceneManager['isSceneBattle']())return;const _0x35b0f7=VisuMZ[_0x129494(0x6fe)][_0x129494(0xa41)][_0x129494(0x4c4)];_0x35b0f7['SwitchCritical']&&$gameSwitches[_0x129494(0x177)](_0x35b0f7[_0x129494(0xafe)],![]),_0x35b0f7[_0x129494(0x72e)]&&$gameSwitches[_0x129494(0x177)](_0x35b0f7['SwitchMissEvade'],![]),_0x35b0f7[_0x129494(0x9fc)]&&$gameVariables[_0x129494(0x177)](_0x35b0f7[_0x129494(0x9fc)],0x0),_0x35b0f7[_0x129494(0x6a8)]&&$gameVariables[_0x129494(0x177)](_0x35b0f7[_0x129494(0x6a8)],0x0);},Game_Action[_0x45d586(0x19f)][_0x45d586(0x2f6)]=function(_0x3853e2){const _0x243551=_0x45d586;if(!SceneManager[_0x243551(0x81a)]())return;if(!_0x3853e2)return;const _0x15265c=_0x3853e2[_0x243551(0x116)](),_0x281d1c=VisuMZ[_0x243551(0x6fe)][_0x243551(0xa41)][_0x243551(0x4c4)];_0x281d1c['SwitchCritical']&&_0x15265c[_0x243551(0x1f7)]&&$gameSwitches[_0x243551(0x177)](_0x281d1c[_0x243551(0xafe)],!![]);_0x281d1c[_0x243551(0x72e)]&&(_0x15265c[_0x243551(0xa1f)]||_0x15265c[_0x243551(0x67e)])&&$gameSwitches['setValue'](_0x281d1c[_0x243551(0x72e)],!![]);if(_0x281d1c[_0x243551(0x9fc)]){let _0x2d8416=$gameVariables[_0x243551(0x72a)](_0x281d1c[_0x243551(0x9fc)]);_0x15265c[_0x243551(0x541)]>0x0&&(_0x2d8416+=Math[_0x243551(0xb5e)](_0x15265c[_0x243551(0x541)])),$gameVariables[_0x243551(0x177)](_0x281d1c[_0x243551(0x9fc)],_0x2d8416);}if(_0x281d1c[_0x243551(0x6a8)]){let _0x32f436=$gameVariables[_0x243551(0x72a)](_0x281d1c[_0x243551(0x6a8)]);_0x15265c['hpDamage']<0x0&&(_0x32f436+=Math[_0x243551(0xb5e)](_0x15265c[_0x243551(0x541)])),$gameVariables[_0x243551(0x177)](_0x281d1c[_0x243551(0x6a8)],_0x32f436);}},VisuMZ[_0x45d586(0x6fe)]['LifeStealRegExp']={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ[_0x45d586(0x6fe)][_0x45d586(0xa32)]=Game_Action[_0x45d586(0x19f)][_0x45d586(0x589)],Game_Action[_0x45d586(0x19f)]['executeHpDamage']=function(_0x5c519f,_0x2f0133){const _0x349845=_0x45d586;VisuMZ[_0x349845(0x6fe)][_0x349845(0xa32)]['call'](this,_0x5c519f,_0x2f0133);!this[_0x349845(0x1a8)]()&&_0x5c519f&&_0x5c519f['result']()[_0x349845(0x541)]>0x0&&this[_0x349845(0x699)]('HP',_0x5c519f,_0x5c519f[_0x349845(0x116)]()[_0x349845(0x541)]);if(_0x5c519f){this['_executeHpDamage']=this[_0x349845(0x202)]||{};const _0x621f9c=_0x5c519f[_0x349845(0x8da)]();this[_0x349845(0x202)][_0x621f9c]=_0x2f0133;}},Game_Action['prototype'][_0x45d586(0xb9a)]=function(_0x405738){const _0x3dcf57=_0x45d586;this['_executeHpDamage']=this[_0x3dcf57(0x202)]||{};const _0x4c2261=_0x405738[_0x3dcf57(0x8da)]();return this['_executeHpDamage'][_0x4c2261]||0x0;},VisuMZ['BattleCore'][_0x45d586(0xad1)]=Game_Action[_0x45d586(0x19f)]['executeMpDamage'],Game_Action[_0x45d586(0x19f)]['executeMpDamage']=function(_0x2267ae,_0x254af2){const _0x36f1ef=_0x45d586;VisuMZ[_0x36f1ef(0x6fe)][_0x36f1ef(0xad1)][_0x36f1ef(0x1b5)](this,_0x2267ae,_0x254af2),!this[_0x36f1ef(0x1a8)]()&&_0x2267ae&&_0x2267ae[_0x36f1ef(0x116)]()['mpDamage']>0x0&&this[_0x36f1ef(0x699)]('MP',_0x2267ae,_0x2267ae[_0x36f1ef(0x116)]()[_0x36f1ef(0x7fe)]);},Game_Action['prototype']['performLifeSteal']=function(_0x3201ad,_0x11cfed,_0x4736df){const _0xa5a96d=_0x45d586;_0x3201ad=_0x3201ad[_0xa5a96d(0x689)]()[_0xa5a96d(0x379)]();const _0xe3f7d6=this[_0xa5a96d(0xb82)](_0x3201ad,_0x11cfed);if(_0xe3f7d6<=0x0)return;const _0x252623=Math[_0xa5a96d(0x31d)](_0x4736df*_0xe3f7d6);if(_0x252623<=0x0)return;let _0x42518c=this[_0xa5a96d(0x3ac)]();if(this[_0xa5a96d(0x4ce)])_0x42518c=this[_0xa5a96d(0x4ce)];const _0x909714=_0x11cfed[_0xa5a96d(0x39d)](_0x3201ad)?-0x1:0x1;if(_0x3201ad==='HP')_0x42518c[_0xa5a96d(0x76e)](_0x909714*_0x252623);if(_0x3201ad==='MP')_0x42518c[_0xa5a96d(0x8ef)](_0x909714*_0x252623);},Game_Action['prototype'][_0x45d586(0xb82)]=function(_0x20ae0d,_0x7034cf){const _0x1cb463=_0x45d586;if(this['isCancelLifeSteal'](_0x20ae0d))return 0x0;if(this[_0x1cb463(0x3ac)]()['isDisarmLifeSteal'](_0x20ae0d))return 0x0;if(_0x7034cf[_0x1cb463(0x704)](_0x20ae0d))return 0x0;let _0x61885d=0x0;return _0x61885d+=this[_0x1cb463(0x89d)](_0x20ae0d),_0x61885d+=this[_0x1cb463(0x3ac)]()[_0x1cb463(0xb82)](_0x20ae0d,this[_0x1cb463(0xba9)]()['hitType']),_0x61885d[_0x1cb463(0xa3f)](0x0,0x1);},Game_Action['prototype'][_0x45d586(0xa65)]=function(_0x316613){const _0x398bf0=_0x45d586;_0x316613=_0x316613[_0x398bf0(0x689)]()[_0x398bf0(0x379)]();const _0x3d5f8e=VisuMZ[_0x398bf0(0x6fe)][_0x398bf0(0x2f2)],_0x2c5b08=this[_0x398bf0(0xba9)]()[_0x398bf0(0x34a)]||'';if(_0x2c5b08[_0x398bf0(0x95f)](_0x3d5f8e[_0x398bf0(0x7c1)]))return!![];if(_0x316613==='HP'&&_0x2c5b08[_0x398bf0(0x95f)](_0x3d5f8e[_0x398bf0(0x1b7)]))return!![];if(_0x316613==='MP'&&_0x2c5b08['match'](_0x3d5f8e[_0x398bf0(0xb30)]))return!![];return![];},Game_Action['prototype'][_0x45d586(0x89d)]=function(_0x3f6e8b){const _0xe71e7e=_0x45d586,_0x6df9cb=VisuMZ[_0xe71e7e(0x6fe)][_0xe71e7e(0x2f2)],_0x2e75c7=this[_0xe71e7e(0xba9)]()['note']||'';_0x3f6e8b=_0x3f6e8b[_0xe71e7e(0x689)]()[_0xe71e7e(0x379)]();const _0x108beb=_0x2e75c7[_0xe71e7e(0x95f)](_0x6df9cb[_0xe71e7e(0xb61)]);if(_0x108beb)for(const _0x1ef7a9 of _0x108beb){_0x1ef7a9[_0xe71e7e(0x95f)](_0x6df9cb[_0xe71e7e(0xb61)]);const _0xdc0d15=String(RegExp['$1'])[_0xe71e7e(0x689)]()[_0xe71e7e(0x379)]